/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.lang.TimeStep;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJRadioButton;

public class ComputationTimeStepDialog
extends RmaJDialog {
    protected int _computationTimeStepMins;
    protected Component _parent;
    protected RmaJRadioButton _defaultTimeStep;
    protected RmaJRadioButton _overrideTimeStep;
    protected RmaJComboBox timeTimeStepCombo;
    protected ButtonCmdPanel cmdPanel;
    protected boolean _canceled = true;

    public ComputationTimeStepDialog(Component parent) {
        this._parent = parent;
        this.build();
        this.setTitle("Computation Time Step");
        this.fillForm(-1);
    }

    public void fillForm(int computationTimeStepMins) {
        this._computationTimeStepMins = computationTimeStepMins;
        if (this._computationTimeStepMins > 0) {
            this._overrideTimeStep.setSelected(true);
            this.timeTimeStepCombo.setEnabled(true);
            if (this._computationTimeStepMins < 60) {
                String s = TimeStep.getTimeStepString(this._computationTimeStepMins, 1);
                this.timeTimeStepCombo.setSelectedItem(s);
            } else {
                int hrs = this._computationTimeStepMins / 60;
                String s = TimeStep.getTimeStepString(hrs, 2);
                this.timeTimeStepCombo.setSelectedItem(s);
            }
        } else {
            this._defaultTimeStep.setSelected(true);
            this.timeTimeStepCombo.setEnabled(false);
        }
    }

    public int getComputationTimeStepMins() {
        return this._computationTimeStepMins;
    }

    public String getComputationTimeStepString() {
        if (this._computationTimeStepMins <= 0) {
            return null;
        }
        String s = this.timeTimeStepCombo.getSelectedItem().toString();
        return s;
    }

    public boolean canceled() {
        return this._canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setModal(true);
            this.setLocationRelativeTo(this._parent);
            this.setSize(240, 130);
        }
        super.setVisible(visible);
    }

    protected void build() {
        this.getContentPane().setLayout(new GridLayout(1, 1));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getContentPane().add(panel);
        this._defaultTimeStep = new RmaJRadioButton("Use Default Time Step");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 5, 0, 0);
        panel.add((Component)this._defaultTimeStep, gbc);
        this._overrideTimeStep = new RmaJRadioButton("Select Time Step:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        panel.add((Component)this._overrideTimeStep, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._defaultTimeStep);
        bg.add(this._overrideTimeStep);
        JPanel intervalPanel = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        panel.add((Component)intervalPanel, gbc);
        JLabel label = new JLabel("Time Step:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS0505;
        intervalPanel.add((Component)label, gbc);
        this.timeTimeStepCombo = new RmaJComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS0505;
        intervalPanel.add((Component)this.timeTimeStepCombo, gbc);
        label = new JLabel("  ");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        intervalPanel.add((Component)label, gbc);
        label = new JLabel("  ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        panel.add((Component)label, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.cmdPanel, gbc);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        ComputationTimeStepDialog.this.okPressed();
                        break;
                    }
                    case 4: {
                        ComputationTimeStepDialog.this.cancelPressed();
                    }
                }
            }
        });
        String none = "-- none --";
        this.timeTimeStepCombo.addItem(none);
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(5, 1));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(10, 1));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(15, 1));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(20, 1));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(30, 1));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(1, 2));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(2, 2));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(3, 2));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(4, 2));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(6, 2));
        this.timeTimeStepCombo.addItem(TimeStep.getTimeStepString(12, 2));
        this.timeTimeStepCombo.setSelectedItem(none);
        this._defaultTimeStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComputationTimeStepDialog.this.timeTimeStepCombo.setEnabled(false);
            }
        });
        this._overrideTimeStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComputationTimeStepDialog.this.timeTimeStepCombo.setEnabled(true);
            }
        });
    }

    protected void okPressed() {
        if (this._overrideTimeStep.isSelected()) {
            String s = this.timeTimeStepCombo.getSelectedItem().toString();
            this._computationTimeStepMins = TimeStep.getTimeStepMinutes(s);
        } else {
            this._computationTimeStepMins = -1;
        }
        this._canceled = false;
        this.setVisible(false);
    }

    protected void cancelPressed() {
        this._canceled = true;
        this.setVisible(false);
    }
}

