/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.heclib.util.HecDouble;
import java.text.DecimalFormat;

public class ElapsedTime {
    protected static long _lastTime = 0L;
    protected static long _startTime = 0L;
    protected static DecimalFormat fm2 = new DecimalFormat("00");
    protected static DecimalFormat fm3 = new DecimalFormat("000");

    public static void printElapsedTime() {
        System.out.println(ElapsedTime.elapsedTime());
    }

    public static String elapsedTime() {
        return ElapsedTime.elapsedTime(false);
    }

    public static String elapsedTime(boolean difference) {
        if (_startTime == 0L) {
            ElapsedTime.startElapsedTime();
            return "Begin elapsed time";
        }
        long mils = difference ? ElapsedTime.elapsedTimeDiffMils() : ElapsedTime.elapsedTimeMils();
        long secs = mils / 1000L;
        mils -= secs * 1000L;
        long mins = secs / 60L;
        secs -= mins * 60L;
        long hours = mins / 60L;
        String result = fm2.format(hours) + ":" + fm2.format(mins -= hours * 60L) + ":" + fm2.format(secs) + "." + fm3.format(mils);
        return result;
    }

    public static String elapsedTimeDescription(boolean difference) {
        if (_startTime == 0L) {
            ElapsedTime.startElapsedTime();
            return "Begin elapsed time";
        }
        return "Elapsed time = " + ElapsedTime.elapsedTime(difference);
    }

    public static void startElapsedTime() {
        _startTime = _lastTime = System.nanoTime();
    }

    public static long elapsedTimeNanos(boolean difference) {
        long newTime = System.nanoTime();
        long diff = difference ? newTime - _lastTime : newTime - _startTime;
        _lastTime = newTime;
        return diff;
    }

    public static String elapsedTimeNanosString(boolean difference) {
        double value = ElapsedTime.elapsedTimeNanos(difference);
        return HecDouble.string(value, 0, true);
    }

    public static long elapsedTimeMils() {
        return ElapsedTime.elapsedTimeNanos(false) / 1000000L;
    }

    public static long elapsedTimeSecs() {
        return ElapsedTime.elapsedTimeNanos(false) / 1000000000L;
    }

    public static long elapsedTimeDiffMils() {
        return ElapsedTime.elapsedTimeNanos(true) / 1000000L;
    }

    public static long elapsedTimeDiffSecs() {
        return ElapsedTime.elapsedTimeNanos(true) / 1000000000L;
    }
}

