/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;

public class FileUtilities {
    public static String generateFileName(String name, String extension) {
        StringBuffer fileName = new StringBuffer(name + extension);
        int length = fileName.length();
        for (int i = 0; i < length; ++i) {
            char ch = fileName.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '+' || ch == '\\' || ch == '.') continue;
            fileName.setCharAt(i, '_');
        }
        return new String(fileName);
    }

    public static String appendNameToDirectory(String directory, String name) {
        if (directory == null || directory.length() == 0) {
            return name;
        }
        if (name == null || name.length() == 0) {
            return directory;
        }
        File tempFile = new File(name);
        if (tempFile.isAbsolute()) {
            return name;
        }
        String separator = System.getProperty("file.separator");
        if (directory.endsWith(separator)) {
            return directory + name;
        }
        return directory + separator + name;
    }

    public static String getPropertyFilePath(String filename) {
        String projFilePath = null;
        String osName = System.getProperty("os.name");
        osName = osName.toLowerCase();
        String userDir = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        if (osName.startsWith("windows")) {
            String roamDir = userDir + sep + "Application Data" + sep + "HEC" + sep + "HMS";
            projFilePath = roamDir + sep + filename;
        } else if (osName.startsWith("sunos")) {
            projFilePath = userDir + sep + filename;
        }
        return projFilePath;
    }

    public static String separateNameFromDirectory(String pathName) {
        File tempFile = new File(pathName);
        return tempFile.getName();
    }

    public static String separateDirectoryFromName(String pathName) {
        File tempFile = new File(pathName);
        return tempFile.getParent();
    }

    public static String separateExtensionFromname(String filename) {
        int index = filename.lastIndexOf(".");
        String ext = filename.substring(index + 1, filename.length());
        return ext;
    }

    public static String stripExtensionFromName(String filename) {
        int index = filename.lastIndexOf(".");
        String main = filename.substring(0, index);
        return main;
    }

    public static int copyFile(String fromFile, String toFile) throws FileNotFoundException, IOException {
        int c2;
        File inputFile = new File(fromFile);
        File outputFile = new File(toFile);
        if (inputFile.compareTo(outputFile) == 0) {
            return 0;
        }
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c2 = in.read()) != -1) {
            out.write(c2);
        }
        in.close();
        out.close();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File fromFile, File toFile) {
        if (fromFile == null || !fromFile.exists() || toFile == null) {
            return false;
        }
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fromFile);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(toFile);
        }
        catch (FileNotFoundException fnfe) {
            try {
                fin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        FileChannel inc = fin.getChannel();
        FileChannel outc = fout.getChannel();
        ByteBuffer bb = ByteBuffer.allocate(1024);
        try {
            int ret;
            while ((ret = inc.read(bb)) != -1) {
                bb.flip();
                outc.write(bb);
                bb.clear();
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtilities.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static Vector<File> listAllFiles(File path) {
        Vector<File> files = new Vector<File>();
        if (path.exists()) {
            if (path.isDirectory()) {
                File[] fl = path.listFiles();
                if (fl != null) {
                    if (fl.length == 0) {
                        files.add(path);
                    } else {
                        for (int i = 0; i < fl.length; ++i) {
                            if (fl[i].isDirectory()) {
                                files.addAll(FileUtilities.listAllFiles(fl[i]));
                                continue;
                            }
                            files.add(fl[i]);
                        }
                    }
                }
            } else if (path.isFile()) {
                files.add(path);
            }
        }
        return files;
    }

    public static int getUnixPcFileType(byte[] bytes, int len) {
        int numberCr = 0;
        int numberLf = 0;
        int numberCrLf = 0;
        int numberNonText = 0;
        for (int i = 0; i < len; ++i) {
            if (bytes[i] < 8) {
                ++numberNonText;
            }
            if (bytes[i] > 13 && bytes[i] < 30) {
                ++numberNonText;
            }
            if (bytes[i] == 10) {
                ++numberLf;
            }
            if (bytes[i] != 13) continue;
            ++numberCr;
            if (i + 1 >= len || bytes[i + 1] != 10) continue;
            ++numberCrLf;
        }
        if (numberNonText > 1) {
            return 0;
        }
        if (numberCr == 0 && numberLf > 0) {
            return 1;
        }
        if (numberCr > 0 && numberCr == numberCrLf) {
            return 2;
        }
        if (numberLf == 0) {
            return 0;
        }
        int diff = numberLf - numberCr;
        if (numberCr > 1 && diff < 4) {
            return 2;
        }
        if (numberLf > 1 && diff >= 4) {
            return 1;
        }
        if (numberCrLf > numberNonText) {
            return 2;
        }
        return 0;
    }

    public static byte[] translateUnixPcFile(int fileType, byte[] bytes, int len, int[] newLen) {
        newLen[0] = len;
        if (fileType != 1 && fileType != 2 || len <= 0) {
            return bytes;
        }
        byte[] newBytes = null;
        if (fileType == 1) {
            int numberLf = 0;
            for (int i = 0; i < len; ++i) {
                if (bytes[i] != 10) continue;
                ++numberLf;
            }
            newLen[0] = len + numberLf;
            newBytes = new byte[newLen[0]];
            int ipos = 0;
            for (int i = 0; i < len; ++i) {
                if (bytes[i] == 10) {
                    newBytes[ipos++] = 13;
                    newBytes[ipos++] = 10;
                    continue;
                }
                newBytes[ipos++] = bytes[i];
            }
        } else {
            int numberCrLf = 0;
            for (int i = 0; i < len; ++i) {
                if (bytes[i] != 13 || i + 1 >= len || bytes[i + 1] != 10) continue;
                ++numberCrLf;
            }
            int istart = 0;
            if (bytes[0] == 10) {
                istart = 1;
            }
            newLen[0] = len - numberCrLf - istart;
            newBytes = new byte[newLen[0]];
            int ipos = istart;
            for (int i = 0; i < newLen[0]; ++i) {
                if (bytes[ipos] == 13 && ipos + 1 < len && bytes[ipos + 1] == 10) {
                    newBytes[i] = 10;
                    ipos += 2;
                    continue;
                }
                newBytes[i] = bytes[ipos++];
            }
            int jpos = newLen[0] - 1;
            if (jpos >= 0 && jpos < newBytes.length && newBytes[jpos] == 13) {
                newBytes[jpos] = 10;
            }
        }
        return newBytes;
    }
}

