/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

public class FortranField {
    public int start;
    public int end;

    public FortranField(int startField, int endField) {
        this.start = startField;
        this.end = endField;
    }

    public static String[] parseFixedFormat(String line, FortranField[] fortranColumn) {
        return FortranField.parseFixedFormat(line, fortranColumn, "");
    }

    public static String[] parseFixedFormat(String line, FortranField[] fortranColumn, String emptyField) {
        String[] field = new String[fortranColumn.length];
        int len = line.length();
        for (int i = 0; i < fortranColumn.length; ++i) {
            FortranField ff = fortranColumn[i];
            int start = ff.start - 1;
            int end = ff.end;
            field[i] = end <= len ? line.substring(start, end).trim() : (start <= len ? line.substring(start, len).trim() : emptyField);
        }
        return field;
    }

    public static String toFixedFormat(String[] fields, FortranField[] fortranColumn) {
        FortranField ff = fortranColumn[fortranColumn.length - 1];
        int end = ff.end;
        StringBuffer sb = new StringBuffer(end);
        int ipos = 1;
        for (int i = 0; i < fortranColumn.length; ++i) {
            int pos;
            ff = fortranColumn[i];
            int beg = ff.start;
            end = ff.end;
            int len = fields[i].length();
            while (ipos < beg) {
                sb.append(' ');
                ++ipos;
            }
            if (len > 0) {
                sb.append(fields[i]);
                ipos += len;
            }
            if (ipos >= end) continue;
            for (int k = pos = ipos; k < end; ++k) {
                sb.append(' ');
                ++ipos;
            }
        }
        return sb.toString();
    }
}

