/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.heclib.util.stringContainer;
import hec.util.GeneralTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.FindDialog;
import rma.swing.FindListener;
import rma.swing.ReplaceDialog;
import rma.swing.ReplaceListener;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.table.MleHeadRenderer;
import rma.util.RMAFilenameFilter;

public class GeneralTableEditor
extends RmaJFrame
implements FindListener,
ReplaceListener {
    protected RmaJTable _table;
    protected GeneralTableModel _tableModel;
    protected Preferences _preferences = null;
    protected JMenuBar _menuBar;
    protected JMenu _fileMenu;
    protected JMenu _editMenu;
    protected JMenu _findMenu;
    protected JMenuItem _deleteRowItem;
    protected JMenuItem _moveRowUpItem;
    protected JMenuItem _moveRowDownItem;
    protected JMenuItem _browseItem;
    protected JMenuItem _save;
    protected JMenuItem _saveAs;
    public boolean _standAlone = false;
    protected ButtonCmdPanel _cmdPanel;
    protected FindDialog _findDialog = null;
    protected ReplaceDialog _replaceDialog = null;
    int[] colWidths = null;
    protected File _file = null;
    public File _saveFile = null;

    public GeneralTableEditor() {
        this.init();
    }

    protected void init() {
        this._tableModel = new GeneralTableModel();
        this._table = new RmaJTable(this){

            @Override
            public void setEditable(boolean editable) {
                super.setEditable(editable);
                TableModel model = this.getModel();
                if (model instanceof GeneralTableModel) {
                    ((GeneralTableModel)model).setEditable(editable);
                }
            }
        };
        this._table.setModel(this._tableModel);
        this.setDefaultCloseOperation(0);
    }

    public GeneralTableModel getTableModel() {
        return this._tableModel;
    }

    public RmaJTable getTable() {
        return this._table;
    }

    public ButtonCmdPanel getButtonCmdPanel() {
        return this._cmdPanel;
    }

    public void setCmdButtonText(String originalText, String newText) {
        JButton button = this._cmdPanel.getButton(originalText);
        if (button != null) {
            button.setText(newText);
        }
    }

    public void setTableEditable(boolean editable) {
        super.setEditable(editable);
        this._tableModel.setEditable(editable);
    }

    public void setFindVisible(boolean visible) {
        this._findMenu.setVisible(visible);
    }

    public void openFile() {
        if (!this.checkForChangedData()) {
            return;
        }
    }

    public void newFile() {
        if (!this.checkForChangedData()) {
            return;
        }
    }

    public void setRows(Vector rows) {
        this._tableModel.setRows(rows);
    }

    public Vector getRows() {
        return this._tableModel.getRows();
    }

    public void initialize(String[] headerNames, Vector rows) {
        this._tableModel.setColumnNames(headerNames);
        TableColumnModel tcm = this._table.getColumnModel();
        for (int i = 0; i < headerNames.length; ++i) {
            tcm.addColumn(new TableColumn(i));
        }
        this._table.setColumnLabels(headerNames);
        this.setRows(rows);
        this._table.setSelectionMode(2);
        this.build();
        MleHeadRenderer mleheadrend = new MleHeadRenderer();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setHeaderRenderer(mleheadrend);
        }
    }

    public boolean saveData() {
        this._table.exportData();
        return false;
    }

    protected boolean save(boolean saveAs) {
        this.stopEditing();
        if (saveAs) {
            JFileChooser chooser = new JFileChooser();
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            String dir = preferences.get("configdirectory", "");
            chooser = dir.length() > 0 ? new JFileChooser(dir) : new JFileChooser();
            chooser.setDialogTitle("Enter file to save to");
            chooser.setFileFilter(new RMAFilenameFilter("txt", "*.txt"));
            chooser.showOpenDialog(null);
            this._file = chooser.getSelectedFile();
            if (this._file == null) {
                return false;
            }
            this._saveFile = this._file;
            File curDir = chooser.getCurrentDirectory();
            preferences.put("configdirectory", curDir.getAbsolutePath());
            this._tableModel.setDataChanged(false);
        } else {
            this._tableModel.setDataChanged(true);
        }
        return this.saveData();
    }

    protected void build() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._table.setRowHeight(20);
        ListSelectionModel selectionModel = this._table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GeneralTableEditor.this.cellChanged();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)new JScrollPane(this._table), gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        this._cmdPanel.setApplyAlwaysOn(true);
        this._cmdPanel.getButton("OK").setText("Save to Disk");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this._cmdPanel, gbc);
        this.getContentPane().add(this._cmdPanel);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        GeneralTableEditor.this.okayButton();
                        break;
                    }
                    case 4: {
                        GeneralTableEditor.this.cancelButton();
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GeneralTableEditor.this.cancelButton();
            }
        });
        this.buildMenu();
    }

    protected void buildMenu() {
        this._menuBar = new JMenuBar();
        this._fileMenu = new JMenu("File");
        this._editMenu = new JMenu("Edit");
        this._findMenu = new JMenu("Find");
        this.buildFileMenu();
        this._menuBar.add(this._fileMenu);
        this.buildEditMenu();
        this._menuBar.add(this._editMenu);
        this.buildFindMenu();
        this._menuBar.add(this._findMenu);
        this._findMenu.setVisible(false);
        this.setJMenuBar(this._menuBar);
    }

    protected void buildFileMenu() {
        this._fileMenu.setMnemonic('f');
        JMenuItem menuItem = new JMenuItem("New", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.newFile();
            }
        });
        this._fileMenu.add(menuItem);
        menuItem = new JMenuItem("Open...", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.openFile();
            }
        });
        this._fileMenu.add(menuItem);
        menuItem = new JMenuItem("Close", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.close();
            }
        });
        this._fileMenu.add(menuItem);
        this._fileMenu.addSeparator();
        this._save = new JMenuItem("Save", 97);
        this._save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.save(false);
            }
        });
        this._fileMenu.add(this._save);
        this._saveAs = new JMenuItem("Save As...", 97);
        this._saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.save(true);
            }
        });
        this._fileMenu.add(this._saveAs);
    }

    protected void buildEditMenu() {
        this._editMenu.setMnemonic('e');
        JMenuItem menuItem = new JMenuItem("Add Row After", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.addRow();
            }
        });
        this._editMenu.add(menuItem);
        menuItem = new JMenuItem("Insert Row Before", 105);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.insertRow();
            }
        });
        this._editMenu.add(menuItem);
        this._deleteRowItem = new JMenuItem("Delete Rows", 100);
        this._deleteRowItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.deleteRows();
            }
        });
        this._editMenu.add(this._deleteRowItem);
        this._editMenu.addSeparator();
        this._moveRowUpItem = new JMenuItem("Move Row Up", 117);
        this._moveRowUpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.moveRowUp();
            }
        });
        this._editMenu.add(this._moveRowUpItem);
        this._moveRowDownItem = new JMenuItem("Move Row Down", 111);
        this._moveRowDownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.moveRowDown();
            }
        });
        this._editMenu.add(this._moveRowDownItem);
        this._deleteRowItem.setEnabled(false);
        this._moveRowUpItem.setEnabled(false);
        this._moveRowDownItem.setEnabled(false);
    }

    protected void buildFindMenu() {
        JMenuItem menuItem = new JMenuItem("Find...", 70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke("F3"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.find(e);
            }
        });
        this._findMenu.add(menuItem);
        menuItem = new JMenuItem("Replace...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralTableEditor.this.replace(e);
            }
        });
        this._findMenu.add(menuItem);
    }

    protected void cellChanged() {
        this.checkMenuItemsEnabled();
    }

    protected void insertRow() {
        this.stopEditing();
        int selected = this._table.getSelectedRow();
        if (selected >= 0) {
            this._tableModel.addRow(selected);
            this._table.setRowSelectionInterval(selected, selected);
        } else {
            this.addRow();
        }
    }

    public void addRow() {
        this._tableModel.addRow(this._tableModel.getRowCount());
        this._table.setRowSelectionInterval(this._tableModel.getRowCount() - 1, this._tableModel.getRowCount() - 1);
        this._tableModel.setDataChanged(true);
    }

    protected void deleteRows() {
        this.stopEditing();
        int[] rows = this._table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            this._tableModel.removeRow(rows[i]);
        }
        int selected = rows[0];
        if (selected == this._tableModel.getRowCount()) {
            --selected;
        }
        if (this._tableModel.getRowCount() > 0) {
            this._table.setRowSelectionInterval(selected, selected);
        } else {
            this._table.clearSelection();
        }
        this.cellChanged();
        this._tableModel.setDataChanged(true);
    }

    protected void moveRowUp() {
        this.stopEditing();
        int selected = this._table.getSelectedRow();
        if (selected > 0) {
            this._tableModel.moveRowUp(selected);
            this._table.setRowSelectionInterval(selected - 1, selected - 1);
        }
        this.cellChanged();
        this._tableModel.setDataChanged(true);
    }

    protected void moveRowDown() {
        this.stopEditing();
        int selected = this._table.getSelectedRow();
        if (selected >= 0 && selected < this._tableModel.getRowCount() - 1) {
            this._tableModel.moveRowDown(selected);
            this._table.setRowSelectionInterval(selected + 1, selected + 1);
        }
        this.cellChanged();
        this._tableModel.setDataChanged(true);
    }

    protected void stopEditing() {
        TableCellEditor cellEditor = this._table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
            Object value = cellEditor.getCellEditorValue();
            int row = this._table.getEditingRow();
            int col = this._table.getEditingColumn();
            if (row > -1 && col > -1) {
                this._table.setValueAt(value, row, col);
            }
        }
    }

    protected void okayButton() {
        try {
            boolean success = this.save(false);
            if (!success) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
    }

    public boolean checkForChangedData() {
        this.stopEditing();
        if (this._tableModel.getDataChanged()) {
            int opt = JOptionPane.showConfirmDialog(this, "Data has been modfied.\nDo you want to save it?", this.getTitle(), 1);
            if (opt == 2) {
                return false;
            }
            if (opt == 0) {
                this.save(true);
            }
        }
        return true;
    }

    protected void cancelButton() {
        if (!this.checkForChangedData()) {
            return;
        }
        this.close();
    }

    protected void close() {
        if (this._standAlone) {
            System.exit(0);
        }
        this.dispose();
    }

    protected void browse() {
        this.stopEditing();
        stringContainer name = new stringContainer();
        String filename = this.browseForFile(name);
        if (filename == null) {
            return;
        }
        String fname = name.string;
        this.addItem(fname, filename);
    }

    protected void checkMenuItemsEnabled() {
        int selected = this._table.getSelectedRow();
        if (selected >= 0) {
            this._deleteRowItem.setEnabled(true);
            this._moveRowUpItem.setEnabled(true);
            this._moveRowDownItem.setEnabled(true);
        } else {
            this._deleteRowItem.setEnabled(false);
            this._moveRowUpItem.setEnabled(false);
            this._moveRowDownItem.setEnabled(false);
        }
        if (selected == 0) {
            this._moveRowUpItem.setEnabled(false);
        }
        if (selected >= this._tableModel.getRowCount() - 1) {
            this._moveRowDownItem.setEnabled(false);
        }
    }

    protected void addItem(String name, String filename) {
        int row = 0;
        int[] rows = this._table.getSelectedRows();
        if (rows.length == 0) {
            row = this._table.getRowCount() - 1;
            if (row < 0) {
                this.addRow();
                row = 0;
            } else {
                String loc = this._table.getValueAt(row, 1).toString().trim();
                if (loc.length() > 0) {
                    this.addRow();
                    ++row;
                }
            }
        } else {
            row = rows[0];
            int[] columns = this._table.getSelectedColumns();
            if (columns.length > 0) {
                boolean addOne = true;
                for (int i = 0; i < columns.length; ++i) {
                    if (columns[i] != 1) continue;
                    addOne = false;
                }
                if (addOne) {
                    this._tableModel.addRow(++row);
                }
            }
        }
        this._table.setValueAt(filename, row, 1);
        String displayName = this._table.getValueAt(row, 0).toString().trim();
        if (displayName.length() == 0) {
            this._table.setValueAt(name, row, 0);
        }
        this._table.setRowSelectionInterval(row, row);
        this._table.setColumnSelectionInterval(0, 0);
        this._tableModel.fireTableRowsUpdated(row, row);
    }

    protected String browseForFile(stringContainer name) {
        String dir;
        if (this._preferences == null) {
            this._preferences = Preferences.userNodeForPackage(this.getClass());
        }
        JFileChooser chooser = (dir = this._preferences.get("directory", "")).length() > 0 ? new JFileChooser(dir) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle("Enter file");
        chooser.showOpenDialog(null);
        File file = chooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        File curDir = chooser.getCurrentDirectory();
        this._preferences.put("directory", curDir.getAbsolutePath());
        String filename = file.getAbsolutePath();
        name.string = file.getName();
        return filename;
    }

    protected void updateEdits() {
        AbstractCellEditor cellEditor = null;
        cellEditor = (AbstractCellEditor)((Object)this._table.getCellEditor());
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    public void selectAll() {
        this.updateEdits();
        this._table.selectAll();
    }

    public void replace(ActionEvent event) {
        boolean f3Key = false;
        if (event != null && event.getModifiers() == 0) {
            f3Key = true;
        }
        if (this._replaceDialog == null) {
            f3Key = false;
            this._replaceDialog = new ReplaceDialog((Frame)this, false, this);
            this._replaceDialog.setLocationRelativeTo(this);
        }
        if (f3Key) {
            this._replaceDialog.findNext();
        } else {
            this._replaceDialog.pack();
            this._replaceDialog.setVisible(true);
        }
    }

    public void find(ActionEvent event) {
        boolean f3Key = false;
        if (event != null && event.getModifiers() == 0) {
            f3Key = true;
        }
        if (this._findDialog == null) {
            f3Key = false;
            this._findDialog = new FindDialog((Frame)this, false, this);
            this._findDialog.setLocationRelativeTo(this);
        }
        if (f3Key) {
            this._findDialog.findNext();
        } else {
            this._findDialog.pack();
            this._findDialog.setVisible(true);
        }
    }

    @Override
    public boolean selectFirstRecord(String match, boolean wrap, boolean wholeWord, boolean caseSensitive) {
        int startingRow = this._table.getSelectedRow();
        if (startingRow < 0) {
            startingRow = 0;
        }
        if ((startingRow = this._table.convertRowIndexToModel(startingRow)) < 0) {
            startingRow = 0;
        }
        int startingColumn = this._table.getSelectedColumn() + 1;
        return this.search(match, wholeWord, caseSensitive, true, startingRow, startingColumn);
    }

    @Override
    public boolean selectLastRecord(String match, boolean wholeWord, boolean caseSensitive) {
        int startingRow = this._table.getSelectedRow();
        if (startingRow < 0) {
            startingRow = 0;
        }
        if ((startingRow = this._table.convertRowIndexToModel(startingRow)) < 0) {
            startingRow = 0;
        }
        int startingColumn = this._table.getSelectedColumn() - 1;
        return this.search(match, wholeWord, caseSensitive, false, startingRow, startingColumn);
    }

    protected boolean search(String match, boolean wholeWord, boolean caseSensitive, boolean down, int startingRow, int startingColumn) {
        int firstColumn = 0;
        Dimension rowCol = new Dimension();
        boolean found = this._tableModel.search(match, startingRow, startingColumn, firstColumn, wholeWord, caseSensitive, down, rowCol);
        if (found) {
            this._table.setColumnSelectionInterval(rowCol.width, rowCol.width);
            this._table.setRowSelectionInterval(rowCol.height, rowCol.height, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceFirstRecord(String match, String replaceText, boolean wrap, boolean wholeWord, boolean caseSensitive) {
        int startingRow = this._table.getSelectedRow();
        if (startingRow < 0) {
            startingRow = 0;
        }
        if ((startingRow = this._table.convertRowIndexToModel(startingRow)) < 0) {
            startingRow = 0;
        }
        int startingColumn = this._table.getSelectedColumn();
        return this.replace(match, replaceText, wholeWord, caseSensitive, true, startingRow, startingColumn);
    }

    @Override
    public boolean replaceLastRecord(String match, String replaceText, boolean wholeWord, boolean caseSensitive) {
        int startingRow = this._table.getSelectedRow();
        if (startingRow < 0) {
            startingRow = 0;
        }
        if ((startingRow = this._table.convertRowIndexToModel(startingRow)) < 0) {
            startingRow = 0;
        }
        int startingColumn = this._table.getSelectedColumn();
        return this.replace(match, replaceText, wholeWord, caseSensitive, false, startingRow, startingColumn);
    }

    protected boolean replace(String findStr, String replaceStr, boolean wholeWord, boolean caseSensitive, boolean down, int startingRow, int startingColumn) {
        int firstColumn = 0;
        Dimension rowCol = new Dimension();
        boolean found = this._tableModel.replace(findStr, replaceStr, startingRow, startingColumn, firstColumn, wholeWord, caseSensitive, down, rowCol);
        if (found) {
            this._tableModel.fireTableDataChanged();
            this._table.setColumnSelectionInterval(rowCol.width, rowCol.width);
            this._table.setRowSelectionInterval(rowCol.height, rowCol.height, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceAll(String findStr, String replaceStr, boolean wholeWordOnly, boolean caseSensitive) {
        boolean found = this._tableModel.replaceAll(findStr, replaceStr, 0, 0, wholeWordOnly, caseSensitive);
        if (found) {
            this._tableModel.fireTableDataChanged();
        }
        return found;
    }

    class Close
    implements ActionListener {
        Close() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GeneralTableEditor.this.close();
        }
    }
}

