/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import java.awt.Dimension;
import java.util.Vector;
import rma.swing.table.RmaTableModel;

public class GeneralTableModel
extends RmaTableModel {
    protected String[] colNames = new String[0];
    protected Vector _rows = new Vector();
    protected boolean _dataChanged = false;
    protected boolean _editable = false;

    public GeneralTableModel(String[] columnNames) {
        this.setColumnNames(columnNames);
    }

    public GeneralTableModel() {
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public boolean getEditable() {
        return this._editable;
    }

    @Override
    public void setColumnNames(String[] columnNames) {
        this.colNames = columnNames;
        super.setColumnNames(columnNames);
    }

    @Override
    public int getColumnCount() {
        if (this.colNames.length > 0) {
            return this.colNames.length;
        }
        return super.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    public void setRows(Vector rows) {
        if (rows != null) {
            this._rows = new Vector(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                String[] r = (String[])rows.elementAt(i);
                String[] r2 = new String[r.length];
                for (int j = 0; j < r.length; ++j) {
                    r2[j] = r[j];
                }
                this._rows.add(r2);
            }
        }
        this.fireTableDataChanged();
    }

    public Vector getRows() {
        return this._rows;
    }

    @Override
    public Class getColumnClass(int column) {
        Object obj = this.getValueAt(0, column);
        if (obj == null) {
            return String.class;
        }
        return obj.getClass();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this._rows == null) {
            return "";
        }
        if (row >= this._rows.size()) {
            return "";
        }
        if (row < 0) {
            return "";
        }
        String[] s = (String[])this._rows.elementAt(row);
        if (column >= s.length) {
            return "";
        }
        if (s[column] == null) {
            return "";
        }
        return s[column];
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        if (this._rows == null) {
            return;
        }
        if (row >= this._rows.size()) {
            return;
        }
        String[] s = (String[])this._rows.elementAt(row);
        s[column] = object.toString();
        this._dataChanged = true;
    }

    @Override
    public String getColumnName(int column) {
        if (this.colNames == null) {
            return "";
        }
        if (column < this.colNames.length) {
            return this.colNames[column];
        }
        return "";
    }

    public void addRow(int row) {
        String[] s = new String[this.getColumnCount()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = "";
        }
        this._rows.add(row, s);
        this.fireTableRowsInserted(row, row);
        this._dataChanged = true;
    }

    public void removeRow(int row) {
        if (row < this._rows.size()) {
            this._rows.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
        this._dataChanged = true;
    }

    public void moveRowUp(int row) {
        if (row == 0) {
            return;
        }
        Object obj1 = this._rows.elementAt(row - 1);
        Object obj2 = this._rows.elementAt(row);
        this._rows.set(row - 1, obj2);
        this._rows.set(row, obj1);
        this.fireTableRowsUpdated(row - 1, row);
        this._dataChanged = true;
    }

    public void moveRowDown(int row) {
        if (row >= this._rows.size() - 1) {
            return;
        }
        Object obj1 = this._rows.elementAt(row);
        Object obj2 = this._rows.elementAt(row + 1);
        this._rows.set(row + 1, obj1);
        this._rows.set(row, obj2);
        this.fireTableRowsUpdated(row, row + 1);
        this._dataChanged = true;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._editable;
    }

    public void setDataChanged(boolean dataChanged) {
        this._dataChanged = dataChanged;
    }

    public boolean getDataChanged() {
        return this._dataChanged;
    }

    public boolean search(String findStr, int startingRow, int startingColumn, int firstColumn, boolean wholeWordOnly, boolean caseSensitive, boolean down, Dimension rowCol) {
        return this.searchReplace(findStr, "", false, startingRow, startingColumn, firstColumn, wholeWordOnly, caseSensitive, down, rowCol);
    }

    public boolean replace(String findStr, String replaceStr, int startingRow, int startingColumn, int firstColumn, boolean wholeWordOnly, boolean caseSensitive, boolean down, Dimension rowCol) {
        return this.searchReplace(findStr, replaceStr, true, startingRow, startingColumn, firstColumn, wholeWordOnly, caseSensitive, down, rowCol);
    }

    protected boolean searchReplace(String findStr, String replaceStr, boolean replace, int startingRow, int startingColumn, int firstColumn, boolean wholeWordOnly, boolean caseSensitive, boolean down, Dimension rowCol) {
        int nrows = this.getRowCount();
        int ncols = this.getColumnCount();
        if (!caseSensitive) {
            findStr = findStr.toLowerCase();
        }
        if (down) {
            for (int i = startingRow; i < nrows; ++i) {
                for (int j = firstColumn; j < ncols; ++j) {
                    if (i == startingRow && j < startingColumn) continue;
                    String cell = this.getValueAt(i, j).toString();
                    if (!caseSensitive) {
                        cell = cell.toLowerCase();
                    }
                    if (cell.indexOf(findStr) < 0 || wholeWordOnly && !cell.equals(findStr)) continue;
                    rowCol.width = j;
                    rowCol.height = i;
                    if (replace) {
                        int idx = cell.indexOf(findStr);
                        if (!caseSensitive) {
                            cell = this.getValueAt(i, j).toString();
                        }
                        Object newCell = "";
                        if (idx > 0) {
                            newCell = cell.substring(0, idx);
                        }
                        newCell = (String)newCell + replaceStr;
                        int len = idx + findStr.length();
                        if (len < cell.length()) {
                            newCell = (String)newCell + cell.substring(len);
                        }
                        this.setValueAt(newCell, i, j);
                    }
                    return true;
                }
            }
        } else {
            for (int i = startingRow; i >= 0; --i) {
                for (int j = ncols - 1; j >= firstColumn; --j) {
                    if (i == startingRow && j > startingColumn) continue;
                    String cell = this.getValueAt(i, j).toString();
                    if (!caseSensitive) {
                        cell = cell.toLowerCase();
                    }
                    if (cell == null || cell.indexOf(findStr) < 0 || wholeWordOnly && !cell.equals(findStr)) continue;
                    rowCol.width = j;
                    rowCol.height = i;
                    if (replace) {
                        int idx = cell.indexOf(findStr);
                        if (!caseSensitive) {
                            cell = this.getValueAt(i, j).toString();
                        }
                        Object newCell = "";
                        if (idx > 0) {
                            newCell = cell.substring(0, idx);
                        }
                        newCell = (String)newCell + replaceStr;
                        int len = idx + findStr.length();
                        if (len < cell.length()) {
                            newCell = (String)newCell + cell.substring(len);
                        }
                        this.setValueAt(newCell, i, j);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean replaceAll(String findStr, String replaceStr, int firstColumn, int firstRow, boolean wholeWordOnly, boolean caseSensitive) {
        boolean found = false;
        int nrows = this.getRowCount();
        int ncols = this.getColumnCount();
        if (!caseSensitive) {
            findStr = findStr.toLowerCase();
        }
        for (int i = firstRow; i < nrows; ++i) {
            for (int j = firstColumn; j < ncols; ++j) {
                String cell = this.getValueAt(i, j).toString();
                if (!caseSensitive) {
                    cell = cell.toLowerCase();
                }
                if (cell.indexOf(findStr) < 0 || wholeWordOnly && !cell.equals(findStr)) continue;
                int idx = cell.indexOf(findStr);
                if (!caseSensitive) {
                    cell = this.getValueAt(i, j).toString();
                }
                Object newCell = "";
                if (idx > 0) {
                    newCell = cell.substring(0, idx);
                }
                newCell = (String)newCell + replaceStr;
                int len = idx + findStr.length();
                if (len < cell.length()) {
                    newCell = (String)newCell + cell.substring(len);
                }
                this.setValueAt(newCell, i, j);
                found = true;
            }
        }
        return found;
    }
}

