/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.zip.CRC32;
import rma.util.RMAIO;

public class HashFileInfo {
    private File _file;
    private BufferedWriter _writer;
    CRC32 _crc;

    public HashFileInfo(String fileName) {
        try {
            this._file = File.createTempFile("hash", ".tmp");
            this._file.deleteOnExit();
            System.out.println("HashFileInfo:file is " + this._file.getAbsolutePath());
            this._writer = new BufferedWriter(new FileWriter(this._file));
            this._writer.write(RMAIO.getFileFromPath(fileName));
            this._writer.newLine();
            this._crc = new CRC32();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveHash(byte[] data, int dataLength) {
        if (this._writer == null) {
            return;
        }
        try {
            if (data == null) {
                this._writer.write("-1");
            } else {
                this._crc.update(data, 0, dataLength);
                this._writer.write(String.valueOf(this._crc.getValue()));
                this._crc.reset();
            }
            this._writer.newLine();
        }
        catch (IOException ioe) {
            System.out.println("saveHash:error writing " + ioe);
        }
    }

    public void close() {
        if (this._writer != null) {
            try {
                this._writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

