/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.io.DataContainer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class PhotoViewerInfo
extends DataContainer
implements Cloneable,
Serializable {
    public String name = "";
    public String url = "";
    public double refreshInterval = -1.0;
    public boolean showing = false;
    public boolean fade = false;
    public boolean hasFrame = true;
    public double xSize = 1.0;
    public double ySize = 1.0;
    public boolean remote = false;
    public BufferedImage bufferedImage = null;
    public String[] modeNames = null;
    public boolean[] modeUsed = null;

    public PhotoViewerInfo() {
    }

    public PhotoViewerInfo(String[] modenames, boolean initialValue, boolean makeSetupFalse) {
        this.addModes(modenames, initialValue, makeSetupFalse);
    }

    public void loadFromMemory(byte[] memoryImage) throws Exception {
        ByteArrayInputStream ba = new ByteArrayInputStream(memoryImage);
        this.bufferedImage = ImageIO.read(ba);
    }

    public void addModes(String[] modenames, boolean initialValue, boolean makeSetupFalse) {
        if (modenames == null) {
            return;
        }
        this.modeUsed = new boolean[modenames.length];
        this.modeNames = new String[modenames.length];
        for (int i = 0; i < modenames.length; ++i) {
            this.modeNames[i] = modenames[i];
            this.modeUsed[i] = initialValue;
            if (!makeSetupFalse || this.modeNames[i].indexOf("Setup") <= -1) continue;
            this.modeUsed[i] = false;
        }
    }

    public Object clone() {
        PhotoViewerInfo pvInfo = new PhotoViewerInfo();
        this.clone(pvInfo);
        return pvInfo;
    }

    public void clone(PhotoViewerInfo pvInfo) {
        int i;
        super.clone(pvInfo);
        pvInfo.name = this.name;
        pvInfo.url = this.url;
        pvInfo.refreshInterval = this.refreshInterval;
        pvInfo.showing = this.showing;
        pvInfo.fade = this.fade;
        pvInfo.hasFrame = this.hasFrame;
        pvInfo.xSize = this.xSize;
        pvInfo.ySize = this.ySize;
        pvInfo.remote = this.remote;
        pvInfo.bufferedImage = this.bufferedImage;
        if (this.modeNames != null) {
            pvInfo.modeNames = new String[this.modeNames.length];
            for (i = 0; i < this.modeNames.length; ++i) {
                pvInfo.modeNames[i] = this.modeNames[i];
            }
        }
        if (this.modeUsed != null) {
            pvInfo.modeUsed = new boolean[this.modeUsed.length];
            for (i = 0; i < this.modeUsed.length; ++i) {
                pvInfo.modeUsed[i] = this.modeUsed[i];
            }
        }
    }
}

