/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;

public class ProgressDialog
extends RmaJDialog {
    private JProgressBar _currentNumberProgress;
    private int _number;
    private JProgressBar _overallNumberProgress;
    private RmaJTextField _statusLine;
    private Runnable _runnable;
    private SetCurrentSizeRunner _setCurrentSizeRunner;
    private SetCurrentValueRunner _setCurrentValueRunner;
    private SetStatusRunner _setStatusRunner;
    private int _currentNumber = 0;
    private int _currentSize = 0;
    private int _currentValue = 0;
    protected boolean _multiProgress;
    protected boolean _canceled = false;

    public ProgressDialog(Dialog parentApp, int number, boolean multiProgress) {
        super(parentApp, false);
        this._number = number;
        this._multiProgress = multiProgress;
        this.buildControls();
    }

    public ProgressDialog(Frame parentApp, int number, boolean multiProgress) {
        super(parentApp, false);
        this._number = number;
        this._multiProgress = multiProgress;
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        if (this._number < 1) {
            this._currentNumberProgress = new JProgressBar();
            this._currentNumberProgress.setIndeterminate(true);
        } else {
            this._currentNumberProgress = new JProgressBar(0, 1);
            this._currentNumberProgress.setStringPainted(true);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._currentNumberProgress, gbc);
        this._overallNumberProgress = this._number < 1 ? new JProgressBar() : new JProgressBar(0, this._number);
        if (this._multiProgress) {
            this._overallNumberProgress.setString("Overall");
            this._overallNumberProgress.setStringPainted(true);
            ++gbc.gridy;
            this.getContentPane().add((Component)this._overallNumberProgress, gbc);
        }
        this._statusLine = new RmaJTextField();
        this._statusLine.setEditable(false);
        ++gbc.gridy;
        this.getContentPane().add((Component)this._statusLine, gbc);
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(4);
        cmdPanel.setApplyAlwaysOn(true);
        ++gbc.gridy;
        this.getContentPane().add((Component)cmdPanel, gbc);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 4: {
                        ProgressDialog.this.jButtonCancel_actionPerformed(event);
                    }
                }
            }
        });
        this.pack();
        Dimension d = this.getSize();
        d.width += 140;
        d.height += 20;
        this.setSize(d);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this._setCurrentSizeRunner = new SetCurrentSizeRunner();
        this._setCurrentValueRunner = new SetCurrentValueRunner();
        this._setStatusRunner = new SetStatusRunner();
    }

    public boolean canceled() {
        return this._canceled;
    }

    public void jButtonCancel_actionPerformed(ActionEvent event) {
        this._canceled = true;
    }

    public void setCurrentSize(int size) {
        this._currentSize = size;
        this._setCurrentSizeRunner.setCurrentSize(size);
        this.run(this._setCurrentSizeRunner);
    }

    public int getCurrentSize() {
        return this._currentSize;
    }

    public void setCurrentValue(int currentLocation) {
        this._currentValue = currentLocation;
        this._setCurrentValueRunner.setCurrentLocation(currentLocation);
        this.run(this._setCurrentValueRunner);
    }

    public int getCurrentValue() {
        return this._currentValue;
    }

    public void setStatusMessage(String msg) {
        this._setStatusRunner.setStatusMessage(msg);
        this.run(this._setStatusRunner);
    }

    public void setString(String msg) {
        this.setStatusMessage(msg);
    }

    private void run(Runnable run) {
        SwingUtilities.invokeLater(run);
    }

    public void setRunnable(Runnable run) {
        this._runnable = run;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setStatusMessage("Ready");
        }
        if (visible && this._runnable != null) {
            Thread t = new Thread(this._runnable);
            t.setPriority(3);
            t.start();
        }
    }

    class SetCurrentSizeRunner
    implements Runnable {
        int _size;

        SetCurrentSizeRunner() {
        }

        public void setCurrentSize(int size) {
            this._size = size;
        }

        @Override
        public void run() {
            ProgressDialog.this._overallNumberProgress.setValue(ProgressDialog.this._currentNumber++);
            ProgressDialog.this._currentNumberProgress.setMaximum(this._size);
            ProgressDialog.this._currentNumberProgress.setValue(0);
        }
    }

    class SetCurrentValueRunner
    implements Runnable {
        int _currentLocation;

        SetCurrentValueRunner() {
        }

        public void setCurrentLocation(int currentLocation) {
            this._currentLocation = currentLocation;
        }

        @Override
        public void run() {
            ProgressDialog.this._currentNumberProgress.setValue(this._currentLocation);
        }
    }

    class SetStatusRunner
    implements Runnable {
        String _msg;

        SetStatusRunner() {
        }

        public void setStatusMessage(String msg) {
            this._msg = msg;
        }

        @Override
        public void run() {
            ProgressDialog.this._statusLine.setText(this._msg);
        }
    }
}

