/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.util.SimulationEntry;
import hec.util.WatershedEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import rma.util.RMAIO;

public class SimTestConfigFile {
    private String _filename;
    private List<WatershedEntry> _watersheds = new ArrayList<WatershedEntry>();
    private String _baseDir;

    public SimTestConfigFile(String filename) {
        this._filename = filename;
    }

    public boolean loadFile() {
        File f = new File(this._filename);
        Document doc = this.loadDocument(f);
        if (doc != null) {
            return this.parseDocument(doc);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFile(String filename) {
        BufferedWriter writer;
        String fileToSaveTo = null;
        fileToSaveTo = filename != null ? filename : this._filename;
        if (fileToSaveTo == null) {
            return false;
        }
        Element root = new Element("Watersheds");
        if (this._baseDir != null) {
            root.setAttribute("baseDirectory", this._baseDir);
        }
        Document doc = new Document(root);
        for (int w = 0; w < this._watersheds.size(); ++w) {
            WatershedEntry we = this._watersheds.get(w);
            String path = we.getPath();
            Element weElement = new Element("Watershed");
            root.addContent((Content)weElement);
            path = RMAIO.getRelativePath(this._baseDir, path);
            weElement.setAttribute("WorkspacePath", path);
            List<SimulationEntry> sims = we.getSimulations();
            Element seElement = new Element("Simulations");
            weElement.addContent((Content)seElement);
            for (int s = 0; s < sims.size(); ++s) {
                SimulationEntry se = sims.get(s);
                se.save(seElement);
            }
        }
        try {
            writer = new BufferedWriter(new FileWriter(fileToSaveTo));
        }
        catch (IOException e2) {
            System.out.println("saveFile: IOException " + e2);
            e2.printStackTrace();
            return false;
        }
        System.out.println("saveFile:writing " + fileToSaveTo);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        try {
            outputter.output(doc, (Writer)writer);
        }
        catch (IOException e) {
            System.out.println("saveFile:IOException occurred writing to " + fileToSaveTo + " Error:" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    protected boolean parseDocument(Document doc) {
        this._watersheds.clear();
        Element root = doc.getRootElement();
        if (root == null) {
            return false;
        }
        if (!"Watersheds".equals(root.getName())) {
            System.out.println("loadDocument:not a valid file");
            return false;
        }
        this._baseDir = root.getAttributeValue("baseDirectory");
        List watersheds = root.getChildren();
        for (int i = 0; i < watersheds.size(); ++i) {
            WatershedEntry we = new WatershedEntry(this._baseDir);
            Element wkspElem = (Element)watersheds.get(i);
            if (!we.parse(wkspElem)) continue;
            System.out.println("parseDocument:added watershed " + we);
            this._watersheds.add(we);
        }
        return true;
    }

    public void setWatersheds(List<WatershedEntry> watersheds) {
        this._watersheds.clear();
        if (watersheds == null) {
            return;
        }
        this._watersheds.addAll(watersheds);
    }

    public List<WatershedEntry> getWatersheds() {
        return this._watersheds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document loadDocument(File file) {
        BufferedReader reader;
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            System.out.println("loadDocument:Document File " + file.getPath() + " doesn't exist");
            return null;
        }
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e1) {
            System.out.println("loadDocument: FileNotFoundException " + e1);
            return null;
        }
        if (reader == null) {
            System.out.println("loadDocument:failed to get reader for " + file.getPath());
            return null;
        }
        System.out.println("loadDocument:reading XML file " + file.getPath());
        try {
            Document doc;
            Document document = doc = this.loadDocument(reader);
            return document;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Document loadDocument(Reader reader) {
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(reader);
        }
        catch (JDOMException e) {
            System.out.println("loadDocument:JDOMException occurred reading XML file. Error:" + e);
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            System.out.println("loadDocument:NullPointerException occurred reading XLM file. Error:" + e);
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            System.out.println("loadDocument:IOException occurred reading XML File. Error:" + e);
            e.printStackTrace(System.out);
            return null;
        }
        return doc;
    }

    public String getBaseDirectory() {
        return this._baseDir;
    }

    public void setBaseDirectory(String path) {
        this._baseDir = path;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("USAGE:" + SimTestConfigFile.class.getName() + " filename");
            System.exit(1);
        }
        new SimTestConfigFile(args[0]);
    }
}

