/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.util.AlternativeEntry;
import hec.util.WatershedEntry;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import rma.util.RMAIO;

public class SimulationEntry {
    private WatershedEntry _wksp;
    private String _path;
    private List<AlternativeEntry> _alternatives = new ArrayList<AlternativeEntry>();

    public SimulationEntry(WatershedEntry parent) {
        this._wksp = parent;
    }

    public boolean parse(Element simElem) {
        String path = simElem.getAttributeValue("SimulationPath");
        if (path == null) {
            return false;
        }
        Element alternativesRoot = simElem.getChild("Alternatives");
        if (alternativesRoot == null) {
            return false;
        }
        this._path = path;
        List alternatives = alternativesRoot.getChildren();
        for (int i = 0; i < alternatives.size(); ++i) {
            AlternativeEntry ae;
            Element altElem = (Element)alternatives.get(i);
            if (altElem == null || !(ae = new AlternativeEntry(this)).parse(altElem)) continue;
            this._alternatives.add(ae);
        }
        return true;
    }

    public String getPath() {
        return this._path;
    }

    public List<AlternativeEntry> getAlternatives() {
        return this._alternatives;
    }

    public String toString() {
        return RMAIO.getFileNameNoExtension(this.getPath());
    }

    public void setPath(String path) {
        this._path = path;
    }

    public WatershedEntry getWatershed() {
        return this._wksp;
    }

    public void addAlternative(AlternativeEntry ae) {
        if (ae != null) {
            this._alternatives.add(ae);
        }
    }

    public boolean removeAlternative(AlternativeEntry ae) {
        return this._alternatives.remove(ae);
    }

    public void save(Element seElement) {
        Element simElement = new Element("Simulation");
        seElement.addContent((Content)simElement);
        simElement.setAttribute("SimulationPath", this.getPath());
        Element altElement = new Element("Alternatives");
        simElement.addContent((Content)altElement);
        List<AlternativeEntry> alts = this.getAlternatives();
        for (int a = 0; a < alts.size(); ++a) {
            AlternativeEntry aEntry = alts.get(a);
            aEntry.save(altElement);
        }
    }
}

