/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.dataTable.SavableDataFrame;
import hec.io.TextContainer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.FontChooser;
import rma.swing.SearchableJEditorPane;
import rma.swing.print.DocumentRenderer;
import rma.util.RMAIO;

public class TextDialog
extends JDialog
implements ActionListener {
    protected Component _parent;
    protected SearchableJEditorPane _textPane;
    protected TextContainer _textContainer = null;
    protected String _fileName = null;
    protected String _configurationManagerHelpString = null;
    protected JMenuBar _menuBar;
    protected JMenu _fileMenu;
    protected JMenuItem _saveItem;
    protected JMenuItem _saveAsItem;
    protected JMenuItem _saveAsTxtItem;
    protected JMenuItem _insertItem;
    protected JMenuItem _fontItem;
    protected JMenuItem _printSetupItem;
    protected JMenuItem _printItem;
    protected JMenuItem _exitItem;
    protected JMenuItem _findMenuItem;
    protected JMenuItem _findNextMenuItem;
    protected boolean _editMode = false;
    protected boolean _modal;
    protected boolean _saved = false;
    protected boolean _savedAs = false;
    protected ButtonCmdPanel _cmdPanel;
    protected JButton _saveButton;
    protected Font _font;
    protected boolean _saveSet = false;
    protected boolean _saveAsSet = false;
    final DocumentRenderer _renderer = new DocumentRenderer();
    private JMenu helpMenu = new JMenu("Help");
    private JMenuItem _helpMenuItem = new JMenuItem();
    static String HELPSET_NAME = null;
    static String HELPSET_LABEL = null;

    public TextDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this._parent = parent;
        this._modal = modal;
        this.buildMenu();
        this.buildFrame();
    }

    public TextDialog(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this._parent = parent;
        this._modal = modal;
        this.buildMenu();
        this.buildFrame();
    }

    public TextDialog(Component parent) {
        this._parent = parent;
        this._modal = false;
        this.buildMenu();
        this.buildFrame();
    }

    public TextDialog(Component parent, String configurationManagerHelpString) {
        this._parent = parent;
        this._modal = false;
        this._configurationManagerHelpString = configurationManagerHelpString;
        this.buildMenu();
        this.buildFrame();
    }

    protected void buildMenu() {
        this._menuBar = new JMenuBar();
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('F');
        this._menuBar.add(this._fileMenu);
        this._saveItem = new JMenuItem("Save", 115);
        this._saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this._saveItem.addActionListener(this);
        this._fileMenu.add(this._saveItem);
        this._saveAsItem = new JMenuItem("Save As...");
        this._saveAsItem.addActionListener(this);
        this._fileMenu.add(this._saveAsItem);
        this._saveAsTxtItem = new JMenuItem("Save As .txt ...");
        this._saveAsTxtItem.addActionListener(this);
        this._fileMenu.add(this._saveAsTxtItem);
        this._fileMenu.addSeparator();
        this._insertItem = new JMenuItem("Insert .txt file...", 73);
        this._insertItem.addActionListener(this);
        this._fileMenu.add(this._insertItem);
        this._fileMenu.addSeparator();
        this._fontItem = new JMenuItem("Font...", 70);
        this._fontItem.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
        this._fontItem.addActionListener(this);
        this._fileMenu.add(this._fontItem);
        this._printSetupItem = new JMenuItem("Print Setup...");
        this._printSetupItem.addActionListener(this);
        this._fileMenu.add(this._printSetupItem);
        this._printItem = new JMenuItem("Print...", 80);
        this._printItem.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        this._printItem.addActionListener(this);
        this._fileMenu.add(this._printItem);
        this._fileMenu.addSeparator();
        this._exitItem = new JMenuItem("Close", 67);
        this._exitItem.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        this._exitItem.addActionListener(this);
        this._fileMenu.add(this._exitItem);
        JMenu menu = new JMenu("Find");
        this._findMenuItem = new JMenuItem("Find", 70);
        this._findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
        this._findMenuItem.addActionListener(this);
        menu.add(this._findMenuItem);
        this._findNextMenuItem = new JMenuItem("Find Next", 78);
        this._findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0, false));
        this._findNextMenuItem.addActionListener(this);
        menu.add(this._findNextMenuItem);
        this._menuBar.add(menu);
        this.setJMenuBar(this._menuBar);
        this._menuBar.setVisible(true);
        if (this._configurationManagerHelpString != null) {
            this.setHelpSetLabel("HEC-DSSVue - Help");
            this.setHelpSetName("HEC-DSSVue");
            this.buildHelpSet("ListSelection.HelpOverviewMenu", this._configurationManagerHelpString);
        }
    }

    public void initialize(TextContainer textContainer, boolean editMode) {
        this._textContainer = textContainer;
        this.setTitle(textContainer.fullName);
        this._textPane.setText(textContainer.text);
        this.setEditMode(editMode);
    }

    public void initialize(String fileName, boolean editMode) throws Exception {
        this._fileName = fileName;
        try {
            FileReader fr = new FileReader(fileName);
            this._textPane.read(fr, null);
            fr.close();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        this.setTitle(this._fileName);
        this.setEditMode(editMode);
    }

    public void setEditMode(boolean editMode) {
        this._editMode = editMode;
        this._cmdPanel.setVisible(this._editMode);
        if (!this._saveSet) {
            this._saveAsItem.setVisible(this._editMode);
        }
        if (!this._saveAsSet) {
            this._saveItem.setVisible(this._editMode);
        }
        if (this._editMode && this._textContainer != null && (this._textContainer.fullName == null || this._textContainer.fullName.length() < 7)) {
            this._saveButton.setVisible(false);
        }
    }

    public void showMenuItems(boolean save, boolean saveAs, boolean insert, boolean print) {
        this._saveSet = true;
        this._saveAsSet = true;
        this._saveItem.setVisible(save);
        this._saveButton.setVisible(save);
        this._saveAsItem.setVisible(saveAs);
        this._cmdPanel.getButton(2).setVisible(saveAs);
        this._saveAsTxtItem.setVisible(saveAs);
        this._insertItem.setVisible(insert);
        this._printSetupItem.setVisible(print);
        this._printItem.setVisible(print);
    }

    protected void buildFrame() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this._font = new Font("Courier New", 0, 12);
        this._textPane = new SearchableJEditorPane();
        this._textPane.setContentType("text/plain");
        this._textPane.setFont(this._font);
        JScrollPane scrollPane = new JScrollPane(this._textPane);
        scrollPane.setVerticalScrollBarPolicy(22);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(scrollPane, gbc);
        this.getContentPane().add(scrollPane);
        this._cmdPanel = new ButtonCmdPanel(14);
        this._cmdPanel.setApplyAlwaysOn(true);
        this._saveButton = this._cmdPanel.getButton(8);
        this._saveButton.setText("Save");
        JButton jb = this._cmdPanel.getButton(2);
        jb.setText("Save As...");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this._cmdPanel, gbc);
        this.getContentPane().add(this._cmdPanel);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        TextDialog.this.save();
                        break;
                    }
                    case 2: {
                        TextDialog.this.saveAs();
                        break;
                    }
                    case 4: {
                        TextDialog.this.cancel();
                    }
                }
            }
        });
    }

    protected void save() {
        if (this._textContainer == null) {
            try {
                FileWriter fw = new FileWriter(this._fileName);
                this._textPane.write(fw);
                fw.close();
                this._saved = true;
                this.cancel();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Unable to save file " + e, "Save File", 2);
            }
            return;
        }
        if (this._textContainer.fullName == null || this._textContainer.fullName.length() < 7) {
            this.saveAs();
            return;
        }
        TextContainer tc = (TextContainer)this._textContainer.clone();
        tc.text = this._textPane.getText();
        tc.modified = true;
        boolean exitOK = false;
        if (this._parent instanceof SavableDataFrame) {
            exitOK = ((SavableDataFrame)((Object)this._parent)).save(tc);
        }
        if (exitOK) {
            this._saved = true;
            this.cancel();
        } else {
            this.toFront();
        }
    }

    protected void saveAs() {
        if (this._textContainer == null) {
            this.saveAsTxt();
        } else {
            TextContainer tc = (TextContainer)this._textContainer.clone();
            tc.text = this._textPane.getText();
            tc.modified = true;
            boolean exitOK = false;
            if (this._parent instanceof SavableDataFrame) {
                exitOK = ((SavableDataFrame)((Object)this._parent)).saveAs(tc);
            }
            if (exitOK) {
                this._savedAs = true;
                this.cancel();
            } else {
                this.toFront();
            }
        }
    }

    public boolean saved() {
        return this._saved;
    }

    public boolean savedAs() {
        return this._savedAs;
    }

    protected void find() {
        this._textPane.displayFindDialog();
    }

    protected void findNext() {
        this._textPane.search();
    }

    protected void saveAsTxt() {
        String dir = ".";
        if (this._fileName != null) {
            dir = RMAIO.getDirectoryFromPath(this._fileName);
        }
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setDialogTitle("Save " + this._fileName + " as:");
        int option = chooser.showOpenDialog(this);
        if (option != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(file);
            this._textPane.write(fw);
            fw.close();
            this._savedAs = true;
            this.cancel();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to save file " + e, "Save File", 2);
        }
    }

    protected void insertTxtFile() {
        String dir = ".";
        if (this._fileName != null) {
            dir = RMAIO.getDirectoryFromPath(this._fileName);
        }
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setDialogTitle("Insert");
        int option = chooser.showOpenDialog(this);
        if (option != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            FileReader reader = new FileReader(file);
            EditorKit kit = this._textPane.getEditorKit();
            Document doc = this._textPane.getDocument();
            int ipos = this._textPane.getCaretPosition();
            kit.read(reader, doc, ipos);
            reader.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to read file " + e, "Insert File", 2);
        }
    }

    protected void cancel() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this._exitItem) {
            this.Exit_Action();
        } else if (object == this._saveItem) {
            this.save();
        } else if (object == this._saveAsItem) {
            this.saveAs();
        } else if (object == this._saveAsTxtItem) {
            this.saveAsTxt();
        } else if (object == this._insertItem) {
            this.insertTxtFile();
        } else if (object == this._printSetupItem) {
            this.printSetup();
        } else if (object == this._printItem) {
            this.print();
        } else if (object == this._fontItem) {
            this.fontDialog();
        } else if (object == this._findMenuItem) {
            this.find();
        } else if (object == this._findNextMenuItem) {
            this.findNext();
        }
    }

    protected void Exit_Action() {
        this.terminate();
    }

    protected void terminate() {
        this.dispose();
    }

    protected void fontDialog() {
        FontChooser fc = new FontChooser((Dialog)this, "Select Font", true, this._font);
        Font font = fc.getSelectedFont();
        if (font != null) {
            this._font = font;
            this._textPane.setFont(this._font);
        }
    }

    public void printSetup() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TextDialog.this._renderer.pageDialog();
            }
        });
        thread.start();
    }

    public void print() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TextDialog.this._renderer.print(TextDialog.this._textPane);
            }
        });
        thread.start();
    }

    protected void buildHelpSet(String helpOverviewConstant, String ConfigurationManagerHelpString) {
    }

    protected void setHelpSetLabel(String helpsetLabel) {
        HELPSET_LABEL = helpsetLabel;
    }

    protected void setHelpSetName(String helpsetName) {
        HELPSET_NAME = helpsetName;
    }

    protected String getHelpSetLabel() {
        return HELPSET_LABEL;
    }

    protected String getHelpSetName() {
        return HELPSET_NAME;
    }

    protected String getApplicationHelpSetName() {
        return null;
    }

    protected JMenuItem getAppOverviewHelpMenu() {
        return null;
    }

    protected String getAppOverviewHelpFilename() {
        return null;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public void addHelpMenu(JMenuItem helpMenuItem) {
        if (helpMenuItem == null) {
            return;
        }
        this.helpMenu = this.getHelpMenu();
        if (this.helpMenu != null) {
            this.helpMenu.setMnemonic('H');
            this.helpMenu.add(helpMenuItem);
        }
    }
}

