/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class TextUtil {
    private static final int BASE64 = 1;
    private static final int[] encodings = new int[]{1};
    private static final String[] encodingNames = new String[]{"base64"};

    public static String[] split(String str, String delim, String opts) {
        return TextUtil.split(str, delim, opts, -1);
    }

    public static String[] split(String str, String delim) {
        return TextUtil.split(str, delim, -1);
    }

    public static String[] split(String str, String delim, String opts, int limit) {
        if (opts.equals("L")) {
            return TextUtil.split(str, delim, limit);
        }
        return Pattern.compile(delim, TextUtil.getFlags(opts)).split(str, limit);
    }

    public static String[] split(String str, String delim, int limit) {
        int i;
        if (limit == 1) {
            return new String[]{str};
        }
        int max_count = 15;
        if (limit >= 15) {
            return Pattern.compile(delim, 16).split(str, limit);
        }
        char[] chars = str.toCharArray();
        char[] delim_chars = delim.toCharArray();
        int[] start = new int[15];
        int[] end = new int[15];
        int count = 0;
        int str_len = str.length();
        int delim_len = delim_chars.length;
        for (i = 0; i < 15; ++i) {
            start[i] = -1;
            end[i] = -1;
        }
        start[0] = 0;
        for (i = 0; i < str_len; ++i) {
            if (chars[i] != delim_chars[0] || i > str_len - delim_len) continue;
            boolean match = true;
            for (int j = 1; j < delim_len; ++j) {
                if (chars[i + j] == delim_chars[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (count == 14) {
                return Pattern.compile(delim, 16).split(str, limit);
            }
            end[count++] = i;
            i += delim_len;
            start[count] = i--;
        }
        String[] results = new String[count + 1];
        for (int i2 = 0; i2 <= count; ++i2) {
            results[i2] = new String(chars, start[i2], (end[i2] == -1 ? str_len : end[i2]) - start[i2]);
        }
        return results;
    }

    public static String join(String delim, String ... parts) {
        if (parts == null) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuilder sb = new StringBuilder(parts.length == 0 || parts[0] == null ? "" : parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            if (delim != null) {
                sb.append(delim);
            }
            sb.append(parts[i] == null ? "" : parts[i]);
        }
        return sb.toString();
    }

    public static String replaceAll(String str, String old, String replacement, String opts) {
        if (opts == "L") {
            return TextUtil.join(replacement, TextUtil.split(str, old));
        }
        Matcher matcher = Pattern.compile(old, TextUtil.getFlags(opts)).matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String replaceAll(String str, String old, String replacement) {
        return TextUtil.join(replacement, TextUtil.split(str, old));
    }

    public static String replace(String str, String old, String replacement, String opts, int occurrence) {
        if (occurrence == 0) {
            return TextUtil.replaceAll(str, old, replacement, opts);
        }
        Matcher matcher = Pattern.compile(old, TextUtil.getFlags(opts)).matcher(str);
        StringBuffer sb = new StringBuffer();
        if (occurrence > 0) {
            int i;
            for (i = 0; i < occurrence && matcher.find(); ++i) {
            }
            if (i < occurrence) {
                return str;
            }
            matcher.appendReplacement(sb, replacement);
            matcher.appendTail(sb);
            return sb.toString();
        }
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        matcher.reset();
        if ((occurrence += count + 1) > 0) {
            for (int i = 0; i < occurrence && matcher.find(); ++i) {
            }
            matcher.appendReplacement(sb, replacement);
            matcher.appendTail(sb);
            return sb.toString();
        }
        return str;
    }

    public static String replace(String str, String old, String replacement, int occurrence) {
        return TextUtil.replace(str, old, replacement, "L", occurrence);
    }

    public static boolean equals(CharSequence txt1, CharSequence txt2) {
        return TextUtil.equals(txt1, txt2, true);
    }

    public static boolean equals(CharSequence txt1, CharSequence txt2, boolean nullEqualsEmpty) {
        if (txt1 == null) {
            if (txt2 == null) {
                return true;
            }
            return nullEqualsEmpty && txt2.length() == 0;
        }
        if (txt2 == null) {
            return nullEqualsEmpty && txt1.length() == 0;
        }
        return txt1.equals(txt2);
    }

    public static boolean equalsIgnoreCase(CharSequence txt1, CharSequence txt2) {
        return TextUtil.equalsIgnoreCase(txt1, txt2, true);
    }

    public static boolean equalsIgnoreCase(CharSequence txt1, CharSequence txt2, boolean nullEqualsEmpty) {
        if (txt1 == null) {
            if (txt2 == null) {
                return true;
            }
            return nullEqualsEmpty && txt2.length() == 0;
        }
        if (txt2 == null) {
            return nullEqualsEmpty && txt1.length() == 0;
        }
        return ((String)txt1).equalsIgnoreCase((String)txt2);
    }

    public static String toTitleCase(String input) {
        String result = input;
        if (!TextUtil.equals(input, null)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < input.length(); ++i) {
                if (i == 0 || !Character.isLetterOrDigit(input.charAt(i - 1))) {
                    sb.append(Character.toUpperCase(input.charAt(i)));
                    continue;
                }
                sb.append(Character.toLowerCase(input.charAt(i)));
            }
            result = sb.toString();
        }
        return result;
    }

    public static String compress(String str) throws IOException {
        return TextUtil.compress(str, null);
    }

    public static String compress(String str, String encodingName) throws IOException {
        int encodingType = 0;
        if (encodingName != null) {
            int i;
            for (i = 0; i < encodingNames.length; ++i) {
                if (!encodingNames[i].equalsIgnoreCase(encodingName)) continue;
                encodingType = encodings[i];
                break;
            }
            if (i == encodingNames.length) {
                throw new IllegalArgumentException("Invalid encoding name: " + encodingName);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream zos = new GZIPOutputStream(baos);
        zos.write(str.getBytes("ISO-8859-1"));
        zos.flush();
        zos.close();
        String compressed = baos.toString("ISO-8859-1");
        switch (encodingType) {
            case 1: {
                compressed = Base64.encode(compressed);
            }
        }
        return compressed;
    }

    public static String uncompress(String str) throws IOException {
        return TextUtil.uncompress(str, null);
    }

    public static String uncompress(String str, String encodingName) throws IOException {
        int encodingType = 0;
        if (encodingName != null) {
            int i;
            for (i = 0; i < encodingNames.length; ++i) {
                if (!encodingNames[i].equalsIgnoreCase(encodingName)) continue;
                encodingType = encodings[i];
                break;
            }
            if (i == encodingNames.length) {
                throw new IllegalArgumentException("Invalid encoding name: " + encodingName);
            }
        }
        switch (encodingType) {
            case 1: {
                str = Base64.decode(str);
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
        GZIPInputStream zis = new GZIPInputStream(bais);
        byte[] buf = new byte[4096];
        int bytesRead = zis.read(buf, 0, buf.length);
        StringBuilder sb = new StringBuilder();
        while (bytesRead > 0) {
            sb.append(new String(buf, 0, bytesRead, "ISO-8859-1"));
            bytesRead = zis.read(buf, 0, buf.length);
        }
        zis.close();
        String uncompressed = sb.toString();
        return uncompressed;
    }

    public static String reduceParentheses(String str) {
        String result = null;
        LinkedList<Character> chars = new LinkedList<Character>();
        for (char c2 : str.toCharArray()) {
            chars.add(Character.valueOf(c2));
        }
        int level = 0;
        int[] levels = new int[chars.size()];
        int upCount = 0;
        int downCount = 0;
        int firstUp = -1;
        int firstDown = -1;
        int lastUp = -1;
        for (int i = 0; i < chars.size(); ++i) {
            if (((Character)chars.get(i)).charValue() == '(') {
                levels[i] = ++level;
                ++upCount;
                if (firstUp == -1) {
                    firstUp = i;
                }
                lastUp = i;
                continue;
            }
            if (((Character)chars.get(i)).charValue() == ')') {
                levels[i] = --level;
                ++downCount;
                if (firstDown != -1) continue;
                firstDown = i;
                continue;
            }
            levels[i] = level;
        }
        if (upCount != downCount) {
            throw new IllegalArgumentException("Parentheses are not balanced");
        }
        if (upCount == 0) {
            result = str;
        } else {
            LinkedList<Integer> toRemove = new LinkedList<Integer>();
            for (int i = firstUp + 1; i < lastUp + 1; ++i) {
                if (levels[i] <= levels[i - 1] || i != 1 && levels[i - 1] <= levels[i - 2]) continue;
                int j = i + 1;
                while (levels[j] >= levels[i - 1]) {
                    ++j;
                }
                if (levels[j - 2] <= levels[j - 1]) continue;
                toRemove.add(i - 1);
                toRemove.add(j - 1);
                i = j;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < chars.size(); ++i) {
                if (toRemove.contains(i)) continue;
                sb.append(chars.get(i));
            }
            result = sb.toString();
        }
        if (!result.equals(str)) {
            result = TextUtil.reduceParentheses(result);
        }
        return result;
    }

    public static String xmlEntityEncode(String str) {
        str = TextUtil.replaceAll(str, "&", "&amp;");
        str = TextUtil.replaceAll(str, "\"", "&quot;");
        str = TextUtil.replaceAll(str, "'", "&apos;");
        str = TextUtil.replaceAll(str, "<", "&lt;");
        str = TextUtil.replaceAll(str, ">", "&gt;");
        return str;
    }

    public static String xmlEntityDecode(String str) {
        str = TextUtil.replaceAll(str, "&amp;", "&");
        str = TextUtil.replaceAll(str, "&quot;", "\"");
        str = TextUtil.replaceAll(str, "&apos;", "'");
        str = TextUtil.replaceAll(str, "&lt;", "<");
        str = TextUtil.replaceAll(str, "&gt;", ">");
        return str;
    }

    public static boolean glob_match(CharSequence str, CharSequence pat) {
        return Pattern.compile(TextUtil.glob2Regex(pat.toString())).matcher(str).matches();
    }

    public static boolean glob_match(char[] str_chars, char[] pat_chars, int s, int p) {
        String str = new String(str_chars, s, str_chars.length - s);
        String pat = new String(pat_chars, p, pat_chars.length - p);
        return Pattern.compile(TextUtil.glob2Regex(pat)).matcher(str).matches();
    }

    private static int getFlags(String opts) {
        int flags = 0;
        if (opts != null) {
            block10: for (char c2 : opts.toUpperCase().toCharArray()) {
                switch (c2) {
                    case 'E': {
                        flags |= 0x80;
                        continue block10;
                    }
                    case 'I': {
                        flags |= 2;
                        continue block10;
                    }
                    case 'C': {
                        flags |= 4;
                        continue block10;
                    }
                    case 'D': {
                        flags |= 0x20;
                        continue block10;
                    }
                    case 'L': {
                        flags |= 0x10;
                        continue block10;
                    }
                    case 'M': {
                        flags |= 8;
                        continue block10;
                    }
                    case 'U': {
                        flags |= 0x40;
                        continue block10;
                    }
                    case 'X': {
                        flags |= 1;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal option specified: " + c2);
                    }
                }
            }
        }
        return flags;
    }

    public static String glob2Regex(String globStr) {
        globStr = globStr.trim();
        int strLen = globStr.length();
        StringBuilder sb = new StringBuilder(strLen);
        boolean escaping = false;
        int inCurlies = 0;
        block9: for (char currentChar : globStr.toCharArray()) {
            switch (currentChar) {
                case '*': {
                    if (escaping) {
                        sb.append("\\*");
                    } else {
                        sb.append(".*");
                    }
                    escaping = false;
                    continue block9;
                }
                case '?': {
                    if (escaping) {
                        sb.append("\\?");
                    } else {
                        sb.append('.');
                    }
                    escaping = false;
                    continue block9;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(currentChar);
                    escaping = false;
                    continue block9;
                }
                case '\\': {
                    if (escaping) {
                        sb.append("\\\\");
                        escaping = false;
                        continue block9;
                    }
                    escaping = true;
                    continue block9;
                }
                case '{': {
                    if (escaping) {
                        sb.append("\\{");
                    } else {
                        sb.append('(');
                        ++inCurlies;
                    }
                    escaping = false;
                    continue block9;
                }
                case '}': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append(')');
                        --inCurlies;
                    } else if (escaping) {
                        sb.append("\\}");
                    } else {
                        sb.append("}");
                    }
                    escaping = false;
                    continue block9;
                }
                case ',': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append('|');
                        continue block9;
                    }
                    if (escaping) {
                        sb.append("\\,");
                        continue block9;
                    }
                    sb.append(",");
                    continue block9;
                }
                default: {
                    escaping = false;
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }
}

