/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.heclib.util.HecTime;
import hec.heclib.util.booleanContainer;
import hec.util.CalendarField;
import hec.util.ObservableClass;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Observer;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;

public class TimeWindowDialog
extends JDialog {
    protected CalendarField startDateField;
    protected CalendarField startWY = new CalendarField(false);
    protected JTextField jTextFieldStartTime;
    protected CalendarField endDateField;
    protected JTextField jTextFieldEndTime;
    protected JCheckBox jCheckBoxApplyAll;
    protected int yPos = 500;
    private JMenuBar _menuBar = null;
    private JMenu helpMenu = new JMenu("Help");
    private JMenuItem _helpMenuItem = new JMenuItem();
    static String HELPSET_NAME = null;
    static String HELPSET_LABEL = null;
    protected static String[] intervals = new String[]{"hours", "days", "months", "years"};
    protected static int[] intervalMins = new int[]{60, 1440, 43200, 525600};
    protected JRadioButton radioSpecificTW = new JRadioButton();
    protected JRadioButton radioRelativeTW = new JRadioButton();
    protected JRadioButton radioNoTW = new JRadioButton();
    protected JRadioButton radioWaterYearTW = new JRadioButton();
    protected JCheckBox jCheckBoxRetainSetting = new JCheckBox();
    protected JTextField lookBackField = new JTextField();
    protected JTextField lookForwardField = new JTextField();
    protected JComboBox<String> lookBackCombo = new JComboBox<String>(intervals);
    protected JComboBox<String> lookForwardCombo = new JComboBox<String>(intervals);
    protected JButton jButtonClear = new JButton("Clear");
    protected JButton jButtonSetCurrentTime = new JButton("Set Current Time");
    public static String NO_TIME_WINDOW_MESSAGE = "No time window set.";
    public static String WATER_YEAR_MESSAGE = "Retrieve Data by Water Year";
    protected String _timeWindowMessage = NO_TIME_WINDOW_MESSAGE;
    protected Window _parent;
    protected HecTime _startTime = new HecTime();
    protected HecTime _endTime = new HecTime();
    TimeZone _timeZone = null;
    protected int _relativeBackwardInterval = 0;
    protected int _relativeForwardInterval = 0;
    protected int _relativeBackwardPeriods = 0;
    protected int _relativeForwardPeriods = 0;
    public static final int NO_TIME_WINDOW_SELECTION = 0;
    public static final int RELATIVE_SELECTION = 1;
    public static final int SPECIFIC_SELECTION = 2;
    public static final int WATER_YEAR_SELECTION = 3;
    public static final int HOURS = 0;
    public static final int DAYS = 1;
    protected int _selectionType = -1;
    protected Preferences _preferences;
    protected ObservableClass _observer;
    private JPanel _waterYearPanel;

    public TimeWindowDialog(Window parent, String title, Preferences preferences, boolean global) {
        super(parent, title);
        this._parent = parent;
        this._preferences = preferences;
        if (this._preferences == null && global) {
            this._preferences = Preferences.userNodeForPackage(this.getClass());
        }
        this.build(false);
        this.pack();
        this.setMinimumSize(new Dimension(400, 400));
        this.setLocationRelativeTo(this.getParent());
    }

    public TimeWindowDialog(Window parent, String title, Preferences preferences, boolean global, boolean waterYear) {
        super(parent, title);
        this._parent = parent;
        this._preferences = preferences;
        if (this._preferences == null && global) {
            this._preferences = Preferences.userNodeForPackage(this.getClass());
        }
        this.build(waterYear);
        this.pack();
        this.setMinimumSize(new Dimension(400, 400));
        this.setLocationRelativeTo(this.getParent());
    }

    public TimeWindowDialog(Window parent, String title) {
        this(parent, title, null, true);
    }

    protected void build(boolean useWaterYear) {
        this._observer = new ObservableClass();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setLocationRelativeTo(this._parent);
        this.buildNoTwPanel();
        this.buildSpecificTwPanel();
        this.buildRelativeTwPanel();
        if (useWaterYear) {
            this.buildByWaterYear();
        }
        this.buildRetainSettings();
        this.buildOkButtons();
        this.setSize(410, this.yPos);
        this.init();
    }

    protected void buildNoTwPanel() {
        JPanel jPanelNoTW = new JPanel(new GridBagLayout());
        jPanelNoTW.setBorder(new EtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)jPanelNoTW, gbc);
        this.radioNoTW.setText("No Time Window");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0E-4;
        gbc.weighty = 1.0E-4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
        jPanelNoTW.add((Component)this.radioNoTW, gbc);
    }

    protected void buildSpecificTwPanel() {
        Insets labelInsets;
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setBorder(new EtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)jPanel1, gbc);
        this.radioSpecificTW.setText("Specific Time Window");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel1.add((Component)this.radioSpecificTW, gbc);
        JLabel jLabelStartDate = new JLabel("Start Date:");
        jLabelStartDate.setDisplayedMnemonic('r');
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = labelInsets = new Insets(5, 20, 0, 5);
        jPanel1.add((Component)jLabelStartDate, gbc);
        this.startDateField = new CalendarField();
        jLabelStartDate.setLabelFor(this.startDateField);
        this.startDateField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent event) {
                TimeWindowDialog.this.startDateUpdated();
            }
        });
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel1.add((Component)this.startDateField, gbc);
        JLabel jLabelStartTime = new JLabel("Start Time:");
        jLabelStartTime.setDisplayedMnemonic('T');
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel1.add((Component)jLabelStartTime, gbc);
        this.jTextFieldStartTime = new JTextField();
        jLabelStartTime.setLabelFor(this.jTextFieldStartTime);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel1.add((Component)this.jTextFieldStartTime, gbc);
        JLabel jLabelEndDate = new JLabel("End Date:");
        jLabelEndDate.setDisplayedMnemonic('D');
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = labelInsets;
        jPanel1.add((Component)jLabelEndDate, gbc);
        this.endDateField = new CalendarField();
        jLabelEndDate.setLabelFor(this.endDateField);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel1.add((Component)this.endDateField, gbc);
        this.endDateField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent event) {
                TimeWindowDialog.this.endDateUpdated();
            }
        });
        JLabel jLabelEndTime = new JLabel("End Time:");
        jLabelEndTime.setDisplayedMnemonic('E');
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel1.add((Component)jLabelEndTime, gbc);
        this.jTextFieldEndTime = new JTextField();
        jLabelEndTime.setLabelFor(this.jTextFieldEndTime);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel1.add((Component)this.jTextFieldEndTime, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        jPanel1.add((Component)buttonPanel, gbc);
        this.jButtonClear.setMnemonic('C');
        this.jButtonClear.setActionCommand("Clear");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        buttonPanel.add((Component)this.jButtonClear, gbc);
        this.jButtonSetCurrentTime.setMnemonic('S');
        this.jButtonSetCurrentTime.setActionCommand("Set Current Time");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        buttonPanel.add((Component)this.jButtonSetCurrentTime, gbc);
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TimeWindowDialog.this.clearTimes();
            }
        });
        this.jButtonSetCurrentTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TimeWindowDialog.this.jButtonCurrent_actionPerformed();
            }
        });
        this.lookBackCombo.setSelectedIndex(1);
        this.lookForwardCombo.setSelectedIndex(1);
    }

    protected void buildRelativeTwPanel() {
        Insets labelInsets;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.001;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)jPanel2, gbc);
        this.radioRelativeTW.setText("Relative to Current Time");
        this.radioRelativeTW.setMnemonic('R');
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel2.add((Component)this.radioRelativeTW, gbc);
        JLabel JLabel1 = new JLabel("Go Back:");
        JLabel1.setLabelFor(this.lookBackField);
        JLabel1.setDisplayedMnemonic('L');
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = labelInsets = new Insets(5, 20, 0, 5);
        jPanel2.add((Component)JLabel1, gbc);
        this.lookBackField.setHorizontalAlignment(4);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel2.add((Component)this.lookBackField, gbc);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel2.add(this.lookBackCombo, gbc);
        JLabel lookForwardLabel = new JLabel("Go Forward:");
        lookForwardLabel.setLabelFor(this.lookForwardField);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = labelInsets;
        jPanel2.add((Component)lookForwardLabel, gbc);
        this.lookForwardField.setHorizontalAlignment(4);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        jPanel2.add((Component)this.lookForwardField, gbc);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
        jPanel2.add(this.lookForwardCombo, gbc);
        this.jCheckBoxApplyAll = new JCheckBox("Apply to All Data");
        this.jCheckBoxApplyAll.setMnemonic('A');
        this.jCheckBoxApplyAll.setActionCommand("Apply to All Data");
        this.jCheckBoxApplyAll.setSelected(true);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
    }

    protected void buildByWaterYear() {
        Insets labelInsets;
        this._waterYearPanel = new JPanel(new GridBagLayout());
        this._waterYearPanel.setBorder(new EtchedBorder());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.001;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._waterYearPanel, gbc);
        this.radioWaterYearTW.setText("By Individual Water Year");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._waterYearPanel.add((Component)this.radioWaterYearTW, gbc);
        JLabel jLabelStartWy = new JLabel("Start Date of Water Year:");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = labelInsets = new Insets(5, 20, 0, 5);
        this._waterYearPanel.add((Component)jLabelStartWy, gbc);
        jLabelStartWy.setLabelFor(this.startWY);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this._waterYearPanel.add((Component)this.startWY, gbc);
        this.startWY.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent event) {
                TimeWindowDialog.this.WYUpdated();
            }
        });
    }

    protected void buildRetainSettings() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)jPanel, gbc);
        this.jCheckBoxRetainSetting.setText("Retain Between Sessions");
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this.jCheckBoxRetainSetting, gbc);
        if (this._preferences == null) {
            jPanel.setVisible(false);
        }
    }

    protected void buildOkButtons() {
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(14);
        cmdPanel.setApplyAlwaysOn(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)cmdPanel, gbc);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                switch (event.getID()) {
                    case 8: {
                        TimeWindowDialog.this.jButtonOk_actionPerformed();
                        break;
                    }
                    case 2: {
                        TimeWindowDialog.this.apply_action();
                        break;
                    }
                    case 4: {
                        TimeWindowDialog.this.jButtonCancel_actionPerformed();
                    }
                }
            }
        });
        this.setHelpSetLabel("HEC-DSSVue - Help");
        this.setHelpSetName("HEC-DSSVue");
        this.buildHelpSet("ListSelection.HelpOverviewMenu", "timeWindowDialogHelp");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioNoTW);
        bg.add(this.radioRelativeTW);
        bg.add(this.radioSpecificTW);
        bg.add(this.radioWaterYearTW);
        SymItem lSymItem = new SymItem();
        this.radioNoTW.addItemListener(lSymItem);
        this.radioRelativeTW.addItemListener(lSymItem);
        this.radioSpecificTW.addItemListener(lSymItem);
        this.radioWaterYearTW.addItemListener(lSymItem);
    }

    protected void init() {
        if (this._preferences != null) {
            HecTime start = new HecTime();
            String startString = this._preferences.get("startTime", "");
            String endString = this._preferences.get("endTime", "");
            String backTime = this._preferences.get("backTime", "");
            String forwardTime = this._preferences.get("forwardTime", "");
            String startWaterYear = this._preferences.get("startWaterYear", "01OCT2000");
            start.setDate(startWaterYear);
            if (!start.isDateDefined()) {
                start.setDate("01OCT2000");
            }
            this.startWY.setDefaultDate(start, true);
            start.setUndefined();
            HecTime end = new HecTime();
            if (startString.length() > 2) {
                start.set(startString);
            }
            if (endString.length() > 2) {
                end.set(endString);
            }
            int selectionType = this._preferences.getInt("TimeSelection", 0);
            boolean retainSetting = this._preferences.getBoolean("RetainSetting", false);
            this.jCheckBoxRetainSetting.setSelected(retainSetting);
            this._selectionType = -1;
            if (retainSetting) {
                this.setSelectionType(selectionType, true);
            } else {
                this.setSelectionType(0, true);
            }
            this.setTimeWindow(start, end, true, false);
            this.setRelativeTime(backTime, forwardTime, false);
        } else {
            this._selectionType = -1;
            this.setSelectionType(0, true);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(visible);
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }

    protected void startDateUpdated() {
        HecTime htime;
        String date = this.startDateField.getText().trim();
        if (date.length() > 4 && (htime = new HecTime(date)).isDateDefined()) {
            this.startDateField.setText(htime.date(7));
            this.endDateField.setDefaultDate(htime);
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    protected void endDateUpdated() {
        HecTime htime;
        String date = this.endDateField.getText().trim();
        if (date.length() > 4 && (htime = new HecTime(date)).isDateDefined()) {
            this.endDateField.setText(htime.date(7));
            this.endDateField.setDefaultDate(htime);
        }
    }

    protected void WYUpdated() {
    }

    protected void jButtonOk_actionPerformed() {
        int status = this.checkTimes();
        if (status == 0) {
            this.setVisible(false);
        }
    }

    protected void apply_action() {
        this.checkTimes();
    }

    protected void jButtonCancel_actionPerformed() {
        this.init();
        this.setVisible(false);
        this.displayTimes(this._startTime, this._endTime);
    }

    private HecTime getCurrentTime() {
        if (this._timeZone != null) {
            Calendar cal = Calendar.getInstance(this._timeZone);
            return new HecTime(cal);
        }
        HecTime tmp = new HecTime();
        tmp.setCurrent();
        return tmp;
    }

    protected void jButtonCurrent_actionPerformed() {
        HecTime tmp = this.getCurrentTime();
        this.displayTimes(tmp, tmp);
    }

    public boolean getTimeWindow(HecTime startTime, HecTime endTime, booleanContainer applyToAll) {
        applyToAll.value = this.jCheckBoxApplyAll.isSelected();
        if (this._selectionType == 0) {
            startTime.setUndefined();
            endTime.setUndefined();
        } else if (this._selectionType == 2) {
            startTime.set(this._startTime);
            endTime.set(this._endTime);
        } else {
            startTime.set(this.getCurrentTime());
            this._relativeBackwardPeriods = TimeWindowDialog.parseRelativeTime(this.lookBackField.getText(), this._relativeBackwardInterval, startTime, false);
            endTime.set(this.getCurrentTime());
            this._relativeForwardPeriods = TimeWindowDialog.parseRelativeTime(this.lookForwardField.getText(), this._relativeForwardInterval, endTime, true);
        }
        return startTime.isDefined() && endTime.isDefined();
    }

    public HecTime getWaterYearStartDate() {
        HecTime wyStart = new HecTime();
        wyStart.set(this.getCurrentTime());
        int yr = wyStart.year();
        String date = this.startWY.getText() + Integer.toString(yr);
        wyStart.set(date, "0001");
        return wyStart;
    }

    private void setTimeWindow(HecTime start, HecTime end, boolean applyToAll, boolean saveToPreferences) {
        this._startTime.set(start);
        this._endTime.set(end);
        if (saveToPreferences && this._startTime.isDefined() && this._endTime.isDefined()) {
            this.setSelectionType(2, true);
        }
        this.displayTimes(start, end);
        this.jCheckBoxApplyAll.setSelected(applyToAll);
        if (saveToPreferences) {
            this.applyPreferences();
        }
    }

    public void setTimeWindow(HecTime start, HecTime end, boolean applyToAll) {
        this.setTimeWindow(start, end, applyToAll, true);
    }

    private void setRelativeTime(String backTime, String forwardTime, boolean saveToPreferences) {
        int i;
        String[] s;
        if (backTime.length() > 2) {
            s = backTime.split(" ");
            if (s.length == 2) {
                this.lookBackField.setText(s[0]);
                for (i = 0; i < intervals.length; ++i) {
                    if (!s[1].equals(intervals[i])) continue;
                    this.lookBackCombo.setSelectedIndex(i);
                    this._relativeBackwardInterval = intervalMins[i];
                    break;
                }
            }
        } else {
            this.lookBackField.setText("");
        }
        if (forwardTime.length() > 2) {
            s = forwardTime.split(" ");
            if (s.length == 2) {
                this.lookForwardField.setText(s[0]);
                for (i = 0; i < intervals.length; ++i) {
                    if (!s[1].equals(intervals[i])) continue;
                    this.lookForwardCombo.setSelectedIndex(i);
                    this._relativeForwardInterval = intervalMins[i];
                    break;
                }
            }
        } else {
            this.lookForwardField.setText("");
        }
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        start.set(this.getCurrentTime());
        end.set(this.getCurrentTime());
        this._relativeBackwardPeriods = TimeWindowDialog.parseRelativeTime(this.lookBackField.getText(), this._relativeBackwardInterval, start, false);
        this._relativeForwardPeriods = TimeWindowDialog.parseRelativeTime(this.lookForwardField.getText(), this._relativeForwardInterval, end, true);
        if (saveToPreferences && start.notEqualTo(end)) {
            this._selectionType = 1;
        }
        if (saveToPreferences) {
            this.applyPreferences();
        }
    }

    public void setRelativeTime(String backTime, String forwardTime) {
        this.setRelativeTime(backTime, forwardTime, true);
    }

    public int getTimeWindowType() {
        return this._selectionType;
    }

    public boolean isWaterYear() {
        return this._selectionType == 3;
    }

    public String getTimeWindowString(int style) {
        if (this._selectionType == 0) {
            return "";
        }
        if (this._selectionType == 1) {
            String lookBack = this.lookBackField.getText().trim();
            String lookForward = this.lookForwardField.getText().trim();
            if (lookBack.length() == 0) {
                lookBack = "0";
            }
            if (lookForward.length() == 0) {
                lookForward = "0";
            }
            String sign = lookBack.startsWith("-") ? "+" : "-";
            String s = "T" + sign + lookBack + this.lookBackCombo.getSelectedItem().toString().substring(0, 1).toUpperCase();
            sign = this.lookForwardField.getText().startsWith("-") ? "" : "+";
            String e = "T" + sign + lookForward + this.lookForwardCombo.getSelectedItem().toString().substring(0, 1).toUpperCase();
            return s + ",  " + e;
        }
        return this._startTime.toString(style) + ",  " + this._endTime.toString(style);
    }

    protected int checkTimes() {
        String startDate = this.startDateField.getText();
        if (startDate.length() < 3) {
            this.clearTimes();
            this._startTime.setUndefined();
            this._endTime.setUndefined();
        } else {
            HecTime start = new HecTime();
            int statusStartDate = start.setDate(this.startDateField.getText());
            String sTime = this.jTextFieldStartTime.getText();
            if (sTime.length() == 0) {
                sTime = "0000";
            }
            int statusStartTime = start.setTime(sTime);
            HecTime end = new HecTime();
            int statusEndDate = end.setDate(this.endDateField.getText());
            String eTime = this.jTextFieldEndTime.getText();
            if (eTime.length() == 0) {
                eTime = "2400";
            }
            int statusEndTime = end.setTime(eTime);
            if (statusStartDate != 0 || statusStartTime != 0 || statusEndDate != 0 || statusEndTime != 0) {
                Object errors = new String();
                if (statusStartDate != 0) {
                    errors = (String)errors + "Invalid Start Date.\n";
                }
                if (statusStartTime != 0) {
                    errors = (String)errors + "Invalid Start Time.\n";
                }
                if (statusEndDate != 0) {
                    errors = (String)errors + "Invalid End Date.\n";
                }
                if (statusEndTime != 0) {
                    errors = (String)errors + "Invalid End Time.";
                }
                JOptionPane.showMessageDialog(this, errors, "Invalid Time Window", 2);
                return -1;
            }
            if (!start.lessThanEqualTo(end)) {
                JOptionPane.showMessageDialog(this, "Start date/time does not occur before end.", "Invalid Time Window", 2);
                return -1;
            }
            this._startTime = start;
            this._endTime = end;
        }
        this.applyPreferences();
        if (this._observer != null) {
            ActionEvent event = new ActionEvent(this, 1001, "timesUpdated");
            this._observer.notifyObservers(event);
        }
        return 0;
    }

    private void applyPreferences() {
        if (this._preferences != null) {
            this._preferences.putInt("TimeSelection", this._selectionType);
            if (this._selectionType == 1) {
                String backTime = this.lookBackField.getText() + " " + this.lookBackCombo.getSelectedItem();
                String forwardTime = this.lookForwardField.getText() + " " + this.lookForwardCombo.getSelectedItem();
                this.setRelativeTime(backTime, forwardTime, false);
                if (this._relativeBackwardPeriods != 0) {
                    this._preferences.put("backTime", this.lookBackField.getText() + " " + this.lookBackCombo.getSelectedItem());
                } else {
                    this._preferences.put("backTime", "");
                }
                if (this._relativeForwardPeriods != 0) {
                    this._preferences.put("forwardTime", this.lookForwardField.getText() + " " + this.lookForwardCombo.getSelectedItem());
                } else {
                    this._preferences.put("forwardTime", "");
                }
            }
            if (this._startTime.isDefined()) {
                this._preferences.put("startTime", this._startTime.toString(104));
            } else {
                this._preferences.put("startTime", "");
            }
            if (this._endTime.isDefined()) {
                this._preferences.put("endTime", this._endTime.toString(104));
            } else {
                this._preferences.put("endTime", "");
            }
            HecTime t = this.getWaterYearStartDate();
            if (t.isDateDefined()) {
                this._preferences.put("startWaterYear", t.date());
            }
            this._preferences.putBoolean("RetainSetting", this.jCheckBoxRetainSetting.isSelected());
        }
    }

    protected static int parseRelativeTime(String numberField, int interval, HecTime time, boolean forward) {
        int numb = 0;
        if (numberField.length() > 0) {
            try {
                numb = Integer.parseInt(numberField);
            }
            catch (Exception e) {
                return 0;
            }
            if (numb != 0) {
                if (forward) {
                    time.increment(numb, interval);
                } else {
                    time.increment(-numb, interval);
                }
            }
        }
        return numb;
    }

    public void clearTimes() {
        HecTime tmp = new HecTime();
        this.displayTimes(tmp, tmp);
    }

    public void displayTimes(HecTime start, HecTime end) {
        if (!start.isDefined()) {
            this.startDateField.setText("");
            this.jTextFieldStartTime.setText("");
        } else {
            this.startDateField.setText(start.date(7));
            this.jTextFieldStartTime.setText(start.time());
        }
        if (!end.isDefined()) {
            this.endDateField.setText("");
            this.jTextFieldEndTime.setText("");
        } else {
            this.endDateField.setText(end.date(7));
            SimpleDateFormat formatUTC = new SimpleDateFormat("HH:mm");
            formatUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
            String strDate = formatUTC.format(end.getJavaDate(0));
            this.jTextFieldEndTime.setText(end.time());
        }
    }

    public static boolean getTimeWindow(HecTime startTime, HecTime endTime, Preferences preferences) {
        int selectionType = preferences.getInt("TimeSelection", 0);
        if (selectionType == 1) {
            String backTime = preferences.get("backTime", "");
            String[] s = backTime.split(" ");
            int relativeBackwardInterval = 0;
            if (s.length == 2) {
                for (int i = 0; i < intervals.length; ++i) {
                    if (!s[1].equals(intervals[i])) continue;
                    relativeBackwardInterval = intervalMins[i];
                    break;
                }
            }
            startTime.setCurrent();
            TimeWindowDialog.parseRelativeTime(s[0], relativeBackwardInterval, startTime, false);
            String forwardTime = preferences.get("forwardTime", "");
            s = forwardTime.split(" ");
            int relativeForwardInterval = 0;
            if (s.length == 2) {
                for (int i = 0; i < intervals.length; ++i) {
                    if (!s[1].equals(intervals[i])) continue;
                    relativeForwardInterval = intervalMins[i];
                    break;
                }
            }
            endTime.setCurrent();
            TimeWindowDialog.parseRelativeTime(s[0], relativeForwardInterval, endTime, true);
        } else {
            String startString = preferences.get("startTime", "");
            String endString = preferences.get("endTime", "");
            startTime.set(startString);
            endTime.set(endString);
        }
        return true;
    }

    public void setSelectionType(int selection, boolean setRadioButton) {
        if (this._selectionType == selection) {
            return;
        }
        this._selectionType = selection;
        if (this._selectionType == 0) {
            this.lookBackField.setEnabled(false);
            this.lookForwardField.setEnabled(false);
            this.lookBackCombo.setEnabled(false);
            this.lookForwardCombo.setEnabled(false);
            this.startDateField.setEnabled(false);
            this.jTextFieldStartTime.setEnabled(false);
            this.endDateField.setEnabled(false);
            this.jTextFieldEndTime.setEnabled(false);
            this.jButtonClear.setEnabled(false);
            this.jButtonSetCurrentTime.setEnabled(false);
            this.startWY.setEnabled(false);
            if (setRadioButton) {
                this.radioNoTW.setSelected(true);
            }
        } else if (this._selectionType == 1) {
            this.lookBackField.setEnabled(true);
            this.lookForwardField.setEnabled(true);
            this.lookBackCombo.setEnabled(true);
            this.lookForwardCombo.setEnabled(true);
            this.startDateField.setEnabled(false);
            this.jTextFieldStartTime.setEnabled(false);
            this.endDateField.setEnabled(false);
            this.jTextFieldEndTime.setEnabled(false);
            this.jButtonClear.setEnabled(false);
            this.jButtonSetCurrentTime.setEnabled(false);
            this.startWY.setEnabled(false);
            if (setRadioButton) {
                this.radioRelativeTW.setSelected(true);
            }
        } else if (this._selectionType == 2) {
            this.lookBackField.setEnabled(false);
            this.lookForwardField.setEnabled(false);
            this.lookBackCombo.setEnabled(false);
            this.lookForwardCombo.setEnabled(false);
            this.startDateField.setEnabled(true);
            this.jTextFieldStartTime.setEnabled(true);
            this.endDateField.setEnabled(true);
            this.jTextFieldEndTime.setEnabled(true);
            this.jButtonClear.setEnabled(true);
            this.jButtonSetCurrentTime.setEnabled(true);
            this.startWY.setEnabled(false);
            if (setRadioButton) {
                this.radioSpecificTW.setSelected(true);
            }
        } else if (this._selectionType == 3) {
            this.lookBackField.setEnabled(false);
            this.lookForwardField.setEnabled(false);
            this.lookBackCombo.setEnabled(false);
            this.lookForwardCombo.setEnabled(false);
            this.startDateField.setEnabled(false);
            this.jTextFieldStartTime.setEnabled(false);
            this.endDateField.setEnabled(false);
            this.jTextFieldEndTime.setEnabled(false);
            this.jButtonClear.setEnabled(false);
            this.jButtonSetCurrentTime.setEnabled(false);
            this.startWY.setEnabled(true);
            if (setRadioButton) {
                this.radioWaterYearTW.setSelected(true);
            }
        }
    }

    public String getTimeWindowMessage() {
        Object mess;
        if (this._selectionType == 0) {
            mess = NO_TIME_WINDOW_MESSAGE;
        } else if (this._selectionType == 2) {
            mess = !this._startTime.isDefined() || !this._endTime.isDefined() ? NO_TIME_WINDOW_MESSAGE : " Time window:  " + this._startTime.toString(7) + "   to   " + this._endTime.toString(7);
        } else if (this._selectionType == 3) {
            mess = WATER_YEAR_MESSAGE;
        } else if (this._relativeBackwardPeriods == 0 && this._relativeForwardPeriods == 0) {
            mess = NO_TIME_WINDOW_MESSAGE;
        } else {
            Object end;
            String numb;
            Object start;
            if (this._relativeBackwardPeriods == 0) {
                start = "current";
            } else if (this._relativeBackwardPeriods < 0) {
                start = "ahead " + this.lookBackField.getText() + " " + this.lookBackCombo.getSelectedItem();
            } else {
                numb = this.lookBackField.getText();
                if (numb.startsWith("-") && numb.length() > 1) {
                    numb = numb.substring(1);
                }
                start = "back " + numb + " " + this.lookBackCombo.getSelectedItem();
            }
            if (this._relativeForwardPeriods == 0) {
                end = "current";
            } else if (this._relativeForwardPeriods > 0) {
                end = "ahead " + this.lookForwardField.getText() + " " + this.lookForwardCombo.getSelectedItem();
            } else {
                numb = this.lookForwardField.getText();
                if (numb.startsWith("-") && numb.length() > 1) {
                    numb = numb.substring(1);
                }
                end = "back " + numb + " " + this.lookForwardCombo.getSelectedItem();
            }
            mess = " Time window:  " + (String)start + "  to  " + (String)end;
        }
        return mess;
    }

    protected void buildHelpSet(String helpOverviewConstant, String ConfigurationManagerHelpString) {
    }

    protected void setHelpSetLabel(String helpsetLabel) {
        HELPSET_LABEL = helpsetLabel;
    }

    protected void setHelpSetName(String helpsetName) {
        HELPSET_NAME = helpsetName;
    }

    protected String getHelpSetLabel() {
        return HELPSET_LABEL;
    }

    protected String getHelpSetName() {
        return HELPSET_NAME;
    }

    protected String getApplicationHelpSetName() {
        return null;
    }

    protected JMenuItem getAppOverviewHelpMenu() {
        return null;
    }

    protected String getAppOverviewHelpFilename() {
        return null;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public void addHelpMenu(JMenuItem helpMenuItem) {
        if (helpMenuItem == null) {
            return;
        }
        this.helpMenu = this.getHelpMenu();
        if (this.helpMenu != null) {
            this.helpMenu.setMnemonic('H');
            this.helpMenu.add(helpMenuItem);
        }
    }

    public void setWaterYearPanelVisible(boolean visible) {
        if (this._waterYearPanel == null) {
            return;
        }
        this._waterYearPanel.setVisible(visible);
        if (!visible && this.radioWaterYearTW.isSelected()) {
            this.radioNoTW.doClick(0);
        }
    }

    public static void main(String[] args) {
        TimeWindowDialog dlg = new TimeWindowDialog((Window)new JFrame(), "Time Window", null, true);
        dlg.setVisible(true);
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            ItemSelectable object = event.getItemSelectable();
            if (object == TimeWindowDialog.this.radioRelativeTW) {
                if (TimeWindowDialog.this.radioRelativeTW.isSelected()) {
                    TimeWindowDialog.this.setSelectionType(1, false);
                }
            } else if (object == TimeWindowDialog.this.radioSpecificTW) {
                if (TimeWindowDialog.this.radioSpecificTW.isSelected()) {
                    TimeWindowDialog.this.setSelectionType(2, false);
                }
            } else if (object == TimeWindowDialog.this.radioNoTW) {
                if (TimeWindowDialog.this.radioNoTW.isSelected()) {
                    TimeWindowDialog.this.setSelectionType(0, false);
                }
            } else if (object == TimeWindowDialog.this.radioWaterYearTW && TimeWindowDialog.this.radioWaterYearTW.isSelected()) {
                TimeWindowDialog.this.setSelectionType(3, false);
            }
        }
    }
}

