/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.util.CalendarField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

public class TimeWindowExtensionDialog
extends RmaJDialog {
    public static final int INSERT = 0;
    public static final int PREPEND = 1;
    public static final int APPEND = 2;
    protected boolean _canceled = false;
    Vector<String> _intervals = null;
    boolean _irregular;
    boolean _insertRows = false;
    int _insertRowNumber = 0;
    HecTime _startTime;
    HecTime _endTime;
    TimeZone _dataTimeZone = null;
    TimeZone _viewTimeZone = null;
    Component _parent;
    TimePanel _insertPanel = null;
    TimePanel _prependPanel = null;
    TimePanel _appendPanel = null;

    public TimeWindowExtensionDialog(JFrame parent, HecTime startTime, HecTime endTime, int defaultInterval, boolean irregular) {
        super(parent);
        this._parent = parent;
        this.setup(startTime, endTime, defaultInterval, irregular, false, 0, null, null);
    }

    public TimeWindowExtensionDialog(JDialog parent, HecTime startTime, HecTime endTime, int defaultInterval, boolean irregular) {
        super(parent);
        this._parent = parent;
        this.setup(startTime, endTime, defaultInterval, irregular, false, 0, null, null);
    }

    public TimeWindowExtensionDialog(JFrame parent, HecTime startTime, HecTime endTime, int defaultInterval, boolean irregular, boolean insertRows, int insertRowNumber, HecTime insertStartTime, HecTime insertEndTime) {
        super(parent);
        this._parent = parent;
        this.setup(startTime, endTime, defaultInterval, irregular, insertRows, insertRowNumber, insertStartTime, insertEndTime);
    }

    public TimeWindowExtensionDialog(JDialog parent, HecTime startTime, HecTime endTime, int defaultInterval, boolean irregular, boolean insertRows, int insertRowNumber, HecTime insertStartTime, HecTime insertEndTime) {
        super(parent);
        this._parent = parent;
        this.setup(startTime, endTime, defaultInterval, irregular, insertRows, insertRowNumber, insertStartTime, insertEndTime);
    }

    public TimeWindowExtensionDialog(JFrame parent, int[] timeArray, int defaultInterval, boolean irregular, int selectedRow) {
        super(parent);
        this._parent = parent;
        HecTimeArray hecTimeArray = new HecTimeArray();
        hecTimeArray.set(timeArray);
        this.getTimesSetup(hecTimeArray, defaultInterval, irregular, selectedRow);
    }

    public TimeWindowExtensionDialog(JDialog parent, int[] timeArray, int defaultInterval, boolean irregular, int selectedRow) {
        super(parent);
        this._parent = parent;
        HecTimeArray hecTimeArray = new HecTimeArray();
        hecTimeArray.set(timeArray);
        this.getTimesSetup(hecTimeArray, defaultInterval, irregular, selectedRow);
    }

    public TimeWindowExtensionDialog(JFrame parent, HecTimeArray timeArray, int defaultInterval, boolean irregular, int selectedRow) {
        super(parent);
        this._parent = parent;
        this.getTimesSetup(timeArray, defaultInterval, irregular, selectedRow);
    }

    public TimeWindowExtensionDialog(JDialog parent, HecTimeArray timeArray, int defaultInterval, boolean irregular, int selectedRow) {
        super(parent);
        this._parent = parent;
        this.getTimesSetup(timeArray, defaultInterval, irregular, selectedRow);
    }

    protected void setup(HecTime startTime, HecTime endTime, int defaultInterval, boolean irregular, boolean insertRows, int insertRowNumber, HecTime insertStartTime, HecTime insertEndTime) {
        this.setTitle("Extend Data Set");
        this._insertRows = insertRows;
        this._insertRowNumber = insertRowNumber;
        this._irregular = irregular;
        this.build();
        this.init(startTime, endTime, defaultInterval, insertStartTime, insertEndTime);
    }

    protected void getTimesSetup(HecTimeArray timeArray, int defaultInterval, boolean irregular, int selectedRow) {
        boolean insertRows;
        HecTime insertStartTime = null;
        HecTime insertEndTime = null;
        int insertRowNumber = 0;
        if (selectedRow > 0 && selectedRow < timeArray.numberElements() - 1) {
            insertRows = true;
            insertRowNumber = selectedRow;
            insertStartTime = timeArray.element(selectedRow);
            insertEndTime = timeArray.element(selectedRow + 1);
        } else {
            insertRows = false;
        }
        intContainer ic = new intContainer();
        if (!timeArray.isDefined(ic)) {
            return;
        }
        HecTime startTime = timeArray.element(ic.value);
        HecTime endTime = timeArray.element(timeArray.lastDefined());
        if (defaultInterval <= 0) {
            defaultInterval = this.computeDefaultInterval(timeArray);
        }
        this.setup(startTime, endTime, defaultInterval, irregular, insertRows, insertRowNumber, insertStartTime, insertEndTime);
    }

    public void showIncludeTimesCheckBox(boolean show) {
        if (this._insertPanel != null) {
            this._insertPanel.showIncludeTimesCheckBox(show);
        }
        if (this._prependPanel != null) {
            this._prependPanel.showIncludeTimesCheckBox(show);
        }
        if (this._appendPanel != null) {
            this._appendPanel.showIncludeTimesCheckBox(show);
        }
        this.pack();
    }

    public boolean isInserted() {
        if (this._insertPanel != null) {
            int nrows = this._insertPanel.getNumberRows();
            return nrows != 0;
        }
        return false;
    }

    public boolean isPrepended() {
        int nrows = this._prependPanel.getNumberRows();
        return nrows != 0;
    }

    public boolean isAppended() {
        int nrows = this._appendPanel.getNumberRows();
        return nrows != 0;
    }

    public int getNumberInsertedRows() {
        if (this._insertPanel != null) {
            return this._insertPanel.getNumberRows();
        }
        return 0;
    }

    public int getNumberPrependedRows() {
        return this._prependPanel.getNumberRows();
    }

    public int getNumberAppendedRows() {
        return this._appendPanel.getNumberRows();
    }

    public HecTimeArray getInsertedTimes() {
        if (this._insertPanel != null) {
            return this._insertPanel.getAddedTimes();
        }
        return null;
    }

    public HecTimeArray getPrependedTimes() {
        return this._prependPanel.getAddedTimes();
    }

    public HecTimeArray getAppendedTimes() {
        return this._appendPanel.getAddedTimes();
    }

    public void setTimeZone(TimeZone dataTimeZone, TimeZone viewTimeZone) {
        this._dataTimeZone = dataTimeZone;
        this._viewTimeZone = viewTimeZone;
        if (this._prependPanel != null) {
            this._prependPanel.update();
        }
        if (this._appendPanel != null) {
            this._appendPanel.update();
        }
        if (this._insertPanel != null) {
            this._insertPanel.update();
        }
    }

    protected void build() {
        GridBagConstraints gbc;
        this.getListOfIntervals();
        this.getContentPane().setLayout(new GridBagLayout());
        int gridy = 0;
        if (this._insertRows && this._irregular) {
            this._insertPanel = new TimePanel(0);
            int row = this._insertRowNumber + 1;
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets(10, 10, 0, 10);
            this.getContentPane().add((Component)this._insertPanel, gbc);
        }
        this._prependPanel = new TimePanel(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this._prependPanel, gbc);
        this._appendPanel = new TimePanel(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this._appendPanel, gbc);
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets(5, 5, 5, 10);
        this.getContentPane().add((Component)cmdPanel, gbc);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                if (e.getID() == 8) {
                    TimeWindowExtensionDialog.this.OKpressed();
                } else if (e.getID() == 4) {
                    TimeWindowExtensionDialog.this._canceled = true;
                    TimeWindowExtensionDialog.this.setVisible(false);
                }
            }
        });
        this.setModal(true);
    }

    protected void OKpressed() {
        this._canceled = false;
        this.setVisible(false);
    }

    protected void cancelPressed() {
        this._canceled = true;
        this.setVisible(false);
    }

    public boolean canceled() {
        return this._canceled;
    }

    protected void init(HecTime startTime, HecTime endTime, int defaultInterval, HecTime insertStartTime, HecTime insertEndTime) {
        int[] status = new int[]{0};
        String epart = Heclib.getEPartFromInterval(defaultInterval, status);
        if (status[0] < 0) {
            epart = "";
        }
        int interval = 0;
        if (this._irregular && epart.length() == 0) {
            for (int i = 0; i < this._intervals.size(); ++i) {
                interval = HecTimeSeriesBase.getIntervalFromEPart(this._intervals.elementAt(i));
                if (defaultInterval > interval) continue;
                epart = this._intervals.elementAt(i);
                break;
            }
        } else {
            interval = defaultInterval;
        }
        this._startTime = new HecTime(startTime);
        this._endTime = new HecTime(endTime);
        if (this._insertPanel != null) {
            HecTime insertTime = new HecTime();
            if (insertStartTime != null) {
                insertTime.set(insertStartTime);
            }
            this._insertPanel.init(insertTime, insertEndTime, interval, epart, this._irregular);
        }
        this._prependPanel.init(this._startTime, null, interval, epart, this._irregular);
        this._appendPanel.init(this._endTime, null, interval, epart, this._irregular);
        this.pack();
        this.setLocation();
    }

    protected void getListOfIntervals() {
        if (this._intervals != null) {
            return;
        }
        this._intervals = HecTimeSeriesBase.getListOfEParts();
        for (int i = this._intervals.size() - 1; i >= 0; --i) {
            String s = this._intervals.get(i);
            if (s.startsWith("IR")) {
                this._intervals.remove(i);
                continue;
            }
            if (s.startsWith("1Week")) {
                this._intervals.remove(i);
                continue;
            }
            if (s.startsWith("Tri")) {
                this._intervals.remove(i);
                continue;
            }
            if (!s.startsWith("Semi")) continue;
            this._intervals.remove(i);
        }
    }

    protected int computeDefaultInterval(HecTimeArray timeArray) {
        int i;
        this.getListOfIntervals();
        int size = this._intervals.size();
        int[] count = new int[size];
        int[] intls = new int[size];
        for (i = 0; i < size; ++i) {
            intls[i] = HecTimeSeriesBase.getIntervalFromEPart(this._intervals.elementAt(i));
            count[i] = 0;
        }
        for (i = 1; i < size; ++i) {
            int diff = intls[i] - intls[i - 1];
            if (diff <= 1) continue;
            intls[i - 1] = intls[i - 1] + diff / 2;
        }
        intls[size - 1] = Integer.MAX_VALUE;
        int prev = timeArray.element(0).value();
        block2: for (int i2 = 1; i2 < timeArray.numberElements(); ++i2) {
            if (!timeArray.element(i2).isDefined()) continue;
            int val = timeArray.element(i2).value();
            int interval = val - prev;
            prev = val;
            for (int j = 0; j < size; ++j) {
                if (interval > intls[j]) continue;
                int n = j;
                count[n] = count[n] + 1;
                continue block2;
            }
        }
        int max = -1;
        int pos = 0;
        for (int i3 = 0; i3 < size; ++i3) {
            if (count[i3] <= max) continue;
            max = count[i3];
            pos = i3;
        }
        return HecTimeSeriesBase.getIntervalFromEPart(this._intervals.elementAt(pos));
    }

    public class TimePanel
    extends JPanel {
        protected int _mode;
        protected JSpinner _numberRows;
        protected JComboBox _intervalCombo;
        protected CalendarField _dateField;
        protected JTextField _timeField;
        protected JLabel _dateLabel;
        protected JCheckBox _includeTimes;
        protected boolean _irregular = true;
        protected int _interval = 0;
        protected int _rows = 0;
        protected HecTime _originalTime;
        protected HecTime _time;
        protected HecTime _limitTime = new HecTime();
        protected int[] ary = new int[1];

        public TimePanel(int mode) {
            this._mode = mode;
            this.build();
        }

        public int getNumberRows() {
            int number = ((SpinnerNumberModel)this._numberRows.getModel()).getNumber().intValue();
            return number;
        }

        public void showIncludeTimesCheckBox(boolean show) {
            this._includeTimes.setVisible(show);
            if (this._mode == 0) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = 1;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                this.add((Component)new JPanel(), gbc);
            }
        }

        public HecTimeArray getAddedTimes() {
            if (!this._includeTimes.isSelected()) {
                return null;
            }
            int size = this.getNumberRows();
            int[] timeVals = new int[size];
            HecTime time = new HecTime(this._originalTime);
            if (this._mode == 1) {
                time.increment(-size - 1, this._interval);
            }
            for (int i = 0; i < size; ++i) {
                time.increment(1, this._interval);
                timeVals[i] = time.value();
            }
            HecTimeArray ta = new HecTimeArray();
            ta.set(timeVals);
            return ta;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel("Number Rows:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5500;
            this.add((Component)label, gbc);
            this._numberRows = new JSpinner(new SpinnerNumberModel(0, 0, 1000000, 1));
            gbc = new GridBagConstraints();
            gbc.ipadx = 10;
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(3, 5, 0, 20);
            this.add((Component)this._numberRows, gbc);
            label = new JLabel("Interval:");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5500;
            this.add((Component)label, gbc);
            this._intervalCombo = new JComboBox<String>(TimeWindowExtensionDialog.this._intervals);
            gbc = new GridBagConstraints();
            gbc.ipadx = 10;
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(3, 5, 0, 5);
            this.add((Component)this._intervalCombo, gbc);
            BasicComboBoxRenderer r = (BasicComboBoxRenderer)this._intervalCombo.getRenderer();
            r.setHorizontalAlignment(4);
            this._dateLabel = new JLabel("Start Date:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(7, 5, 5, 0);
            if (this._mode != 0) {
                this.add((Component)this._dateLabel, gbc);
            }
            this._dateField = new CalendarField();
            label.setLabelFor(this._dateField);
            gbc = new GridBagConstraints();
            gbc.ipadx = 10;
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets(5, 5, 5, 20);
            if (this._mode != 0) {
                this.add((Component)this._dateField, gbc);
            }
            label = new JLabel("Time:");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets(7, 5, 5, 0);
            if (this._mode != 0) {
                this.add((Component)label, gbc);
            }
            this._timeField = new JTextField();
            gbc = new GridBagConstraints();
            gbc.ipadx = 10;
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.INSETS5555;
            if (this._mode != 0) {
                this.add((Component)this._timeField, gbc);
            }
            this._timeField.setHorizontalAlignment(4);
            this._includeTimes = new JCheckBox("Set the date and time for each row");
            this._includeTimes.setSelected(true);
            Dimension d = new Dimension(90, 18);
            this._numberRows.setPreferredSize(d);
            this._intervalCombo.setPreferredSize(d);
            this._dateField.setPreferredSize(d);
            this._timeField.setPreferredSize(d);
        }

        public void init(HecTime time, HecTime limitTime, int interval, String epart, boolean irregular) {
            this._irregular = irregular;
            this._interval = interval;
            if (limitTime != null) {
                this._limitTime.set(limitTime);
            }
            if (this._mode == 2) {
                this._dateLabel.setText("End Date:");
            }
            if (epart.length() > 0) {
                this._intervalCombo.setSelectedItem(epart);
            }
            if (this._irregular) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = this._mode == 0 ? 1 : 2;
                gbc.gridwidth = 3;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.INSETS0555;
                this.add((Component)this._includeTimes, gbc);
            } else {
                this._intervalCombo.setEnabled(false);
            }
            this._originalTime = new HecTime(time);
            this._time = new HecTime(time);
            this.setTime(this._time);
            this.setPanelBorder();
            this._numberRows.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimePanel.this.rowsChanged();
                }
            });
            this._intervalCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimePanel.this.intervalChanged();
                }
            });
            this._dateField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    TimePanel.this.timeChanged();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this._timeField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    TimePanel.this.timeChanged();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }

        public void update() {
            this.reset();
            this.setPanelBorder();
        }

        protected void setPanelBorder() {
            String title;
            HecTime time = this._originalTime;
            int diff = this.getTimeZoneDiff(time);
            if (diff != 0) {
                time = new HecTime(time);
                time.subtractMinutes(diff);
            }
            if (this._mode == 0) {
                HecTime limitTime = this._limitTime;
                if (diff != 0) {
                    limitTime = new HecTime(limitTime);
                    limitTime.subtractMinutes(diff);
                }
                title = "Insert between " + time.toString(7) + " and " + limitTime.toString(7);
            } else {
                title = this._mode == 1 ? "Insert before " + time.toString(7) : "Append after " + time.toString(7);
            }
            this.setBorder(BorderFactory.createTitledBorder(title));
        }

        protected void rowsChanged() {
            int number = this.getNumberRows();
            if (this._rows == number) {
                return;
            }
            this._rows = number;
            if (this._mode == 0) {
                if (number == 0) {
                    return;
                }
                this._time.set(this._originalTime);
                this._time.increment(number, this._interval);
                if (this._time.greaterThanEqualTo(this._limitTime)) {
                    int intl = (this._limitTime.value() - this._originalTime.value()) / number;
                    int pos = this._intervalCombo.getSelectedIndex();
                    for (int i = pos - 1; i >= 0; --i) {
                        int interval = HecTimeSeriesBase.getIntervalFromEPart(TimeWindowExtensionDialog.this._intervals.elementAt(i));
                        if (interval > intl) continue;
                        this._interval = interval;
                        this._intervalCombo.setSelectedIndex(i);
                        return;
                    }
                    this._interval = HecTimeSeriesBase.getIntervalFromEPart(TimeWindowExtensionDialog.this._intervals.elementAt(0));
                    this._intervalCombo.setSelectedIndex(0);
                    this._rows = this._limitTime.value() - this._originalTime.value() - 1;
                    this._numberRows.setValue(new Integer(this._rows));
                }
                return;
            }
            if (this._mode == 1) {
                number = -number;
            }
            this._time.set(this._originalTime);
            this._time.increment(number, this._interval);
            this.setTime(this._time);
        }

        protected void intervalChanged() {
            int interval = HecTimeSeriesBase.getIntervalFromEPart((String)this._intervalCombo.getSelectedItem());
            if (interval == this._interval) {
                return;
            }
            this._interval = interval;
            if (this._mode == 0) {
                int diff = this._originalTime.computeNumberIntervals(this._limitTime, this._interval);
                if (this._rows >= diff) {
                    int nrows = (this._limitTime.value() - this._originalTime.value()) / this._interval;
                    this._rows = this._rows == nrows ? nrows - 1 : nrows;
                    this._numberRows.setValue(new Integer(this._rows));
                }
            } else {
                this.computeTimeChange();
            }
        }

        protected void timeChanged() {
            if (this._time == null) {
                return;
            }
            int stat = this.getTime(this._time);
            if (stat != 0) {
                return;
            }
            this.computeTimeChange();
        }

        protected void computeTimeChange() {
            int diff = this._mode == 1 ? this._time.computeNumberIntervals(this._originalTime, this._interval) : this._originalTime.computeNumberIntervals(this._time, this._interval);
            if (diff < 0) {
                String mess = this._mode == 1 ? this._time.toString(7) + " occurs after the time of the first row." : this._time.toString(7) + " occurs before the time of the last row.";
                JOptionPane.showMessageDialog(TimeWindowExtensionDialog.this._parent, mess, "Date/Time out of order", 2);
                this.reset();
            } else {
                this._rows = diff;
                this._numberRows.setValue(new Integer(this._rows));
            }
        }

        public void reset() {
            this.setTime(this._originalTime);
            this._rows = 0;
            this._numberRows.setValue(new Integer(this._rows));
        }

        protected void setTime(HecTime time) {
            int diff = this.getTimeZoneDiff(time);
            if (diff != 0) {
                time = new HecTime(time);
                time.subtractMinutes(diff);
            }
            this._dateField.setText(time.date(7));
            this._timeField.setText(time.time());
        }

        protected int getTimeZoneDiff(HecTime time) {
            if (TimeWindowExtensionDialog.this._viewTimeZone != null && TimeWindowExtensionDialog.this._dataTimeZone != null) {
                int viewZoneOffset = (int)((long)TimeWindowExtensionDialog.this._viewTimeZone.getRawOffset() / 60000L);
                Date jDate = time.getJavaDate(viewZoneOffset);
                viewZoneOffset = (int)((long)TimeWindowExtensionDialog.this._viewTimeZone.getOffset(jDate.getTime()) / 60000L);
                int dataZoneOffset = (int)((long)TimeWindowExtensionDialog.this._dataTimeZone.getRawOffset() / 60000L);
                jDate = time.getJavaDate(dataZoneOffset);
                dataZoneOffset = (int)((long)TimeWindowExtensionDialog.this._dataTimeZone.getOffset(jDate.getTime()) / 60000L);
                int diff = dataZoneOffset - viewZoneOffset;
                return diff;
            }
            return 0;
        }

        protected int getTime(HecTime time) {
            String date = this._dateField.getText().trim();
            if (date.length() == 0) {
                return -1;
            }
            int istat = time.setDate(date);
            if (istat < 0) {
                JOptionPane.showMessageDialog(TimeWindowExtensionDialog.this._parent, "Invalid Date: " + date, "Invalid Date", 2);
                this.reset();
                return -1;
            }
            String stime = this._timeField.getText().trim();
            if (stime.length() == 0) {
                return -1;
            }
            istat = time.setTime(stime);
            if (istat < 0) {
                JOptionPane.showMessageDialog(TimeWindowExtensionDialog.this._parent, "Invalid Time: " + stime, "Invalid Time", 2);
                this.reset();
                return -1;
            }
            int diff = this.getTimeZoneDiff(time);
            if (diff != 0) {
                time.addMinutes(diff);
            }
            return 0;
        }
    }
}

