/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import java.awt.Component;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;

public class Util {
    public static final String UNDEFINED = "Undefined";
    private Hashtable lastFileModifiedDateTable = new Hashtable();
    private boolean haveNextTimeToExpire = false;
    private long nextTimeToExpire = -1L;

    private static SimpleDateFormat sdfMsgTime() {
        SimpleDateFormat sdfMsgTime = null;
        sdfMsgTime = new SimpleDateFormat("ddMMM HH:mm");
        return sdfMsgTime;
    }

    private static SimpleDateFormat sdfMsgTimeUTC() {
        SimpleDateFormat sdfMsgTimeUTC = null;
        sdfMsgTimeUTC = new SimpleDateFormat("ddMMM HH:mm z");
        sdfMsgTimeUTC.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdfMsgTimeUTC;
    }

    private static SimpleDateFormat sdfMsgTimeSec() {
        SimpleDateFormat sdfMsgTimeSec = null;
        sdfMsgTimeSec = new SimpleDateFormat("ddMMMyyyy HH:mm:ss z");
        return sdfMsgTimeSec;
    }

    private static SimpleDateFormat sdfMsgTimeSecUTC() {
        SimpleDateFormat sdfMsgTimeSecUTC = null;
        sdfMsgTimeSecUTC = new SimpleDateFormat("ddMMMyyyy HH:mm:ss z");
        sdfMsgTimeSecUTC.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdfMsgTimeSecUTC;
    }

    private static SimpleDateFormat sdfMsgTime4UTC() {
        SimpleDateFormat sdfMsgTime4UTC = null;
        sdfMsgTime4UTC = new SimpleDateFormat("ddMMMyyyy HH:mm zzz");
        sdfMsgTime4UTC.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdfMsgTime4UTC;
    }

    public static SimpleDateFormat getSdfMsgTimeSecObj() {
        return Util.sdfMsgTimeSec();
    }

    public static SimpleDateFormat getSdfMsgTimeSecUTCObj() {
        return Util.sdfMsgTimeSecUTC();
    }

    public static String getKeyWordValue(String line, String keyWord) {
        if (line == null) {
            return null;
        }
        int begin = line.indexOf(keyWord + "=");
        int end = line.indexOf(";", begin);
        if (begin >= 0 && end >= 0) {
            return line.substring(begin + keyWord.length() + 1, end);
        }
        return null;
    }

    public static String msgTime() {
        return Util.sdfMsgTime().format(new Date());
    }

    public static String msgTimeUTC() {
        return Util.sdfMsgTimeUTC().format(new Date());
    }

    public static String msgTimeSec() {
        return Util.sdfMsgTimeSec().format(new Date());
    }

    public static String msgTimeSecUTC() {
        return Util.sdfMsgTimeSecUTC().format(new Date());
    }

    public static String msgTime4UTC() {
        return Util.sdfMsgTime4UTC().format(new Date());
    }

    public static String msgTime(long time) {
        if (time == Long.MIN_VALUE) {
            return UNDEFINED;
        }
        return Util.sdfMsgTime().format(new Date(time));
    }

    public static String msgTimeUTC(long time) {
        if (time == Long.MIN_VALUE) {
            return UNDEFINED;
        }
        return Util.sdfMsgTimeUTC().format(new Date(time));
    }

    public static String msgTimeSec(long time) {
        if (time == Long.MIN_VALUE) {
            return UNDEFINED;
        }
        return Util.sdfMsgTimeSec().format(new Date(time));
    }

    public static String msgTimeSecUTC(long time) {
        if (time == Long.MIN_VALUE) {
            return UNDEFINED;
        }
        return Util.sdfMsgTimeSecUTC().format(new Date(time));
    }

    public static String msgTime4UTC(long time) {
        return Util.sdfMsgTime4UTC().format(new Date(time));
    }

    public static long parseLong(String longString, long longDefault) {
        long answer = longDefault;
        try {
            answer = Long.parseLong(longString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return answer;
    }

    public static int parseInt(String intString, int intDefault) {
        int answer = intDefault;
        try {
            answer = Integer.parseInt(intString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return answer;
    }

    public static void waitMillis(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean matchesMask(String strArg, String maskArg, boolean caseSensitive) {
        String str = strArg;
        String mask = maskArg;
        if (!caseSensitive) {
            str = strArg.toLowerCase();
            mask = maskArg.toLowerCase();
        }
        int mp = 0;
        int sp = 0;
        block4: for (mp = 0; mp < mask.length() && sp < str.length(); ++mp) {
            switch (mask.charAt(mp)) {
                case '?': {
                    ++sp;
                    continue block4;
                }
                case '*': {
                    String regtxt;
                    if (mp == mask.length() - 1) {
                        sp = str.length();
                        continue block4;
                    }
                    int ns = mask.indexOf(42, mp + 1);
                    int nq = mask.indexOf(63, mp + 1);
                    if (nq > 1 && (ns > 1 && nq < ns || ns <= 1)) {
                        ns = nq;
                    }
                    if (ns - mp == 1) {
                        System.out.println("Badly formed mask: " + mask);
                        System.out.println("The character after a '*' may not be another wildcard.");
                        return false;
                    }
                    if (ns - mp < 1) {
                        ns = mask.length();
                    }
                    if ((nq = str.indexOf(regtxt = mask.substring(mp + 1, ns), sp)) == -1) {
                        return false;
                    }
                    mp = ns - 1;
                    sp = nq + regtxt.length();
                    continue block4;
                }
                default: {
                    if (mask.charAt(mp) == str.charAt(sp)) {
                        ++sp;
                        continue block4;
                    }
                    return false;
                }
            }
        }
        if (sp == str.length() && mp == mask.length() - 1 && mask.charAt(mp) == '*') {
            ++mp;
        }
        return sp == str.length() && mp == mask.length();
    }

    public boolean hasFileBeenModified(String filename) {
        if (filename == null) {
            return false;
        }
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        long lastModified = file.lastModified();
        Date lastModifiedDate = new Date(lastModified);
        if (this.lastFileModifiedDateTable.containsKey(filename)) {
            Date lastKnownModifiedDate = (Date)this.lastFileModifiedDateTable.get(filename);
            long lastKnownModified = lastKnownModifiedDate.getTime();
            if (lastKnownModified == lastModified) {
                return false;
            }
            this.lastFileModifiedDateTable.put(filename, lastModifiedDate);
            return true;
        }
        this.lastFileModifiedDateTable.put(filename, lastModifiedDate);
        return true;
    }

    public boolean hasTimeExpired(int minutes, int milliSeconds) {
        long currTime = new Date().getTime();
        if (this.haveNextTimeToExpire) {
            if (currTime < this.nextTimeToExpire) {
                return false;
            }
            this.nextTimeToExpire = currTime + (long)(minutes * 60000) + (long)milliSeconds;
            return true;
        }
        this.nextTimeToExpire = currTime + (long)(minutes * 60000) + (long)milliSeconds;
        this.haveNextTimeToExpire = true;
        return true;
    }

    public static long snapTimeToNearestInterval(long timeIn, long interval) {
        if (interval > 86400000L) {
            return -9223372036854775807L;
        }
        long timeOut = timeIn + interval / 2L;
        timeOut = timeOut / interval * interval;
        return timeOut;
    }

    public static long parseTimeIntervalString(String timeInterval) {
        String num = null;
        String type = null;
        if (timeInterval == null) {
            return -1L;
        }
        if ((timeInterval = timeInterval.trim()).equals("") || timeInterval.equals(" ")) {
            return -1L;
        }
        char[] chr = timeInterval.toCharArray();
        for (int i = 0; i < chr.length; ++i) {
            if (Character.isDigit(chr[i])) continue;
            num = timeInterval.substring(0, i);
            type = timeInterval.substring(i);
            break;
        }
        type = type.toUpperCase();
        type = type.trim();
        long factor = -1L;
        int number = Util.parseInt(num, -1);
        if (type.startsWith("S")) {
            factor = 1000L;
        } else if (type.startsWith("MI")) {
            factor = 60000L;
        } else if (type.startsWith("H")) {
            factor = 3600000L;
        } else if (type.startsWith("D")) {
            factor = 86400000L;
        } else if (type.startsWith("W")) {
            factor = 604800000L;
        } else if (type.startsWith("MO")) {
            factor = -1702967296L;
        } else if (type.startsWith("Y")) {
            factor = 1471228928L;
        }
        if (number >= 0 && factor >= 0L) {
            return (long)number * factor;
        }
        return -1L;
    }

    public static Process runProcess(String fileName) throws Exception {
        String[] cmd = new String[]{"rundll32", "url.dll,FileProtocolHandler", fileName};
        Process process = null;
        System.out.println("exec:" + cmd[0] + " " + cmd[1] + " \"" + cmd[2] + "\"");
        process = Runtime.getRuntime().exec(cmd);
        return process;
    }

    public static JFrame getParentFrameFromJMenuItem(JMenuItem jMenuItem) {
        JRootPane rootPane;
        JLayeredPane jlp;
        JMenuBar jmb;
        JMenu jm;
        JPopupMenu popup;
        Component obj = jMenuItem.getParent();
        if (obj instanceof JPopupMenu && (obj = (popup = (JPopupMenu)obj).getInvoker()) instanceof JMenu && (obj = (jm = (JMenu)obj).getParent()) instanceof JMenuBar && (obj = (jmb = (JMenuBar)obj).getParent()) instanceof JLayeredPane && (obj = (jlp = (JLayeredPane)obj).getParent()) instanceof JRootPane && (obj = (rootPane = (JRootPane)obj).getParent()) instanceof JFrame) {
            JFrame frame = (JFrame)obj;
            return frame;
        }
        return null;
    }
}

