/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import hec.util.SimulationEntry;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import rma.util.RMAIO;

public class WatershedEntry {
    private String _path;
    private List<SimulationEntry> _simulations = new ArrayList<SimulationEntry>();
    private String _baseDir;

    public WatershedEntry(String baseDir) {
        this._baseDir = baseDir;
    }

    public WatershedEntry(WatershedEntry wentry) {
        this._baseDir = wentry._baseDir;
        this._path = wentry._path;
    }

    public boolean parse(Element element) {
        Element simulationsRoot;
        String path = element.getAttributeValue("WorkspacePath");
        if (path == null) {
            System.out.println("parse:missing WorkspacePath attribute");
            return false;
        }
        this._path = path;
        String base = element.getAttributeValue("BaseDirectory");
        if (base == null && this._baseDir == null) {
            System.out.println("parse:Missing BaseDirectory attribute");
            return false;
        }
        if (base != null) {
            this._baseDir = base;
        }
        if (!RMAIO.isFullPath(this._path)) {
            this._path = RMAIO.makeAbsolutePath(this._baseDir, this._path);
        }
        if ((simulationsRoot = element.getChild("Simulations")) == null) {
            return false;
        }
        List simulations = simulationsRoot.getChildren();
        for (int i = 0; i < simulations.size(); ++i) {
            SimulationEntry se;
            Element simElem = (Element)simulations.get(i);
            if (simElem == null || !(se = new SimulationEntry(this)).parse(simElem)) continue;
            this._simulations.add(se);
        }
        return true;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getBaseDirectory() {
        return this._baseDir;
    }

    public List<SimulationEntry> getSimulations() {
        return this._simulations;
    }

    public String toString() {
        return RMAIO.getFileNameNoExtension(this.getPath());
    }

    public void addSimulation(SimulationEntry entry) {
        if (entry != null) {
            this._simulations.add(entry);
        }
    }

    public boolean removeSimulation(SimulationEntry se) {
        return this._simulations.remove(se);
    }
}

