/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import com.google.common.flogger.FluentLogger;
import hec.io.HecFile;
import hec.util.BaseXMLUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtilities
extends BaseXMLUtilities {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();

    public static void main(String[] args) {
        double[] doubleArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0};
        double[][] double2Array = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0}};
        String[] strArray = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        Element root = new Element("root");
        Document doc = new Document(root);
        XMLUtilities.createArrayElements(root, doubleArray);
        XMLUtilities.createArrayElements(root, strArray);
        XMLUtilities.createArrayElements(root, double2Array);
        if (XMLUtilities.writeXMLFile(doc, "arrayTest")) {
            XMLUtilities.readXMLFile("arrayTest");
        }
    }

    public static boolean writeXMLFile(Document doc, String fileName) {
        Path file = Paths.get(fileName, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            ((FluentLogger.Api)LOGGER.atConfig()).log("Writing {}", (Object)file);
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            outputter.output(doc, (Writer)writer);
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Exception occurred writing to {}", (Object)file);
            return false;
        }
        return true;
    }

    private static boolean readXMLFile(String fileName) {
        boolean bl;
        block8: {
            Path file = Paths.get(fileName, new String[0]);
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((Reader)reader);
                bl = XMLUtilities.displayArrays(doc);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException | JDOMException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Exception occurred reading from {}", (Object)file);
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDocument(Document doc, HecFile file) {
        if (file == null || doc == null) {
            return false;
        }
        BufferedWriter writer = file.getBufferedWriter();
        if (writer == null) {
            System.out.println("saveDocument:failed to get writer for " + file.getPath());
            return false;
        }
        System.out.println("saveDocument:writing " + file.getPath());
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        try {
            outputter.output(doc, (Writer)writer);
        }
        catch (IOException e) {
            System.out.println("saveDocument:IOException occurred writing to " + file.getPath() + " Error:" + e);
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(HecFile file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            System.out.println("loadDocument:Document File " + file.getPath() + " doesn't exist");
            return null;
        }
        BufferedReader reader = file.getBufferedReader();
        if (reader == null) {
            System.out.println("loadDocument:failed to get reader for " + file.getPath());
            return null;
        }
        System.out.println("loadDocument:reading XML file " + file.getPath());
        try {
            Document doc;
            Document document = doc = XMLUtilities.loadDocument(reader);
            return document;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

