/*
 * Decompiled with CFR 0.152.
 */
package hec.util;

import com.google.common.flogger.FluentLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipUtility {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final int SUCCESS = 0;
    public static final int SETUP_OR_ZIP_EXCEPTION = -1;
    public static final int IO_EXCEPTION = -2;
    public static final int PARTIAL_EXTRACTION = -3;

    public static int extractZipFile(String zipFile, String outputDirectory) {
        if (zipFile == null) {
            ((FluentLogger.Api)LOGGER.atSevere()).log("Problem extracting zip file: NULL zip file");
            return -1;
        }
        if (outputDirectory == null) {
            ((FluentLogger.Api)LOGGER.atSevere()).log("Problem extracting zip file: NULL output directory");
            return -1;
        }
        boolean partialSuccess = false;
        File inputZipFile = new File(zipFile);
        File myOutputDirectory = new File(outputDirectory);
        ZipEntry currentZipFile = null;
        try (ZipFile archive = new ZipFile(inputZipFile);){
            Enumeration<? extends ZipEntry> zipFileContents = archive.entries();
            while (zipFileContents.hasMoreElements()) {
                currentZipFile = zipFileContents.nextElement();
                if (currentZipFile.isDirectory()) continue;
                ZipUtility.processFile(currentZipFile, myOutputDirectory, archive);
                partialSuccess = true;
            }
        }
        catch (ZipException exception) {
            return ZipUtility.handleFailedExtraction(currentZipFile, partialSuccess, exception, -1);
        }
        catch (IOException exception) {
            return ZipUtility.handleFailedExtraction(currentZipFile, partialSuccess, exception, -2);
        }
        return 0;
    }

    private static int handleFailedExtraction(ZipEntry entry, boolean partialSuccess, Exception exception, int retval) {
        if (entry != null) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)exception)).log("Problem extracting zip file. Failed to extract %s", (Object)entry);
        } else {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)exception)).log("Problem extracting zip file.");
        }
        return partialSuccess ? -3 : retval;
    }

    private static void processFile(ZipEntry entry, File myOutputDirectory, ZipFile archive) throws IOException {
        File outFile = new File(myOutputDirectory, entry.toString());
        ZipUtility.createOutputFile(outFile.toPath());
        try (FileOutputStream out = new FileOutputStream(outFile);
             InputStream in = archive.getInputStream(entry);){
            ZipUtility.writeToOutput(in, out);
        }
    }

    private static void writeToOutput(InputStream in, FileOutputStream out) throws IOException {
        byte[] b = new byte[1024];
        while (in.available() > 0) {
            int length = Math.min(1024, in.available());
            int bytesRead = in.read(b, 0, length);
            out.write(b, 0, bytesRead);
        }
    }

    private static void createOutputFile(Path outFile) throws IOException {
        Path parentFile = outFile.getParent();
        if (parentFile == null) {
            throw new IOException("Unable to find parent directory for file: " + outFile);
        }
        Files.createDirectories(parentFile, new FileAttribute[0]);
        Files.createFile(outFile, new FileAttribute[0]);
    }

    public static synchronized byte[] zip(byte[] unzipped) {
        if (unzipped == null || unzipped.length == 0) {
            return unzipped;
        }
        Deflater deflater = new Deflater(1);
        deflater.setInput(unzipped);
        deflater.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(unzipped.length);
        byte[] byteArray = new byte[unzipped.length];
        while (!deflater.finished()) {
            int count = deflater.deflate(byteArray);
            bos.write(byteArray, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        deflater.end();
        return bos.toByteArray();
    }

    public static synchronized byte[] unzip(byte[] zipped) {
        if (zipped == null || zipped.length == 0) {
            return zipped;
        }
        Inflater inflater = new Inflater();
        inflater.setInput(zipped);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(zipped.length);
        byte[] buf = new byte[32768];
        while (!inflater.finished()) {
            try {
                int count = inflater.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            bos.close();
        }
        catch (Exception e) {
            return null;
        }
        inflater.end();
        byte[] newUnZipped = bos.toByteArray();
        return newUnZipped;
    }
}

