/*
 * Decompiled with CFR 0.152.
 */
package hec.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AwaitableFutureTask<T>
extends FutureTask<T> {
    private static final Logger logger = Logger.getLogger(AwaitableFutureTask.class.getName());
    protected final AtomicBoolean wasStarted;
    protected final CountDownLatch actuallyFinishedLatch;

    public AwaitableFutureTask(Runnable runnable) {
        this(Executors.callable(runnable, null));
    }

    public AwaitableFutureTask(Callable<T> callable) {
        this(callable, new AtomicBoolean(false), new CountDownLatch(1));
    }

    private AwaitableFutureTask(final Callable<T> callable, final AtomicBoolean atomBool, final CountDownLatch latch) {
        super(new Callable<T>(){

            @Override
            public T call() throws Exception {
                atomBool.set(true);
                try {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new CancellationException("The interruption flag (Thread.currentThread.isInterrupted()) was set at the start of task execution.");
                    }
                    Object v = callable.call();
                    return v;
                }
                finally {
                    latch.countDown();
                }
            }
        });
        this.wasStarted = atomBool;
        this.actuallyFinishedLatch = latch;
    }

    public void awaitActualCompletion() throws InterruptedException {
        if (this.isCancelled() && !this.wasStarted()) {
            return;
        }
        try {
            this.actuallyFinishedLatch.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            logger.log(Level.FINER, "awaited 500 ms and still hasn't returned. isC:" + this.isCancelled() + " wasS:" + this.wasStarted() + " isD:" + this.isDone() + "c:" + this.actuallyFinishedLatch.getCount(), ie);
            this.actuallyFinishedLatch.await();
        }
    }

    public boolean wasStarted() {
        return this.wasStarted.get();
    }

    public boolean isRunning() {
        return this.wasStarted() && !this.isFinished();
    }

    public boolean isFinished() {
        return this.actuallyFinishedLatch.getCount() <= 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Object retval = super.get();
        return (T)retval;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean wasCancelled = super.cancel(mayInterruptIfRunning);
        boolean cancelled = this.isCancelled();
        if (!wasCancelled || !cancelled) {
            logger.fine("AwaitableFutureTask super.cancel returned unexpected value.  wasCancelled:" + wasCancelled + " isCancelled:" + this.isCancelled());
        }
        return wasCancelled;
    }
}

