/*
 * Decompiled with CFR 0.152.
 */
package hec.util.convertDss6To7;

import hec.util.convertDss6To7.OutputPanel;
import hec.util.convertDss6To7.ProgressBarProgressHandler;
import hec.util.convertDss6To7.SixToSevenUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBoxList;
import rma.swing.list.CheckableListItem;
import rma.swing.list.RmaListModel;

public class SixToSevenGui {
    private JFrame _frame;
    private JPanel _frameContentPane;
    private JTextField _folderTextField;
    private JButton _browseButton;
    private JCheckBox _includeSubdir;
    private JCheckBox _runValueCompare;
    private JCheckBox _deletev6IfSuccessful;
    private JButton _upgradeButton;
    private OutputPanel _outputPanel;
    private RmaJCheckBoxList _listBox;
    private JProgressBar _progressBar;

    public SixToSevenGui() {
        this.buildComponents();
        this.buildListeners();
        this._frame.setVisible(true);
    }

    private void buildListeners() {
        this._browseButton.addActionListener(e -> {
            File f = new File(this._folderTextField.getText());
            JFileChooser fileChooser = new JFileChooser(f);
            fileChooser.setFileSelectionMode(1);
            fileChooser.showOpenDialog(this._frame);
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile != null) {
                this._folderTextField.setText(selectedFile.getPath());
                this.scanDirectory();
            }
        });
        this._upgradeButton.addActionListener(e -> {
            Object[] checkedValues = this._listBox.getCheckedValues();
            final List files = Arrays.stream(checkedValues).filter(value -> value instanceof File).map(value -> (File)value).collect(Collectors.toList());
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            SixToSevenGui.this.setUIEnabled(false);
                            SixToSevenGui.this._frame.setCursor(Cursor.getPredefinedCursor(3));
                        });
                        ProgressBarProgressHandler p = new ProgressBarProgressHandler(SixToSevenGui.this._progressBar);
                        int subtaskCount = 4;
                        if (SixToSevenGui.this._deletev6IfSuccessful.isSelected()) {
                            ++subtaskCount;
                        }
                        if (SixToSevenGui.this._runValueCompare.isSelected()) {
                            ++subtaskCount;
                        }
                        p.setSubtaskCount(subtaskCount);
                        SixToSevenUtil convertCompareUtil = new SixToSevenUtil(files);
                        convertCompareUtil.setCreateLog(SixToSevenGui.this._runValueCompare.isSelected());
                        boolean anyFailed = convertCompareUtil.convert(p);
                        if (anyFailed) {
                            System.err.println("Error: Conversion failed. Not continuing.");
                        } else {
                            if (SixToSevenGui.this._runValueCompare.isSelected()) {
                                convertCompareUtil.dssCompare(p);
                                p.setSubtask(p.getSubtask() + 1);
                            }
                            if (SixToSevenGui.this._deletev6IfSuccessful.isSelected()) {
                                convertCompareUtil.deleteSuccessfullyConverted(p);
                                p.setSubtask(p.getSubtask() + 1);
                            }
                            convertCompareUtil.deleteDSCFiles(p);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            SwingUtilities.invokeAndWait(() -> {
                                SixToSevenGui.this.setUIEnabled(true);
                                SixToSevenGui.this._frame.setCursor(Cursor.getPredefinedCursor(0));
                            });
                        }
                        catch (InterruptedException | InvocationTargetException e) {
                            System.out.println("Error: " + e.getMessage());
                            System.out.println("UI in bad state, please restart application!");
                        }
                    }
                }
            };
            ForkJoinPool.commonPool().submit(r);
        });
        this._folderTextField.addActionListener(e -> this.scanDirectory());
        this._includeSubdir.addActionListener(e -> this.scanDirectory());
    }

    private void setUIEnabled(boolean enabled) {
        this._browseButton.setEnabled(enabled);
        this._upgradeButton.setEnabled(enabled);
        this._folderTextField.setEditable(enabled);
        this._listBox.setEnabled(enabled);
        this._includeSubdir.setEnabled(enabled);
        this._runValueCompare.setEnabled(enabled);
        this._deletev6IfSuccessful.setEnabled(enabled);
    }

    private void scanDirectory() {
        ((RmaListModel)this._listBox.getModel()).clear();
        this.scanDirectory(new File(this._folderTextField.getText()), this._includeSubdir.isSelected());
    }

    private void scanDirectory(File directory, boolean traverseSubdirectories) {
        this._frame.setCursor(Cursor.getPredefinedCursor(3));
        RmaListModel model = (RmaListModel)this._listBox.getModel();
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.toString().toUpperCase().endsWith(".DSS");
                }
            };
            for (File file : files = directory.listFiles(fileFilter)) {
                model.addElement(new CheckableListItem(file, true));
            }
            if (traverseSubdirectories) {
                fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                };
                for (File file : files = directory.listFiles(fileFilter)) {
                    this.scanDirectory(file, true);
                }
            }
        } else {
            System.out.println("File is not a directory or does not exist!");
        }
        this._frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void buildComponents() {
        this._frame = new JFrame();
        this._frame.setDefaultCloseOperation(3);
        this._frame.setSize(400, 600);
        this._frame.setTitle("DSS 7 File Upgrade Tool");
        this._frameContentPane = new JPanel(new GridBagLayout());
        this._frame.setContentPane(this._frameContentPane);
        JPanel browsePanel = new JPanel(new GridBagLayout());
        this._folderTextField = new JTextField();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        browsePanel.add((Component)this._folderTextField, gbc);
        this._browseButton = new JButton("Browse");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        browsePanel.add((Component)this._browseButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._frameContentPane.add((Component)browsePanel, gbc);
        this._includeSubdir = new JCheckBox("Include Subdirectories");
        this._includeSubdir.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._frameContentPane.add((Component)this._includeSubdir, gbc);
        this._runValueCompare = new JCheckBox("Run Comparison");
        this._runValueCompare.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._frameContentPane.add((Component)this._runValueCompare, gbc);
        this._deletev6IfSuccessful = new JCheckBox("Delete DSS6 file if Successful");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._frameContentPane.add((Component)this._deletev6IfSuccessful, gbc);
        this._listBox = new RmaJCheckBoxList();
        this._listBox.setModel(new RmaListModel());
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this._frameContentPane.add((Component)new JScrollPane(this._listBox), gbc);
        this._upgradeButton = new JButton("UPGRADE");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._frameContentPane.add((Component)this._upgradeButton, gbc);
        this._outputPanel = new OutputPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        this._frameContentPane.add((Component)this._outputPanel, gbc);
        this._progressBar = new JProgressBar();
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this._frameContentPane.add((Component)this._progressBar, gbc);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new SixToSevenGui());
    }
}

