/*
 * Decompiled with CFR 0.152.
 */
package hec.util.convertDss6To7;

import hec.heclib.dss.HecDSSUtilities;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecPairedData;
import hec.heclib.dss.HecTimeSeries;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import rma.util.RMAIO;

public class SixToSevenUtil {
    private static final String V6 = "_v6";
    private static final String DSC = ".dsc";
    private static final int SUCCESS = 0;
    private static final int NOT_DSS_6 = 1;
    private static final int ERROR_CONVERT = 2;
    private static final int ERROR_OPEN = 3;
    private static final int ERROR_RENAME = 4;
    private static final int FILE_DIFFERENT = 5;
    private List<File> _files = Collections.emptyList();
    private List<File> _validFiles = Collections.emptyList();
    private Map<File, Result<File>> _renameResults = Collections.emptyMap();
    private Map<File, Result<File>> _upgradeResults = Collections.emptyMap();
    private Map<File, File> _successfulUpgradeFiles = Collections.emptyMap();
    private Map<File, Result<File>> _comparisonResults = Collections.emptyMap();
    private boolean _createLog;

    public SixToSevenUtil(List<File> files) {
        this._files = files;
    }

    private BufferedWriter getWriterForFile(File file) throws IOException {
        String fileAbsPath = file.getParent();
        String fileName = RMAIO.getFileNameNoExtension(file.getPath());
        Object logFileName = RMAIO.concatPath(fileAbsPath, fileName);
        File logFile = new File((String)(logFileName = (String)logFileName + ".6to7"));
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));
        return writer;
    }

    private void log(File toGetLogfileFor, String message) {
        if (this._createLog) {
            try (BufferedWriter writer = this.getWriterForFile(toGetLogfileFor);){
                writer.write("Info: ");
                writer.write(toGetLogfileFor.getName());
                writer.write(":");
                writer.write(message);
                writer.newLine();
            }
            catch (IOException e) {
                System.err.println("Error when logging for file " + toGetLogfileFor.getAbsolutePath());
                e.printStackTrace();
            }
        }
    }

    private void logError(File toGetLogfileFor, String message) {
        if (this._createLog) {
            try (BufferedWriter writer = this.getWriterForFile(toGetLogfileFor);){
                writer.write("Error: ");
                writer.write(":");
                writer.write(message);
                writer.newLine();
            }
            catch (IOException e) {
                System.err.println("Error when logging for file " + toGetLogfileFor.getAbsolutePath());
            }
        }
        System.err.println(toGetLogfileFor.getName() + " " + message);
    }

    public void dssCompare(ProgressHandler p) {
        HashMap<File, Result<File>> results = new HashMap<File, Result<File>>();
        ArrayList<File> test = new ArrayList<File>(this._successfulUpgradeFiles.keySet());
        int numberFilesToCompare = test.size();
        for (int i = 0; i < numberFilesToCompare; ++i) {
            HecDSSUtilities dssUtil6 = new HecDSSUtilities();
            HecDSSUtilities dssUtil7 = new HecDSSUtilities();
            if (p != null) {
                float numberDone = i;
                float percentDone = numberDone / (float)numberFilesToCompare;
                p.updateProgress((int)((double)percentDone * 100.0));
            }
            File dss6File = (File)test.get(i);
            File dss7File = this._successfulUpgradeFiles.get(dss6File);
            this.log(dss7File, "Comparing file: " + dss7File.getAbsolutePath());
            results.put(dss7File, Failure.of(5));
            int status = dssUtil6.setDSSFileName(dss6File.getAbsolutePath());
            if (status != 0) {
                this.logError(dss7File, "Error: Opening file " + dss6File.getAbsolutePath() + " failed.");
                results.put(dss7File, Failure.of(3));
                continue;
            }
            status = dssUtil7.setDSSFileName(dss7File.getAbsolutePath());
            if (status != 0) {
                this.logError(dss7File, "Error: Opening file " + dss6File.getAbsolutePath() + " failed.");
                results.put(dss7File, Failure.of(3));
                continue;
            }
            if (this.compareDSSFiles(dss6File, dss7File, dssUtil6, dssUtil7)) {
                this.log(dss7File, "Files appear to be identical!");
                results.put(dss7File, Success.of(dss6File));
            } else {
                this.logError(dss7File, "Files are not identical!");
            }
            dssUtil6.done();
            dssUtil6.close();
            dssUtil7.done();
            dssUtil7.close();
        }
        this._comparisonResults = results;
        this.printComaprisonResults();
    }

    private boolean compareDSSFiles(File dss6File, File dss7File, HecDSSUtilities dssUtil6, HecDSSUtilities dssUtil7) {
        String[] catalog7;
        boolean same = true;
        String[] catalog6 = dssUtil6.getCatalog(true, "");
        if (catalog6.length != (catalog7 = dssUtil7.getCatalog(true, "")).length) {
            String message = "Catalog length for " + dss6File.getAbsolutePath() + " does not match " + dss7File.getAbsolutePath();
            this.logError(dss7File, message);
            same = false;
        }
        int catalogLength = catalog6.length;
        for (int catalogIndex = 0; catalogIndex < catalogLength && same; ++catalogIndex) {
            String recordAt6 = catalog6[catalogIndex];
            String recordAt7 = catalog7[catalogIndex];
            DataContainer dc6 = null;
            DataContainer dc7 = null;
            if (recordAt6.equalsIgnoreCase(recordAt7)) {
                dc7 = this.readDataContainer(dssUtil7, recordAt6);
                dc6 = this.readDataContainer(dssUtil6, recordAt6);
            } else {
                this.logError(dss7File, "Catalog entry in DSS 6 and 7 file doesn't match!  record6: " + recordAt6 + " record7: " + recordAt7);
                this.log(dss7File, "Trying to read DSS6 path from DSS7 Container");
                dc7 = this.readDataContainer(dssUtil7, recordAt6);
                dc6 = this.readDataContainer(dssUtil6, recordAt6);
            }
            if (dc6 == null) {
                this.logError(dss7File, "Unable to load Datacontainer for path " + recordAt6 + " from DSS6 file.");
                same = false;
                break;
            }
            this.log(dss7File, "Successfully loaded Datacontainer for path " + recordAt6 + " from DSS6 file.");
            if (dc7 == null) {
                this.logError(dss7File, "Unable to load Datacontainer for path " + recordAt6 + " from DSS6 file.");
                same = false;
                break;
            }
            this.log(dss7File, "Successfully loaded Datacontainer for path " + recordAt6 + " from DSS7 file.");
            same = this.compareDataContainer(dss7File, dc6, dc7);
        }
        return same;
    }

    private boolean compareDataContainer(File dss7File, DataContainer dc6, DataContainer dc7) {
        String dc7Type;
        boolean same = true;
        String dc6Type = dc6.getClass().getName();
        if (Objects.equals(dc6Type, dc7Type = dc7.getClass().getName())) {
            this.log(dss7File, "DSS 6 and 7 have same Datacontainer type for " + dc6.fullName);
        } else {
            this.logError(dss7File, "DSS 6 and 7 do NOT have the same Datacontainer type for " + dc6.fullName);
            same = false;
        }
        if (dc6 instanceof PairedDataContainer) {
            if (!this.comparePDC(dss7File, (PairedDataContainer)dc6, (PairedDataContainer)dc7)) {
                same = false;
            }
        } else if (dc7 instanceof TimeSeriesContainer) {
            if (!this.compareTSC(dss7File, (TimeSeriesContainer)dc6, (TimeSeriesContainer)dc7)) {
                same = false;
            }
        } else {
            this.logError(dss7File, "No Comparison for datacontainer type " + dc6Type + " pathname " + dc6.fullName);
        }
        return same;
    }

    private boolean comparePDC(File originalFileName, PairedDataContainer pdc6, PairedDataContainer pdc7) {
        boolean same = true;
        if (pdc6.numberOrdinates != pdc7.numberOrdinates) {
            this.logError(originalFileName, "PDC has different number ordinates! " + pdc6.fullName);
            same = false;
        }
        if (pdc6.numberCurves != pdc6.numberCurves) {
            this.logError(originalFileName, "PDC has different number curves! " + pdc6.fullName);
            same = false;
        }
        if (same) {
            int numberOrdinates = pdc6.numberOrdinates;
            for (int ordinateIndex = 0; ordinateIndex < numberOrdinates; ++ordinateIndex) {
                if (pdc6.xOrdinates[ordinateIndex] == pdc7.xOrdinates[ordinateIndex]) continue;
                this.logError(originalFileName, "PDC " + pdc6.fullName + " has different X ordinate at " + ordinateIndex);
                same = false;
                break;
            }
        }
        int numberCurves = pdc6.numberCurves;
        block1: for (int curveIndex = 0; curveIndex < numberCurves && same; ++curveIndex) {
            double[] curve6 = pdc6.yOrdinates[curveIndex];
            double[] curve7 = pdc7.yOrdinates[curveIndex];
            if (curve6.length != curve7.length) {
                this.logError(originalFileName, "PDC " + pdc6.fullName + " has different curve length at curve " + curveIndex);
                same = false;
                break;
            }
            int curveLength = curve6.length;
            for (int i = 0; i < curveLength; ++i) {
                if (curve6[i] == curve7[i]) continue;
                this.logError(originalFileName, "PDC " + pdc6.fullName + " has a different value in curve " + curveIndex + " at index " + i);
                same = false;
                continue block1;
            }
        }
        if (same) {
            this.log(originalFileName, "Records appear to be identical: " + pdc6.fullName + " " + pdc7.fullName);
        } else {
            this.logError(originalFileName, "Records are not identical: " + pdc6.fullName + " " + pdc7.fullName);
        }
        return same;
    }

    private boolean compareTSC(File orignalFileName, TimeSeriesContainer tsc6, TimeSeriesContainer tsc7) {
        boolean same = true;
        if (tsc6.endTime != tsc7.endTime) {
            this.logError(orignalFileName, "End times are not the same: " + tsc6.fullName);
            same = false;
        }
        if (tsc6.startTime != tsc7.startTime) {
            this.logError(orignalFileName, "Start times are not the same: " + tsc6.fullName);
            same = false;
        }
        if (tsc6.numberValues != tsc7.numberValues) {
            this.logError(orignalFileName, "Number values are not the same: " + tsc6.fullName);
            same = false;
        }
        if (same) {
            int numberValues = tsc6.numberValues;
            for (int timesValues = 0; timesValues < numberValues; ++timesValues) {
                if (tsc6.values[timesValues] != tsc7.values[timesValues]) {
                    this.logError(orignalFileName, "Values are not the same at ordinate " + timesValues + " in record " + tsc6.fullName);
                    same = false;
                    break;
                }
                if (tsc6.times[timesValues] == tsc7.times[timesValues]) continue;
                this.logError(orignalFileName, "Times are not the same at ordinate " + timesValues + " in record " + tsc6.fullName);
                same = false;
                break;
            }
        }
        if (same) {
            this.log(orignalFileName, "Records appear to be identical: " + tsc6.fullName + " " + tsc7.fullName);
        } else {
            this.logError(orignalFileName, "Records are not identical: " + tsc6.fullName + " " + tsc7.fullName);
        }
        return same;
    }

    private void printComaprisonResults() {
        int successful = 0;
        int errorOpening = 0;
        int fileDifferent = 0;
        int unknown = 0;
        StringBuilder differentFiles = new StringBuilder();
        ArrayList<File> dss7Files = new ArrayList<File>(this._comparisonResults.keySet());
        for (int i = 0; i < dss7Files.size(); ++i) {
            File f = (File)dss7Files.get(i);
            Result<File> result = this._comparisonResults.get(f);
            if (!result.wasSuccessful()) {
                differentFiles.append(f.getAbsolutePath());
                differentFiles.append("\n");
                switch (result.getError()) {
                    case 5: {
                        ++fileDifferent;
                        break;
                    }
                    case 3: {
                        ++errorOpening;
                        break;
                    }
                    default: {
                        ++unknown;
                        break;
                    }
                }
                continue;
            }
            ++successful;
        }
        System.out.println("Comparison Complete");
        StringBuilder status = new StringBuilder();
        StringBuilder error = new StringBuilder();
        status.append("Status: \n");
        status.append(successful);
        status.append(" successful comparisons\n");
        if (errorOpening > 0) {
            error.append(errorOpening);
            error.append(" files that were unable to be opened.\n");
        }
        if (unknown > 0) {
            error.append(unknown);
            error.append(" unknown errors.\n");
        }
        if (fileDifferent > 0) {
            error.append(fileDifferent);
            error.append(" files that were different.\n");
        }
        System.out.println(status.toString());
        if (error.length() > 0) {
            System.err.println(error.toString());
            System.err.println("Files that were different: ");
            System.err.println(differentFiles.toString());
        }
    }

    public DataContainer readDataContainer(HecDataManager dataManager, String path) {
        int recordType = dataManager.recordType(path);
        switch (recordType) {
            case 100: 
            case 101: 
            case 105: 
            case 110: 
            case 111: 
            case 115: {
                HecTimeSeries ts = new HecTimeSeries();
                TimeSeriesContainer toReadInto = new TimeSeriesContainer();
                toReadInto.setFullName(path);
                toReadInto.fileName = dataManager.DSSFileName();
                ts.read(toReadInto, false);
                ts.done();
                return toReadInto;
            }
            case 200: {
                HecPairedData pd = new HecPairedData();
                PairedDataContainer pdc = new PairedDataContainer();
                pdc.setFullName(path);
                pdc.fileName = dataManager.DSSFileName();
                pd.read(pdc);
                pd.done();
                return pdc;
            }
        }
        this.log(new File(dataManager.DSSFileName()), "readDataContainer:unknown record type " + recordType + " for " + path);
        return null;
    }

    public void deleteDSCFiles(ProgressHandler progHandler) {
        ArrayList<File> successfulConversions = new ArrayList<File>(this._successfulUpgradeFiles.keySet());
        for (int i = 0; i < successfulConversions.size(); ++i) {
            File file = (File)successfulConversions.get(i);
            File dscFile = SixToSevenUtil.getDSCFileFor(file);
            if (!dscFile.exists()) continue;
            dscFile.delete();
        }
    }

    public void setCreateLog(boolean createLog) {
        this._createLog = createLog;
    }

    public boolean convert(ProgressHandler progHandler) {
        this.findValidDSSFilesThatExist(progHandler);
        progHandler.setSubtask(progHandler.getSubtask() + 1);
        this.renameV6(progHandler);
        progHandler.setSubtask(progHandler.getSubtask() + 1);
        this.upgradeV6(progHandler);
        progHandler.setSubtask(progHandler.getSubtask() + 1);
        boolean anyFailed = this.generateSuccessfulFilesMap();
        this.printStatus();
        return anyFailed;
    }

    private void printStatus() {
        int successful = 0;
        int notDSS6 = 0;
        int errorConverting = 0;
        int errorOpening = 0;
        int errorRenaming = 0;
        int unknown = 0;
        for (int i = 0; i < this._files.size(); ++i) {
            File f = this._files.get(i);
            if (this._validFiles.contains(f)) continue;
            ++errorOpening;
        }
        ArrayList<File> renamedFileOrig = new ArrayList<File>(this._renameResults.keySet());
        block12: for (int i = 0; i < renamedFileOrig.size(); ++i) {
            File f = (File)renamedFileOrig.get(i);
            Result<File> result = this._renameResults.get(f);
            if (result.wasSuccessful()) continue;
            switch (result.getError()) {
                case 1: {
                    ++notDSS6;
                    continue block12;
                }
                case 3: {
                    ++errorOpening;
                    continue block12;
                }
                case 4: {
                    ++errorRenaming;
                    continue block12;
                }
                default: {
                    ++unknown;
                }
            }
        }
        ArrayList<File> convertedOrig = new ArrayList<File>(this._upgradeResults.keySet());
        for (int i = 0; i < convertedOrig.size(); ++i) {
            File f = (File)convertedOrig.get(i);
            Result<File> result = this._upgradeResults.get(f);
            if (!result.wasSuccessful()) {
                switch (result.getError()) {
                    case 1: {
                        ++notDSS6;
                        break;
                    }
                    case 2: {
                        ++errorConverting;
                        break;
                    }
                    case 3: {
                        ++errorOpening;
                        break;
                    }
                    case 4: {
                        ++errorRenaming;
                        break;
                    }
                    default: {
                        ++unknown;
                        break;
                    }
                }
                continue;
            }
            ++successful;
        }
        System.out.println("Operation Complete");
        StringBuilder status = new StringBuilder();
        StringBuilder error = new StringBuilder();
        status.append("Status: \n");
        status.append(successful);
        status.append(" successful conversions\n");
        if (notDSS6 > 0) {
            status.append(notDSS6);
            status.append(" files that were not DSS 6\n");
        }
        if (errorOpening > 0) {
            error.append(errorOpening);
            error.append(" files that were unable to be opened.\n");
        }
        if (errorRenaming > 0) {
            error.append(errorRenaming);
            error.append(" files that were unable to be renamed.\n");
        }
        if (errorConverting > 0) {
            error.append(errorConverting);
            error.append(" files that were unable to be converted.\n");
        }
        if (unknown > 0) {
            error.append(unknown);
            error.append(" unknown errors.\n");
        }
        System.out.println(status.toString());
        if (error.length() > 0) {
            System.err.println(error.toString());
        }
    }

    private boolean generateSuccessfulFilesMap() {
        boolean anyFailed = false;
        HashMap<File, File> sixToSevenFiles = new HashMap<File, File>();
        ArrayList<File> convertedOrig = new ArrayList<File>(this._upgradeResults.keySet());
        for (int i = 0; i < convertedOrig.size(); ++i) {
            File f = (File)convertedOrig.get(i);
            Result<File> result = this._upgradeResults.get(f);
            if (result.wasSuccessful()) {
                sixToSevenFiles.put(f, result.getResult());
                continue;
            }
            if (result.getError() == 1) continue;
            anyFailed = true;
        }
        this._successfulUpgradeFiles = sixToSevenFiles;
        return anyFailed;
    }

    public void deleteSuccessfullyConverted(ProgressHandler handler) {
        if (this._comparisonResults.isEmpty()) {
            ArrayList<File> dss6Files = new ArrayList<File>(this._successfulUpgradeFiles.keySet());
            int numberFiles = dss6Files.size();
            for (int i = 0; i < dss6Files.size(); ++i) {
                if (handler != null) {
                    float percentDone = (float)i + 1.0f / (float)numberFiles;
                    handler.updateProgress((int)((double)percentDone * 100.0));
                }
                File f = (File)dss6Files.get(i);
                File dss7File = this._successfulUpgradeFiles.get(f);
                String message = "Deleting " + f.getAbsolutePath();
                this.log(dss7File, message);
                f.delete();
            }
        } else {
            ArrayList<File> dss7Files = new ArrayList<File>(this._comparisonResults.keySet());
            int numberFiles = dss7Files.size();
            for (int i = 0; i < dss7Files.size(); ++i) {
                File f;
                Result<File> dss7FileResults;
                if (handler != null) {
                    float percentDone = (float)i + 1.0f / (float)numberFiles;
                    handler.updateProgress((int)((double)percentDone * 100.0));
                }
                if (!(dss7FileResults = this._comparisonResults.get(f = (File)dss7Files.get(i))).wasSuccessful()) continue;
                this.log(f, "Deleting DSS 6 file after successful comparison.");
                dss7FileResults.getResult().delete();
            }
        }
    }

    private void upgradeV6(ProgressHandler progHandler) {
        HashMap<File, Result<File>> upgradedFiles = new HashMap<File, Result<File>>();
        for (Map.Entry<File, Result<File>> entry : this._renameResults.entrySet()) {
            if (!entry.getValue().wasSuccessful()) continue;
            upgradedFiles.put(entry.getValue().getResult(), Success.of(entry.getKey()));
        }
        ArrayList filesToUpgrade = new ArrayList(upgradedFiles.keySet());
        HecDSSUtilities dssUtil = new HecDSSUtilities();
        int numFilesToUpgrade = filesToUpgrade.size();
        for (int i = numFilesToUpgrade - 1; i >= 0; --i) {
            Object message;
            if (progHandler != null) {
                float numberDone = numFilesToUpgrade - i;
                float percentDone = numberDone / (float)numFilesToUpgrade;
                progHandler.updateProgress((int)((double)percentDone * 100.0));
            }
            File fileToUpgrade = (File)filesToUpgrade.get(i);
            File originalPath = (File)((Result)upgradedFiles.get(fileToUpgrade)).getResult();
            String absolutePath6 = fileToUpgrade.getAbsolutePath();
            String absolutePath7 = originalPath.getAbsolutePath();
            int status = dssUtil.setDSSFileName(absolutePath6);
            if (status == 0) {
                status = dssUtil.convertVersion(absolutePath7);
                if (status == -858993460) {
                    message = "DSS returned -858993460, possible empty file? Continuing";
                    this.logError(originalPath, (String)message);
                } else if (status != 0) {
                    upgradedFiles.put(fileToUpgrade, Failure.of(2));
                    message = "Converting " + absolutePath6 + " to " + absolutePath7 + " failed with status " + status;
                    this.logError(originalPath, (String)message);
                }
                message = "Successfully converted " + fileToUpgrade.getAbsolutePath() + " to version 7: " + originalPath.getAbsolutePath();
                this.log(originalPath, (String)message);
            } else {
                upgradedFiles.put(fileToUpgrade, Failure.of(3));
                message = "Opening " + absolutePath6 + " failed with status " + status;
                this.logError(originalPath, (String)message);
            }
            dssUtil.close();
        }
        dssUtil.done();
        dssUtil.close();
        this._upgradeResults = upgradedFiles;
    }

    private static File getDSCFileFor(File dssFile) {
        String fileNoExt = SixToSevenUtil.getPathNoExt(dssFile);
        String dscFileName = fileNoExt + DSC;
        File dscFile = new File(dscFileName);
        return dscFile;
    }

    private static String getPathNoExt(File file) {
        String path = file.getParent();
        String fileName = RMAIO.getFileNameNoExtension(file.getAbsolutePath());
        String fileNoExt = RMAIO.concatPath(path, fileName);
        return fileNoExt;
    }

    private void renameV6(ProgressHandler progHandler) {
        HashMap<File, Result<File>> renamedFiles = new HashMap<File, Result<File>>();
        this._validFiles.stream().forEach(file -> renamedFiles.put((File)file, (Result<File>)null));
        int filesToCheck = this._validFiles.size();
        HecDSSUtilities dssUtil = new HecDSSUtilities();
        for (int i = filesToCheck - 1; i >= 0; --i) {
            int status;
            if (progHandler != null) {
                float numberDone = filesToCheck - i;
                float percentDone = numberDone / (float)filesToCheck;
                progHandler.updateProgress((int)((double)percentDone * 100.0));
            }
            File file2 = this._validFiles.get(i);
            String absolutePath = file2.getAbsolutePath();
            String fileExt = RMAIO.getFileExtension(absolutePath);
            String fileNoExt = RMAIO.getFileNameNoExtension(absolutePath);
            String fileDir = file2.getParent();
            if (fileDir != null) {
                fileNoExt = RMAIO.concatPath(fileDir, fileNoExt);
            }
            if ((status = dssUtil.setDSSFileName(absolutePath)) == 0) {
                int dssFileVersion = dssUtil.getDssFileVersion();
                if (dssFileVersion == 6) {
                    File newFileName = new File(fileNoExt + V6 + fileExt);
                    try {
                        file2.renameTo(newFileName);
                        File dscFile = SixToSevenUtil.getDSCFileFor(file2);
                        File dsc_6File = SixToSevenUtil.getDSCFileFor(newFileName);
                        if (dscFile.exists()) {
                            dscFile.renameTo(dsc_6File);
                        }
                        renamedFiles.put(file2, Success.of(newFileName));
                        String message = "Successfully renamed " + file2.getAbsolutePath() + " to " + newFileName.getAbsolutePath();
                        this.log(file2, message);
                    }
                    catch (Exception e) {
                        renamedFiles.put(file2, Failure.of(4));
                        String message = "Error: Failed to rename " + file2.getAbsolutePath() + " to " + newFileName.getAbsolutePath();
                        this.logError(file2, message);
                    }
                } else {
                    String message = "Ignoring DSS file " + absolutePath + " because it is not DSS 6";
                    this.log(file2, message);
                    renamedFiles.put(file2, Failure.of(1));
                }
            } else {
                String message = "Error opening file for version check " + absolutePath + " failed with status " + status;
                this.logError(file2, message);
                renamedFiles.put(file2, Failure.of(3));
            }
            dssUtil.close();
        }
        dssUtil.close();
        this._renameResults = renamedFiles;
    }

    private void findValidDSSFilesThatExist(ProgressHandler progHandler) {
        ArrayList<File> validFiles = new ArrayList<File>(this._files);
        HecDSSUtilities dssUtil = new HecDSSUtilities();
        int fileCheckCount = validFiles.size();
        for (int i = fileCheckCount - 1; i >= 0; --i) {
            if (progHandler != null) {
                float numberDone = fileCheckCount - i;
                float percentDone = numberDone / (float)fileCheckCount;
                progHandler.updateProgress((int)((double)percentDone * 100.0));
            }
            File file = this._files.get(i);
            String absolutePath = file.getAbsolutePath();
            if (file.exists() && file.isFile()) {
                String message;
                int status = dssUtil.setDSSFileName(absolutePath);
                if (status != 0) {
                    message = "DSS Opening " + absolutePath + " failed with status: " + status;
                    this.logError(file, message);
                    validFiles.remove(i);
                }
                dssUtil.close();
                message = "Successfully opened file " + absolutePath;
                this.log(file, message);
                continue;
            }
            String message = absolutePath + " is not a file or does not exist.";
            this.logError(file, message);
            validFiles.remove(i);
        }
        this._validFiles = validFiles;
    }

    public static interface ProgressHandler {
        public void updateProgress(int var1);

        public void setSubtask(int var1);

        public int getSubtask();

        public void setSubtaskCount(int var1);
    }

    private static class Failure<T>
    implements Result<T> {
        int _error;

        private Failure(int error) {
            this._error = error;
        }

        @Override
        public boolean wasSuccessful() {
            return false;
        }

        @Override
        public int getError() {
            return this._error;
        }

        @Override
        public T getResult() {
            return null;
        }

        public static <T> Result<T> of(int error) {
            return new Failure<T>(error);
        }
    }

    public static interface Result<T> {
        public boolean wasSuccessful();

        public int getError();

        public T getResult();
    }

    private static class Success<T>
    implements Result<T> {
        private T _result;

        private Success(T result) {
            this._result = result;
        }

        @Override
        public boolean wasSuccessful() {
            return true;
        }

        @Override
        public int getError() {
            return 0;
        }

        @Override
        public T getResult() {
            return this._result;
        }

        public static <T> Result<T> of(T result) {
            return new Success<T>(result);
        }
    }
}

