/*
 * Decompiled with CFR 0.152.
 */
package hec.util.convertDss6To7;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class TextPaneOutputStream
extends OutputStream {
    private final JTextPane _destination;
    private final Color _color;
    private OutputStream prevOut = null;

    public TextPaneOutputStream(JTextPane destination) {
        this(destination, Color.BLACK);
    }

    public TextPaneOutputStream(JTextPane destination, Color color) {
        this._destination = destination;
        this._color = color;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.prevOut != null) {
            this.prevOut.write(buffer, offset, length);
        }
        final String text = new String(buffer, offset, length);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextPaneOutputStream.this.appendToPane(text);
            }
        });
    }

    private void appendToPane(String msg) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, this._color);
        aset = sc.addAttribute(aset, StyleConstants.FontFamily, "Lucida Console");
        aset = sc.addAttribute(aset, StyleConstants.Alignment, 3);
        int len = this._destination.getDocument().getLength();
        this._destination.setCaretPosition(len);
        this._destination.setCharacterAttributes(aset, false);
        this._destination.replaceSelection(msg);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.prevOut != null) {
            this.prevOut.write(b);
        }
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void installOnSystemOut() {
        this.prevOut = System.out;
        System.setOut(new PrintStream(this));
    }

    public void installOnSystemErr() {
        this.prevOut = System.err;
        System.setErr(new PrintStream(this));
    }
}

