/*
 * Decompiled with CFR 0.152.
 */
package hec.util.transformation.core;

import hec.util.transformation.core.data.Controller;
import hec.util.transformation.core.data.ReadData;
import hec.util.transformation.core.io.Reader;
import hec.util.transformation.core.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import rma.util.lookup.Lookup;

public class ControllerRegistry {
    private static final Map<Class<? extends Controller>, Writer<?, ?>> WRITER_MAP = new HashMap();
    private static final Map<Class<? extends Controller>, Reader<?>> READER_MAP = new HashMap();

    private ControllerRegistry() {
    }

    public static void register(Class<? extends Controller> clazz, Reader reader, Writer writer) {
        READER_MAP.put(clazz, reader);
        WRITER_MAP.put(clazz, writer);
    }

    static <T extends Controller> Reader<T> getReaderForController(T controller) {
        Reader<?> output = READER_MAP.get(controller.getClass());
        if (output == null) {
            Set<Class<? extends Controller>> keys = READER_MAP.keySet();
            for (Class<? extends Controller> key : keys) {
                if (!key.isAssignableFrom(controller.getClass())) continue;
                output = READER_MAP.get(key);
                break;
            }
        }
        return output;
    }

    static <T extends Controller> Writer<T, ? extends ReadData> getWriterForController(T controller) {
        Writer<?, ?> output = WRITER_MAP.get(controller.getClass());
        if (output == null) {
            Set<Class<? extends Controller>> keys = WRITER_MAP.keySet();
            for (Class<? extends Controller> key : keys) {
                if (!key.isAssignableFrom(controller.getClass())) continue;
                output = WRITER_MAP.get(key);
                break;
            }
        }
        return output;
    }

    static {
        Collection writers = Lookup.getDefault().lookupAll(Writer.class);
        Collection readers = Lookup.getDefault().lookupAll(Reader.class);
        for (Writer writer : writers) {
            WRITER_MAP.put(writer.getControllerClass(), writer);
        }
        for (Reader reader : readers) {
            READER_MAP.put(reader.getControllerClass(), reader);
        }
    }
}

