/*
 * Decompiled with CFR 0.152.
 */
package hec.util.transformation.core;

import hec.util.transformation.core.ControllerRegistry;
import hec.util.transformation.core.DataTransformationException;
import hec.util.transformation.core.data.Controller;
import hec.util.transformation.core.data.ReadData;
import hec.util.transformation.core.io.Reader;
import hec.util.transformation.core.io.Writer;

public class DataTransformer {
    private DataTransformer() {
    }

    public static <T extends Controller> boolean run(T controller) throws DataTransformationException {
        boolean output = false;
        try {
            ReadData readData = DataTransformer.read(controller);
            if (readData != null) {
                output = DataTransformer.write(readData, controller);
            }
        }
        catch (RuntimeException ex) {
            throw new DataTransformationException(ex);
        }
        return output;
    }

    private static <T extends Controller> ReadData read(T controller) throws DataTransformationException {
        Reader<T> reader = ControllerRegistry.getReaderForController(controller);
        if (reader == null) {
            throw new DataTransformationException("Unable to get reader for Controller: " + controller.getClass().getSimpleName() + "\r\nThis may be due to several issues.\r\nInvalid use of annotations on the Reader implementation.\r\nService file is missing from the necessary jar.");
        }
        return reader.read(controller);
    }

    private static <T extends Controller> boolean write(ReadData readData, T controller) throws DataTransformationException {
        Writer<T, ReadData> writer = ControllerRegistry.getWriterForController(controller);
        if (writer == null) {
            throw new DataTransformationException("Unable to get writer for Controller: " + controller.getClass().getSimpleName() + "\r\nThis may be due to several issues.\r\nInvalid use of annotations on the Writer implementation.\r\nService file is missing from the necessary jar.");
        }
        return writer.write(readData, controller);
    }
}

