/*
 * Decompiled with CFR 0.152.
 */
package hec.util.transformation.dss;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDss;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMathException;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.util.transformation.core.DataTransformationException;
import hec.util.transformation.core.io.ReaderException;
import hec.util.transformation.core.io.WriterException;
import java.nio.file.Path;

public class DssUtils {
    public static DataContainer readDssData(HecDss dssFile, DSSPathname dssPath, HecTime startTime, HecTime endTime) throws ReaderException {
        DataContainer output = null;
        try {
            DSSIdentifier id = new DSSIdentifier();
            id.setDSSPath(dssPath.pathname());
            id.setTimeWindow(startTime, endTime);
            output = dssFile.get(id);
        }
        catch (Exception ex) {
            throw new ReaderException("Unable to read DSS record " + dssPath + " from file: " + dssFile.getFilename(), ex);
        }
        return output;
    }

    public static void writeDataContainer(DataContainer data, HecDss dssFile) throws WriterException {
        try {
            dssFile.write(data);
        }
        catch (HecMathException hecme) {
            throw new WriterException("Error writing time series record for output file " + dssFile.getFilename() + "\n" + hecme.getMessage());
        }
    }

    public static HecDss openDssFile(Path dssFile) throws DataTransformationException {
        try {
            return HecDss.open(dssFile.toAbsolutePath().toString());
        }
        catch (Exception ex) {
            throw new DataTransformationException("Unable to open HEC-DSS file " + dssFile, ex);
        }
    }
}

