/*
 * Decompiled with CFR 0.152.
 */
package hec.util.transformation.dss.read;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDss;
import hec.heclib.util.HecTime;
import hec.io.DataContainer;
import hec.util.transformation.core.DataTransformationException;
import hec.util.transformation.core.io.Reader;
import hec.util.transformation.core.io.ReaderException;
import hec.util.transformation.dss.DssUtils;
import hec.util.transformation.dss.read.DssReadData;
import hec.util.transformation.dss.read.DssReaderController;
import java.nio.file.Path;

public class DssReader
implements Reader<DssReaderController> {
    @Override
    public Class<DssReaderController> getControllerClass() {
        return DssReaderController.class;
    }

    public DssReadData read(DssReaderController controller) throws ReaderException {
        DssReadData output = new DssReadData();
        HecTime startTime = controller.getStartTime();
        HecTime endTime = controller.getEndTime();
        for (Path dssFile : controller.getDssFileNames()) {
            HecDss dss = this.openDssFile(dssFile);
            for (DSSPathname dssPath : controller.getDataContainerPathNames(dssFile)) {
                DataContainer readData = this.readDssData(dss, dssPath, startTime, endTime);
                output.addDataContainer(dssFile, dssPath, readData);
            }
        }
        return output;
    }

    protected HecDss openDssFile(Path dssFileName) throws ReaderException {
        try {
            return DssUtils.openDssFile(dssFileName);
        }
        catch (DataTransformationException ex) {
            throw new ReaderException(ex);
        }
    }

    protected DataContainer readDssData(HecDss dssFile, DSSPathname dssPath, HecTime startTime, HecTime endTime) throws ReaderException {
        return DssUtils.readDssData(dssFile, dssPath, startTime, endTime);
    }
}

