/*
 * Decompiled with CFR 0.152.
 */
package hec.util.transformation.dss.write;

import hec.heclib.dss.HecDss;
import hec.io.DataContainer;
import hec.util.transformation.core.DataTransformationException;
import hec.util.transformation.core.io.Writer;
import hec.util.transformation.core.io.WriterException;
import hec.util.transformation.dss.DssUtils;
import hec.util.transformation.dss.write.DssWriteData;
import hec.util.transformation.dss.write.DssWriterController;
import java.nio.file.Path;
import java.util.List;

public class DssWriter
implements Writer<DssWriterController, DssWriteData> {
    @Override
    public Class<DssWriterController> getControllerClass() {
        return DssWriterController.class;
    }

    @Override
    public boolean write(DssWriteData data, DssWriterController controller) throws WriterException {
        for (Path dssFile : controller.getOutputDssFileNames()) {
            HecDss hecDss = this.openDssFile(dssFile);
            List<DataContainer> containers = data.getDataContainersForFile(dssFile);
            for (DataContainer container : containers) {
                this.writeTsc(container, hecDss);
            }
        }
        return true;
    }

    protected void writeTsc(DataContainer data, HecDss dssFile) throws WriterException {
        DssUtils.writeDataContainer(data, dssFile);
    }

    protected HecDss openDssFile(Path dssFile) throws WriterException {
        try {
            return DssUtils.openDssFile(dssFile);
        }
        catch (DataTransformationException ex) {
            throw new WriterException(ex);
        }
    }
}

