/*
 * Decompiled with CFR 0.152.
 */
package rma.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import rma.swing.RmaJTable;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.MleHeadRenderer;

public class GroupableHeaderExample
extends JFrame {
    private RmaJTable _table;
    private JButton _button;
    private JScrollPane _scroll;

    GroupableHeaderExample() {
        super("Groupable Header Example");
        this.getContentPane().setLayout(new BorderLayout());
        DefaultTableModel dm = new DefaultTableModel();
        dm.setDataVector(new Object[][]{{"119", "foo", "bar", "ja", "ko", "zh"}, {"911", "bar", "foo", "en", "fr", "pt"}}, new Object[]{"SNo.", "1", "2", "Native", "2", "3"});
        this._table = new RmaJTable((Component)this, new String[][]{{"119", "foo", "bar", "ja", "ko", "zh"}, {"911", "bar", "foo", "en", "fr", "pt"}}, new String[]{"S\nNo.", "1", "2", "Native", "2", "3"});
        this._button = new JButton("Fill Form");
        this._button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupableHeaderExample.this.buildHeader();
            }
        });
        this.getContentPane().add((Component)this._button, "South");
        this._scroll = new JScrollPane(this._table);
        this.getContentPane().add((Component)this._scroll, "Center");
        this.buildHeader();
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    public void buildHeader() {
        RmaJTable table = this._table;
        long t1 = System.currentTimeMillis();
        table.setTableHeader(new GroupableTableHeader(table.getColumnModel()));
        table.setMlHeaderRenderer();
        TableColumnModel cm = table.getColumnModel();
        ColumnGroup g_name = new ColumnGroup("Name");
        g_name.add(cm.getColumn(1));
        if (t1 % 2L == 0L) {
            g_name.add(cm.getColumn(2));
        }
        ColumnGroup g_lang = new ColumnGroup(new MleHeadRenderer(), "My\nLanguage");
        g_lang.add(cm.getColumn(3));
        ColumnGroup g_other = new ColumnGroup(Long.toString(t1));
        g_other.add(cm.getColumn(4));
        if (t1 % 2L == 0L) {
            g_other.add(cm.getColumn(5));
        }
        g_lang.add(g_other);
        GroupableTableHeader header = (GroupableTableHeader)table.getTableHeader();
        header.addColumnGroup(g_name);
        header.addColumnGroup(g_lang);
    }

    public static void main(String[] args) {
        GroupableHeaderExample frame = new GroupableHeaderExample();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }
}

