/*
 * Decompiled with CFR 0.152.
 */
package rma.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RegExpFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    private List _filters;
    private List _patterns;
    private boolean _reverseMatch;
    private boolean _acceptDirectories = false;
    private String _description = "";

    public RegExpFileFilter(List filters) {
        this(filters, false);
    }

    public RegExpFileFilter(List filters, boolean reverse) {
        this._filters = filters;
        this._reverseMatch = reverse;
        this.compileFilters();
    }

    public void setAcceptDirectories(boolean b) {
        this._acceptDirectories = b;
    }

    private void compileFilters() {
        this._patterns = new ArrayList(this._filters.size());
        for (int i = 0; i < this._filters.size(); ++i) {
            Pattern pattern = Pattern.compile((String)this._filters.get(i));
            if (pattern == null) continue;
            this._patterns.add(pattern);
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        File f = new File(dir.getPath() + File.separator + name);
        if (this._acceptDirectories && f.isDirectory()) {
            return true;
        }
        return this.accept(f);
    }

    @Override
    public boolean accept(File f) {
        int size = 0;
        if (this._patterns == null || (size = this._patterns.size()) == 0) {
            return true;
        }
        if (this._acceptDirectories && f.isDirectory()) {
            return true;
        }
        String path = f.getPath();
        for (int i = 0; i < size; ++i) {
            Pattern pattern = (Pattern)this._patterns.get(i);
            if (this._reverseMatch) {
                if (!pattern.matcher(path).matches()) continue;
                return false;
            }
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return this._reverseMatch;
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        this._description = description;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public static void main(String[] args) {
        RegExpFileFilter filter;
        String[] files;
        if (args.length < 1) {
            System.out.println("USAGE: RegExpFileFilter directory filter [filter] [...]");
            return;
        }
        System.out.println("Directory=" + args[0]);
        File f = new File(args[0]);
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            System.out.println("Filter=" + args[i]);
            filters.add(args[i]);
        }
        if (filters.size() == 0) {
            filters.add(".*.log");
        }
        if ((files = f.list(filter = new RegExpFileFilter(filters))) != null) {
            System.out.println("Found " + files.length + " matches");
            for (int i = 0; i < files.length; ++i) {
                System.out.println(files[i]);
            }
        } else {
            System.out.println("No matches");
        }
    }
}

