/*
 * Decompiled with CFR 0.152.
 */
package rma.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class TextFieldParser {
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    BufferedReader _reader = null;
    BufferedWriter _writer = null;
    int[] _columnWidths = null;
    int[] _columnJustification = null;

    public void setOutputFile(File outputFile) throws IOException {
        this.setOutputWriter(new BufferedWriter(new FileWriter(outputFile)));
    }

    public void setOutputWriter(BufferedWriter writer) {
        this._writer = writer;
    }

    public void closeFile() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
            this._writer.close();
        }
        if (this._reader != null) {
            this._reader.close();
        }
    }

    public void setColumnWidths(int[] columnWidths) {
        this._columnWidths = columnWidths;
    }

    public void setColumnJustifacation(int[] columnJustification) {
        this._columnJustification = columnJustification;
    }

    public void writeLine(String[] columnData) throws IOException {
        if (columnData == null) {
            return;
        }
        if (this._writer == null) {
            throw new IOException("No File Specified");
        }
        StringBuffer outBuf = new StringBuffer(this.getLineCapacity());
        int JUSTIFY = 0;
        for (int i = 0; i < this._columnWidths.length && i < columnData.length; ++i) {
            StringBuffer tempBuf = new StringBuffer(columnData[i]);
            JUSTIFY = 0;
            if (this._columnJustification != null && i < this._columnJustification.length) {
                JUSTIFY = this._columnJustification[i];
            }
            if (columnData[i].length() > this._columnWidths[i]) {
                if (JUSTIFY == 1) {
                    tempBuf.delete(0, columnData[i].length() - this._columnWidths[i]);
                } else {
                    tempBuf.setLength(this._columnWidths[i]);
                }
            } else if (columnData[i].length() != this._columnWidths[i] && columnData[i].length() < this._columnWidths[i]) {
                int zz;
                int numSpaces = this._columnWidths[i] - columnData[i].length();
                if (JUSTIFY == 1) {
                    for (zz = 0; zz < numSpaces; ++zz) {
                        tempBuf.insert(0, ' ');
                    }
                } else {
                    for (zz = 0; zz < numSpaces; ++zz) {
                        tempBuf.append(' ');
                    }
                }
            }
            outBuf.append(tempBuf);
        }
        this._writer.write(outBuf.toString());
        this._writer.newLine();
    }

    private int getLineCapacity() {
        int cap = 0;
        for (int i = 0; i < this._columnWidths.length; ++i) {
            cap += this._columnWidths[i];
        }
        return cap;
    }

    public String[] parseString(String line) {
        if (this._columnWidths == null || this._columnWidths.length == 0) {
            String[] parseStrings = new String[]{line};
            return parseStrings;
        }
        String[] parseStrings = new String[this._columnWidths.length];
        int start = 0;
        for (int i = 0; i < parseStrings.length; ++i) {
            if (start >= line.length()) continue;
            if (start + this._columnWidths[i] >= line.length()) {
                parseStrings[i] = line.substring(start);
                continue;
            }
            parseStrings[i] = line.substring(start, start + this._columnWidths[i]).trim();
            start += this._columnWidths[i];
        }
        return parseStrings;
    }
}

