/*
 * Decompiled with CFR 0.152.
 */
package rma.lang;

import java.io.PrintWriter;
import java.io.StringWriter;

public class NestingException
extends Exception {
    private Exception _nestedException;
    private String _stackTraceString;

    public static String generateStackTraceString(Exception e) {
        if (e == null) {
            return "No Stack available. Null Exception recieved.";
        }
        StringWriter s = new StringWriter();
        e.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public NestingException() {
    }

    public NestingException(String msg) {
        super(msg);
    }

    public NestingException(Exception nestedException) {
        this._nestedException = nestedException;
        this._stackTraceString = NestingException.generateStackTraceString(nestedException);
    }

    public NestingException(String msg, Exception nestedException) {
        this(msg);
        this._nestedException = nestedException;
        this._stackTraceString = NestingException.generateStackTraceString(nestedException);
    }

    public Exception getNestedException() {
        return this._nestedException;
    }

    public String getStackTraceString() {
        if (this._nestedException == null) {
            return null;
        }
        StringBuffer traceBuffer = new StringBuffer();
        if (this._nestedException instanceof NestingException) {
            traceBuffer.append(((NestingException)this._nestedException).getStackTraceString());
            traceBuffer.append("-------- nested by:\n");
        }
        traceBuffer.append(this._stackTraceString);
        return traceBuffer.toString();
    }

    @Override
    public String getMessage() {
        String superMsg = super.getMessage();
        if (this.getNestedException() == null) {
            return superMsg;
        }
        StringBuffer theMsg = new StringBuffer();
        String nestedMsg = this.getNestedException().getMessage();
        if (superMsg != null) {
            theMsg.append(superMsg).append(": ").append(nestedMsg);
        } else {
            theMsg.append(nestedMsg);
        }
        return theMsg.toString();
    }

    @Override
    public String toString() {
        StringBuffer theMsg = new StringBuffer(super.toString());
        if (this.getNestedException() != null) {
            theMsg.append("; \n\t---> nested ").append(this.getNestedException());
        }
        return theMsg.toString();
    }
}

