/*
 * Decompiled with CFR 0.152.
 */
package rma.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HostNameIPChecker {
    private static final Logger LOGGER = Logger.getLogger(HostNameIPChecker.class.getName());

    private HostNameIPChecker() {
        throw new AssertionError((Object)"Utility class");
    }

    public static boolean areHostsSame(String host1, String host2) {
        boolean retVal = false;
        if (host1 != null && host2 != null) {
            retVal = host1.equalsIgnoreCase(host2);
            LOGGER.log(Level.FINEST, "Hostnames String compare result: " + retVal);
        }
        if (!retVal) {
            InetAddress[] addressesForHost1 = new InetAddress[]{};
            InetAddress[] addressesForHost2 = new InetAddress[]{};
            try {
                addressesForHost1 = InetAddress.getAllByName(host1);
                addressesForHost2 = InetAddress.getAllByName(host2);
            }
            catch (UnknownHostException e) {
                LOGGER.log(Level.FINEST, e, () -> "InetAddress lookup failed when attempting to check if hosts match: " + host1 + " and " + host2);
            }
            for (InetAddress addressForHost1 : addressesForHost1) {
                for (InetAddress addressForHost2 : addressesForHost2) {
                    String ipAddressForHost1 = addressForHost1.getHostAddress();
                    String ipAddressForHost2 = addressForHost2.getHostAddress();
                    LOGGER.log(Level.FINEST, () -> "Comparing IP for Host 1: " + ipAddressForHost1 + " and IP for Host 2: " + ipAddressForHost2);
                    retVal = ipAddressForHost1.equalsIgnoreCase(ipAddressForHost2);
                    if (!retVal) {
                        String hostNameForHost1 = addressForHost1.getHostName();
                        String hostNameForHost2 = addressForHost2.getHostName();
                        LOGGER.log(Level.FINEST, () -> "Comparing name for Host 1: " + hostNameForHost1 + " and name for Host 2: " + hostNameForHost2);
                        retVal = hostNameForHost1.equalsIgnoreCase(hostNameForHost2);
                    }
                    if (retVal) break;
                }
                if (retVal) break;
            }
        }
        if (retVal) {
            LOGGER.log(Level.FINEST, "Hosts are the same.");
        } else {
            LOGGER.log(Level.FINEST, "Hosts are NOT the same.");
        }
        return retVal;
    }

    public static boolean isLocalhost(String host) {
        if (host == null || host.isBlank()) {
            return false;
        }
        if ("127.0.0.1".equals(host) || "::1".equals(host) || "localhost".equals(host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.isAnyLocalAddress() || address.isLoopbackAddress() || InetAddress.getLocalHost().equals(address);
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.FINEST, e, () -> "InetAddress lookup failed when attempting to check if host matches the localhost: " + host);
            return false;
        }
    }
}

