/*
 * Decompiled with CFR 0.152.
 */
package rma.services;

import java.util.Hashtable;
import java.util.Map;
import java.util.ServiceLoader;
import rma.services.GlobalServiceLoaderDelegate;

public class GlobalServiceLoader {
    private static volatile GlobalServiceLoaderSingleton _singletonServiceLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalServiceLoaderDelegate getInstance() {
        if (_singletonServiceLoader != null) return _singletonServiceLoader;
        Class<GlobalServiceLoader> clazz = GlobalServiceLoader.class;
        synchronized (GlobalServiceLoader.class) {
            if (_singletonServiceLoader != null) return _singletonServiceLoader;
            _singletonServiceLoader = new GlobalServiceLoaderSingleton();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _singletonServiceLoader;
        }
    }

    public static class GlobalServiceLoaderSingleton
    implements GlobalServiceLoaderDelegate {
        private Map<Class, ServiceLoader> _serviceLoaderMap = new Hashtable<Class, ServiceLoader>();

        @Override
        public <S> ServiceLoader<S> getServiceLoader(Class<S> serviceInterface) {
            ServiceLoader<S> serviceLoader = this._serviceLoaderMap.get(serviceInterface);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoader.load(serviceInterface);
                this._serviceLoaderMap.put(serviceInterface, serviceLoader);
            }
            return serviceLoader;
        }

        @Override
        public <S> void removeServiceLoader(Class<S> serviceInterface) {
            this._serviceLoaderMap.remove(serviceInterface);
        }

        @Override
        public void clearAllServiceLoaders() {
            this._serviceLoaderMap.clear();
        }
    }
}

