/*
 * Decompiled with CFR 0.152.
 */
package rma.services.tz.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.swing.SwingUtilities;
import rma.services.tz.TimeZoneComponent;
import rma.services.tz.TimeZoneDisplayService;

public class TimeZoneDisplayServiceImpl
implements TimeZoneDisplayService {
    private TimeZone _timeZone;
    private List<TzEntry> _listenerList = new ArrayList<TzEntry>();
    private LinkedList<WeakEntry> _weakListeners;
    private transient ReferenceQueue queue = new ReferenceQueue();

    @Override
    public synchronized void addTimeZoneListener(TimeZoneComponent listener) {
        if (this._weakListeners == null) {
            this._weakListeners = new LinkedList();
        } else {
            this.processQueue();
        }
        this._weakListeners.add(WeakEntry.create(listener, this.queue));
    }

    public void addTimeZoneComponentListener(TimeZoneComponent comp) {
        if (comp == null) {
            return;
        }
        this._listenerList.add(new TzEntry(TimeZoneComponent.class, comp));
        comp.setTimeZone(this._timeZone);
    }

    public void removeTimeZoneComponentListener(TimeZoneComponent comp) {
        this.removeEntry(comp);
    }

    @Override
    public void addContainer(Container container) {
        if (container == null) {
            return;
        }
        this._listenerList.add(new TzEntry(Container.class, container));
        if (SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new NotifyContainerRunner(container));
        } else {
            this.updateTimeZone(container);
        }
    }

    private void removeEntry(Object uc) {
        this._listenerList.removeIf(c2 -> c2 == null || c2.listener == uc);
        if (this._weakListeners != null) {
            this._weakListeners.removeIf(w -> w == null || w.get() == uc);
        }
    }

    private void processQueue() {
        WeakEntry wk;
        while ((wk = (WeakEntry)this.queue.poll()) != null) {
            this._weakListeners.remove(wk);
        }
    }

    @Override
    public void removeContainer(Container container) {
        this.removeEntry(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeZone(TimeZone tz) {
        if (tz == null) {
            return;
        }
        this._timeZone = tz;
        int size = this._listenerList.size();
        for (int i = 0; i < size; ++i) {
            TzEntry ue = this._listenerList.get(i);
            if (ue.cls.equals(TimeZoneComponent.class)) {
                ((TimeZoneComponent)ue.listener).setTimeZone(this._timeZone);
                continue;
            }
            if (!ue.cls.equals(Container.class)) continue;
            this.updateTimeZone((Container)ue.listener);
        }
        LinkedList targets = null;
        TimeZoneDisplayServiceImpl timeZoneDisplayServiceImpl = this;
        synchronized (timeZoneDisplayServiceImpl) {
            if (this._weakListeners != null) {
                targets = (LinkedList)this._weakListeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                TimeZoneComponent target;
                WeakEntry entry = (WeakEntry)targets.get(i);
                if (entry == null || (target = (TimeZoneComponent)entry.get()) == null) continue;
                target.setTimeZone(tz);
            }
        }
    }

    @Override
    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    @Override
    public void updateTimeZone(Container c2) {
        if (this._timeZone == null) {
            return;
        }
        Component[] comps = null;
        if (c2 == null) {
            return;
        }
        if (c2 instanceof TimeZoneComponent) {
            ((TimeZoneComponent)((Object)c2)).setTimeZone(this.getTimeZone());
        }
        comps = c2.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof TimeZoneComponent) {
                ((TimeZoneComponent)((Object)comps[i])).setTimeZone(this.getTimeZone());
                continue;
            }
            if (!(comps[i] instanceof Container)) continue;
            this.updateTimeZone((Container)comps[i]);
        }
    }

    @Override
    public void updateTimeZone(Container c2, TimeZone timezone) {
        Component[] comps = null;
        if (c2 == null) {
            return;
        }
        comps = c2.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof TimeZoneComponent) {
                ((TimeZoneComponent)((Object)comps[i])).setTimeZone(timezone);
                continue;
            }
            if (!(comps[i] instanceof Container)) continue;
            this.updateTimeZone((Container)comps[i], timezone);
        }
    }

    private static class WeakEntry
    extends WeakReference {
        private int hash;

        private WeakEntry(Object k) {
            super(k);
            this.hash = k.hashCode();
        }

        private static WeakEntry create(Object k) {
            if (k == null) {
                return null;
            }
            return new WeakEntry(k);
        }

        private WeakEntry(Object k, ReferenceQueue q) {
            super(k, q);
            this.hash = k.hashCode();
        }

        private static WeakEntry create(Object k, ReferenceQueue q) {
            if (k == null) {
                return null;
            }
            return new WeakEntry(k, q);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakEntry)) {
                return false;
            }
            Object t = this.get();
            Object u = ((WeakEntry)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    class TzEntry {
        Class cls;
        Object listener;

        public TzEntry(Class cls, Object listener) {
            this.cls = cls;
            this.listener = listener;
        }
    }

    class NotifyContainerRunner
    implements Runnable {
        private Container _container;

        public NotifyContainerRunner(Container container) {
            this._container = container;
        }

        @Override
        public void run() {
            TimeZoneDisplayServiceImpl.this.updateTimeZone(this._container);
        }
    }
}

