/*
 * Decompiled with CFR 0.152.
 */
package rma.services.units.impl;

import hec.data.Units;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import rma.services.units.UnitsComponent;
import rma.services.units.UnitsDisplayService;

public class UnitsDisplayServiceImpl
implements UnitsDisplayService {
    private List<UnitsEntry> _listenerList = new ArrayList<UnitsEntry>();
    private static List<ParamScale> _parameterScaleList = new ArrayList<ParamScale>();
    private int _displayUnitSystem;

    @Override
    public void addUnitsComponent(UnitsComponent uc) {
        if (uc == null) {
            return;
        }
        this._listenerList.add(new UnitsEntry(UnitsComponent.class, uc));
    }

    @Override
    public void removeUnitsComponent(UnitsComponent uc) {
        this.removeEntry(uc);
    }

    private void removeEntry(Object uc) {
        int size = this._listenerList.size();
        for (int i = 0; i < size; ++i) {
            UnitsEntry ue = this._listenerList.get(i);
            if (ue.listener != uc) continue;
            this._listenerList.remove(i);
            return;
        }
    }

    @Override
    public void addContainer(Container container) {
        if (container == null) {
            return;
        }
        this._listenerList.add(new UnitsEntry(Container.class, container));
        if (SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new NotifyContainerRunner(container));
        } else {
            this.updateDisplayScale(container);
            this.updateUnitSystem(container);
        }
    }

    @Override
    public void removeContainer(Container container) {
        this.removeEntry(container);
    }

    @Override
    public int getDisplayUnitsSystem() {
        return this._displayUnitSystem;
    }

    @Override
    public void setDisplayUnitSystem(int system) {
        if (!Units.isValidUnitsSystem(system)) {
            System.out.println("ERROR UnitsDisplayService.setDisplayUnitSystem: I invalid unit system - " + system);
            System.out.println("ERROR RMAJDialog.setClientUnitSystem: Valid Unit Systems (2) SI (1) English");
            return;
        }
        this._displayUnitSystem = system;
        int size = this._listenerList.size();
        for (int i = 0; i < size; ++i) {
            UnitsEntry ue = this._listenerList.get(i);
            if (ue.cls.equals(UnitsComponent.class)) {
                ((UnitsComponent)ue.listener).setDisplayUnitsSystem(this._displayUnitSystem);
                continue;
            }
            if (!ue.cls.equals(Container.class)) continue;
            this.updateUnitSystem((Container)ue.listener);
        }
    }

    @Override
    public double getDisplayScaleFactor(int paramId) {
        ParamScale ps = null;
        for (int j = 0; j < _parameterScaleList.size(); ++j) {
            if (UnitsDisplayServiceImpl._parameterScaleList.get((int)j).paramId != paramId) continue;
            ps = _parameterScaleList.get(j);
        }
        if (ps == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return ps.scaleFactor;
    }

    @Override
    public void setDisplayScaleFactor(int paramId, double scaleFactor) {
        Iterator<ParamScale> iter = _parameterScaleList.iterator();
        while (iter.hasNext()) {
            if (iter.next().paramId != paramId) continue;
            iter.remove();
        }
        _parameterScaleList.add(new ParamScale(paramId, scaleFactor));
        int size = this._listenerList.size();
        for (int i = 0; i < size; ++i) {
            UnitsEntry ue = this._listenerList.get(i);
            if (ue.cls.equals(UnitsComponent.class)) {
                ((UnitsComponent)ue.listener).setDisplayScaleFactor(paramId, scaleFactor);
                continue;
            }
            if (!ue.cls.equals(Container.class)) continue;
            this.updateDisplayScale((Container)ue.listener);
        }
    }

    @Override
    public void updateDisplayScale(Container c2) {
        Component[] comps = null;
        if (c2 == null) {
            return;
        }
        comps = c2.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof UnitsComponent) {
                for (int j = 0; j < _parameterScaleList.size(); ++j) {
                    ParamScale ps = _parameterScaleList.get(j);
                    ((UnitsComponent)((Object)comps[i])).setDisplayScaleFactor(ps.paramId, ps.scaleFactor);
                }
                continue;
            }
            if (!(comps[i] instanceof Container)) continue;
            this.updateDisplayScale((Container)comps[i]);
        }
    }

    @Override
    public void updateUnitSystem(Container c2) {
        if (this._displayUnitSystem == 0) {
            return;
        }
        Component[] comps = null;
        if (c2 == null) {
            return;
        }
        comps = c2.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof UnitsComponent) {
                ((UnitsComponent)((Object)comps[i])).setDisplayUnitsSystem(this._displayUnitSystem);
                continue;
            }
            if (!(comps[i] instanceof Container)) continue;
            this.updateUnitSystem((Container)comps[i]);
        }
    }

    class UnitsEntry {
        Class cls;
        Object listener;

        public UnitsEntry(Class cls, Object listener) {
            this.cls = cls;
            this.listener = listener;
        }
    }

    class NotifyContainerRunner
    implements Runnable {
        private Container _container;

        public NotifyContainerRunner(Container container) {
            this._container = container;
        }

        @Override
        public void run() {
            UnitsDisplayServiceImpl.this.updateDisplayScale(this._container);
            UnitsDisplayServiceImpl.this.updateUnitSystem(this._container);
        }
    }

    class ParamScale {
        int paramId;
        double scaleFactor;

        public ParamScale(int paramId, double scale) {
            this.paramId = paramId;
            this.scaleFactor = scale;
        }
    }
}

