/*
 * Decompiled with CFR 0.152.
 */
package rma.stats.model;

import hec.heclib.dss.HecPairedData;
import hec.io.DSSIdentifier;
import hec.io.DSSPairedDataContainer;
import hec.io.PairedDataContainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import rma.stats.model.Distributions;
import rma.stats.model.DoubleRandomTable;
import rma.util.RMAIO;

@Deprecated
public class DoubleRandomMap
implements DoubleRandomTable {
    private Map<Double, Double> _values = new HashMap<Double, Double>();

    @Override
    public int size() {
        return this._values.size();
    }

    @Override
    public void clear() {
        this._values.clear();
    }

    @Override
    public Object clone() {
        DoubleRandomMap clonedMap = new DoubleRandomMap();
        for (double key : this._values.keySet()) {
            double val = this._values.get(key);
            clonedMap.add(key, val);
        }
        return clonedMap;
    }

    @Override
    public boolean writeBuf(BufferedWriter buf) {
        try {
            double[] idxs = this.getAllIdx();
            double[] vals = this.getAll();
            RMAIO.fout(buf, "MapData:Start");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.size(); ++i) {
                sb.setLength(0);
                sb.append("Entry:");
                sb.append(idxs[i]);
                sb.append(';');
                sb.append(vals[i]);
                buf.write(sb.toString());
                buf.newLine();
            }
            RMAIO.fout(buf, "MapData:End");
        }
        catch (IOException e) {
            System.out.println("Failed to write DoubleRandomMap.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean readBuf(BufferedReader buf) {
        try {
            String line = buf.readLine();
            while (line != null) {
                String[] params;
                if (line.length() == 0) {
                    line = buf.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, ":");
                String param = RMAIO.getParam(line, ":");
                if (type.equals("MapData")) {
                    if (!param.equals("Start") && param.equals("End")) {
                        return true;
                    }
                } else if (type.equals("Entry") && (params = param.split(";")) != null && params.length >= 2) {
                    double key = RMAIO.parseDouble(params[0]);
                    double val = RMAIO.parseDouble(params[1]);
                    this.add(key, val);
                }
                line = buf.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read DoubleRandomMap.");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void add(int idx, double val) {
        this.add((double)idx, val);
    }

    public void add(double idx, double val) {
        this._values.put(idx, val);
    }

    public void addAll(int[] keyArray, double[] valArray) {
        if (keyArray == null || valArray == null || keyArray.length != valArray.length) {
            return;
        }
        for (int i = 0; i < valArray.length; ++i) {
            this.add(keyArray[i], valArray[i]);
        }
    }

    public void addAll(double[] keyArray, double[] valArray) {
        if (keyArray == null || valArray == null || keyArray.length != valArray.length) {
            return;
        }
        for (int i = 0; i < valArray.length; ++i) {
            this.add(keyArray[i], valArray[i]);
        }
    }

    @Override
    public double get(int idx) {
        return this.get((double)idx);
    }

    public double get(double idx) {
        Double valD = this._values.get(idx);
        if (valD == null) {
            return Double.NaN;
        }
        return valD;
    }

    public double[] getAllIdx() {
        double[] idxs = new double[this.size()];
        Iterator<Double> it = this._values.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            idxs[i] = it.next();
            ++i;
        }
        Arrays.sort(idxs);
        return idxs;
    }

    @Override
    public double[] getAll() {
        double[] idxs = this.getAllIdx();
        double[] vals = new double[this.size()];
        for (int i = 0; i < idxs.length; ++i) {
            vals[i] = this.get(idxs[i]);
        }
        return vals;
    }

    @Override
    public void writeDSS(DSSIdentifier dssId) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[1][n];
        for (int i = 0; i < n; ++i) {
            vals[0][i] = this.get(indices[i]);
        }
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public void readDSS(DSSIdentifier dssId) {
        this.clear();
        PairedDataContainer pdc = new PairedDataContainer();
        HecPairedData dssPD = new HecPairedData();
        if (dssId != null) {
            dssPD.setDSSFileName(dssId.getFileName());
            dssPD.setPathname(dssId.getDSSPath());
            dssPD.read(pdc);
        } else {
            System.out.println("Failed to read DoubleRandomSequence.");
        }
        if (pdc != null && pdc.xOrdinates != null && pdc.yOrdinates != null && pdc.yOrdinates.length > 0) {
            this.addAll(pdc.xOrdinates, pdc.yOrdinates[0]);
        }
    }

    private int size(double idx) {
        double[] indices = this.getAllIdx();
        int i = Arrays.binarySearch(indices, idx);
        return i < 0 ? -(i + 1) : i + 1;
    }

    @Override
    public double getAvg(int idx) {
        return this.getAvg((double)idx);
    }

    public double getAvg(double idx) {
        int n = this.size(idx);
        double[] indices = this.getAllIdx();
        double sum1 = 0.0;
        int cnt = 0;
        for (int i = 0; i < n; ++i) {
            sum1 += this.get(indices[i]);
            ++cnt;
        }
        return sum1 / (double)cnt;
    }

    @Override
    public double getAvg() {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double sum1 = 0.0;
        int cnt = 0;
        for (int i = 0; i < n; ++i) {
            sum1 += this.get(indices[i]);
            ++cnt;
        }
        return sum1 / (double)cnt;
    }

    @Override
    public double[] getAllAvg() {
        int n = this.size();
        double[] vals = new double[n];
        double[] indices = this.getAllIdx();
        double sum1 = 0.0;
        int cnt = 0;
        for (int i = 0; i < n; ++i) {
            vals[i] = (sum1 += this.get(indices[i])) / (double)(++cnt);
        }
        return vals;
    }

    @Override
    public void writeAvgDSS(DSSIdentifier dssId) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAllAvg()};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public double getStdv(int idx) {
        return this.getStdv((double)idx);
    }

    public double getStdv(double idx) {
        int n = this.size(idx);
        double[] indices = this.getAllIdx();
        double sum1 = 0.0;
        double sum2 = 0.0;
        int cnt = 0;
        for (int i = 0; i < n; ++i) {
            double val = this.get(indices[i]);
            sum1 += val;
            sum2 += val * val;
            ++cnt;
        }
        double variance = (sum2 - sum1 * sum1 / (double)cnt) / (double)(cnt - 1);
        return variance < 0.0 ? 0.0 : Math.sqrt(variance);
    }

    @Override
    public double getStdv() {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double sum1 = 0.0;
        double sum2 = 0.0;
        int cnt = 0;
        for (int i = 0; i < n; ++i) {
            double val = this.get(indices[i]);
            sum1 += val;
            sum2 += val * val;
            ++cnt;
        }
        double variance = (sum2 - sum1 * sum1 / (double)cnt) / (double)(cnt - 1);
        return variance < 0.0 ? 0.0 : Math.sqrt(variance);
    }

    @Override
    public double[] getAllStdv() {
        int n = this.size();
        double[] vals = new double[n];
        double[] indices = this.getAllIdx();
        double sum1 = 0.0;
        double sum2 = 0.0;
        int cnt = 0;
        for (int i = 0; i < indices.length; ++i) {
            double val = this.get(indices[i]);
            double variance = ((sum2 += val * val) - (sum1 += val) * sum1 / (double)(++cnt)) / (double)(cnt - 1);
            vals[i] = variance < 0.0 ? 0.0 : Math.sqrt(variance);
        }
        return vals;
    }

    @Override
    public void writeStdvDSS(DSSIdentifier dssId) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAllStdv()};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public double getBoundAbsErrorOfMean(int idx, double confidence) {
        return this.getBoundAbsErrorOfMean((double)idx, confidence);
    }

    public double getBoundAbsErrorOfMean(double idx, double confidence) {
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        double stdv = this.getStdv(idx);
        int n = this.size(idx);
        return zr * stdv / Math.sqrt(n);
    }

    @Override
    public double getBoundAbsErrorOfMean(double confidence) {
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        int n = this.size();
        double stdv = this.getStdv();
        return zr * stdv / Math.sqrt(n);
    }

    @Override
    public double[] getAllBoundAbsErrorOfMean(double confidence) {
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        int n = this.size();
        double[] stdv = this.getAllStdv();
        double[] vals = new double[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = zr * stdv[i] / Math.sqrt((double)i + 1.0);
        }
        return vals;
    }

    @Override
    public void writeBoundAbsErrorOfMeanDSS(DSSIdentifier dssId, double confidence) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAllBoundAbsErrorOfMean(confidence)};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public double getBoundRelErrorOfMean(int idx, double confidence) {
        return this.getBoundRelErrorOfMean((double)idx, confidence);
    }

    public double getBoundRelErrorOfMean(double idx, double confidence) {
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        double avg = this.getAvg(idx);
        double stdv = this.getStdv(idx);
        int n = this.size(idx);
        return avg == 0.0 ? (stdv == 0.0 ? 0.0 : Double.NaN) : zr * stdv / avg / Math.sqrt(n);
    }

    @Override
    public double getBoundRelErrorOfMean(double confidence) {
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        int n = this.size();
        double avg = this.getAvg();
        double stdv = this.getStdv();
        return avg == 0.0 ? (stdv == 0.0 ? 0.0 : Double.NaN) : zr * stdv / avg / Math.sqrt(n);
    }

    @Override
    public double[] getAllBoundRelErrorOfMean(double confidence) {
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        int n = this.size();
        double[] avg = this.getAllAvg();
        double[] stdv = this.getAllStdv();
        double[] vals = new double[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = avg[i] == 0.0 ? (stdv[i] == 0.0 ? 0.0 : Double.NaN) : zr * stdv[i] / avg[i] / Math.sqrt((double)i + 1.0);
        }
        return vals;
    }

    @Override
    public void writeBoundRelErrorOfMeanDSS(DSSIdentifier dssId, double confidence) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAllBoundRelErrorOfMean(confidence)};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public double[] getConfidenceInterval(int idx, double confidence) {
        return this.getConfidenceInterval((double)idx, confidence);
    }

    public double[] getConfidenceInterval(double idx, double confidence) {
        double[] interval = new double[2];
        double avg = this.getAvg(idx);
        double absErrBound = this.getBoundAbsErrorOfMean(idx, confidence);
        interval[0] = avg - absErrBound;
        interval[1] = avg + absErrBound;
        return interval;
    }

    @Override
    public double[] getConfidenceInterval(double confidence) {
        double[] interval = new double[2];
        double avg = this.getAvg();
        double absErrBound = this.getBoundAbsErrorOfMean(confidence);
        interval[0] = avg - absErrBound;
        interval[1] = avg + absErrBound;
        return interval;
    }

    @Override
    public double[][] getAllConfidenceInterval(double confidence) {
        double[][] intervals = new double[2][this.size()];
        double[] avg = this.getAllAvg();
        double[] absErrBound = this.getAllBoundAbsErrorOfMean(confidence);
        for (int i = 0; i < this.size(); ++i) {
            intervals[0][i] = avg[i] - absErrBound[i];
            intervals[1][i] = avg[i] + absErrBound[i];
        }
        return intervals;
    }

    @Override
    public void writeConfidenceInterval(DSSIdentifier dssId, double confidence) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = this.getAllConfidenceInterval(confidence);
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("Low");
            labels.add("Up");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    private boolean writePD(DSSIdentifier dssId, double[] indices, double[][] vals, int n, String xType, String yType, String xUnits, String yUnits, Vector labels, boolean writeToDisk) {
        if (dssId != null) {
            HecPairedData dssPD = new HecPairedData();
            dssPD.setDSSFileName(dssId.getFileName());
            dssPD.setPathname(dssId.getDSSPath());
            dssPD.setXType(xType);
            dssPD.setYType(yType);
            dssPD.setXUnits(xUnits);
            dssPD.setYUnits(yUnits);
            dssPD.setLabels(labels);
            dssPD.setStoreDoubles(true);
            dssPD.write(indices, vals, n, vals.length, writeToDisk);
            dssPD.done();
        } else {
            System.out.println("Failed to write DoubleRandomMap.");
        }
        return true;
    }
}

