/*
 * Decompiled with CFR 0.152.
 */
package rma.stats.model;

import hec.heclib.dss.HecPairedData;
import hec.io.DSSIdentifier;
import hec.io.DSSPairedDataContainer;
import hec.io.PairedDataContainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Vector;
import rma.stats.model.Distributions;
import rma.stats.model.DoubleRandomTable;
import rma.util.RMAIO;

@Deprecated
public class DoubleRandomSequence
implements DoubleRandomTable {
    private LinkedList<double[]> _values = new LinkedList();

    @Override
    public int size() {
        return this._values.size();
    }

    @Override
    public void clear() {
        this._values.clear();
    }

    @Override
    public Object clone() {
        DoubleRandomSequence clonedSeq = new DoubleRandomSequence();
        for (int i = 1; i <= this.size(); ++i) {
            clonedSeq.add(this.get(i));
        }
        return clonedSeq;
    }

    @Override
    public boolean writeBuf(BufferedWriter buf) {
        try {
            RMAIO.fout(buf, "SequenceData:Start");
            StringBuffer sb = new StringBuffer();
            for (int i = 1; i <= this.size(); ++i) {
                sb.setLength(0);
                sb.append("Entry:");
                sb.append(i);
                sb.append(';');
                sb.append(this.get(i));
                sb.append(';');
                sb.append(this.getAvg(i));
                sb.append(';');
                sb.append(this.getStdv(i));
                buf.write(sb.toString());
                buf.newLine();
            }
            RMAIO.fout(buf, "SequenceData:End");
        }
        catch (IOException e) {
            System.out.println("Failed to write DoubleRandomSequence.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean readBuf(BufferedReader buf) {
        try {
            String line = buf.readLine();
            while (line != null) {
                String[] params;
                if (line.length() == 0) {
                    line = buf.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, ":");
                String param = RMAIO.getParam(line, ":");
                if (type.equals("SequenceData")) {
                    if (!param.equals("Start") && param.equals("End")) {
                        return true;
                    }
                } else if (type.equals("Entry") && (params = param.split(";")) != null && params.length >= 4) {
                    int idx = RMAIO.parseInt(params[0]);
                    double val = RMAIO.parseDouble(params[1]);
                    this.add(idx, val);
                }
                line = buf.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read DoubleRandomSequence.");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void add(int idx, double val) {
        if (idx < 1 || idx > this.size() + 1) {
            return;
        }
        while (this._values.size() >= idx) {
            this._values.removeLast();
        }
        this.add(val);
    }

    public void add(double val) {
        double[] prevElement = null;
        prevElement = this.size() == 0 ? new double[]{0.0, 0.0, 0.0} : this._values.get(this.size() - 1);
        double[] newElement = new double[3];
        newElement[0] = val;
        if (prevElement == null || prevElement.length < 3) {
            newElement[1] = Double.NaN;
            newElement[2] = Double.NaN;
        } else {
            newElement[1] = prevElement[1] + val;
            newElement[2] = prevElement[2] + val * val;
        }
        this._values.add(newElement);
    }

    public void addAll(int idx, double[] valArray) {
        if (valArray == null) {
            return;
        }
        if (idx < 1 || idx > this.size() + 1) {
            return;
        }
        while (this._values.size() >= idx) {
            this._values.removeLast();
        }
        for (int i = 0; i < valArray.length; ++i) {
            this.add(valArray[i]);
        }
    }

    public void addAll(double[] valArray) {
        if (valArray == null) {
            return;
        }
        for (int i = 0; i < valArray.length; ++i) {
            this.add(valArray[i]);
        }
    }

    @Override
    public double get(int idx) {
        if (idx < 1 || idx > this.size()) {
            return Double.NaN;
        }
        double[] element = this._values.get(idx - 1);
        if (element == null || element.length < 3) {
            return Double.NaN;
        }
        return element[0];
    }

    public double getLast() {
        if (this._values.isEmpty()) {
            return Double.NaN;
        }
        double[] element = this._values.getLast();
        if (element == null || element.length < 3) {
            return Double.NaN;
        }
        return element[0];
    }

    public double[] getAllIdx() {
        double[] idxs = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            idxs[i] = i + 1;
        }
        return idxs;
    }

    @Override
    public double[] getAll() {
        double[] vals = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            vals[i] = this.get(i + 1);
        }
        return vals;
    }

    @Override
    public void writeDSS(DSSIdentifier dssId) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAll()};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public void readDSS(DSSIdentifier dssId) {
        this.clear();
        PairedDataContainer pdc = new PairedDataContainer();
        HecPairedData dssPD = new HecPairedData();
        if (dssId != null) {
            dssPD.setDSSFileName(dssId.getFileName());
            dssPD.setPathname(dssId.getDSSPath());
            dssPD.read(pdc);
        } else {
            System.out.println("Failed to read DoubleRandomSequence.");
        }
        if (pdc != null && pdc.yOrdinates != null && pdc.yOrdinates.length > 0) {
            this.addAll(pdc.yOrdinates[0]);
        }
    }

    @Override
    public double getAvg(int idx) {
        if (idx < 1 || idx > this.size()) {
            return Double.NaN;
        }
        double[] element = this._values.get(idx - 1);
        if (element == null || element.length < 3) {
            return Double.NaN;
        }
        return element[1] / (double)idx;
    }

    @Override
    public double getAvg() {
        if (this._values.isEmpty()) {
            return Double.NaN;
        }
        double[] element = this._values.getLast();
        if (element == null || element.length < 3) {
            return Double.NaN;
        }
        return element[1] / (double)this.size();
    }

    @Override
    public double[] getAllAvg() {
        double[] vals = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            vals[i] = this.getAvg(i + 1);
        }
        return vals;
    }

    @Override
    public void writeAvgDSS(DSSIdentifier dssId) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAllAvg()};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public double getStdv(int idx) {
        if (idx < 1 || idx > this.size()) {
            return Double.NaN;
        }
        double[] element = this._values.get(idx - 1);
        if (element == null || element.length < 3) {
            return Double.NaN;
        }
        double variance = (element[2] - element[1] * element[1] / (double)idx) / (double)(idx - 1);
        return variance < 0.0 ? 0.0 : Math.sqrt(variance);
    }

    @Override
    public double getStdv() {
        if (this._values.isEmpty()) {
            return Double.NaN;
        }
        double[] element = this._values.getLast();
        if (element == null || element.length < 3) {
            return Double.NaN;
        }
        double variance = (element[2] - element[1] * element[1] / (double)this.size()) / (double)(this.size() - 1);
        return variance < 0.0 ? 0.0 : Math.sqrt(variance);
    }

    @Override
    public double[] getAllStdv() {
        double[] vals = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            vals[i] = this.getStdv(i + 1);
        }
        return vals;
    }

    @Override
    public void writeStdvDSS(DSSIdentifier dssId) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAllStdv()};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public double getBoundAbsErrorOfMean(int idx, double confidence) {
        if (idx < 1 || idx > this.size()) {
            return Double.NaN;
        }
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        double stdv = this.getStdv(idx);
        return zr * stdv / Math.sqrt(idx);
    }

    @Override
    public double getBoundAbsErrorOfMean(double confidence) {
        if (this._values.isEmpty()) {
            return Double.NaN;
        }
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        double stdv = this.getStdv();
        return zr * stdv / Math.sqrt(this.size());
    }

    @Override
    public double[] getAllBoundAbsErrorOfMean(double confidence) {
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        int n = this.size();
        double[] vals = this.getAllStdv();
        for (int i = 0; i < n; ++i) {
            vals[i] = zr * vals[i] / Math.sqrt((double)i + 1.0);
        }
        return vals;
    }

    @Override
    public void writeBoundAbsErrorOfMeanDSS(DSSIdentifier dssId, double confidence) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAllBoundAbsErrorOfMean(confidence)};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public double getBoundRelErrorOfMean(int idx, double confidence) {
        if (idx < 1 || idx > this.size()) {
            return Double.NaN;
        }
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        double avg = this.getAvg(idx);
        double stdv = this.getStdv(idx);
        return avg == 0.0 ? (stdv == 0.0 ? 0.0 : Double.NaN) : zr * stdv / avg / Math.sqrt(idx);
    }

    @Override
    public double getBoundRelErrorOfMean(double confidence) {
        if (this._values.isEmpty()) {
            return Double.NaN;
        }
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        double avg = this.getAvg();
        double stdv = this.getStdv();
        return avg == 0.0 ? (stdv == 0.0 ? 0.0 : Double.NaN) : zr * stdv / avg / Math.sqrt(this.size());
    }

    @Override
    public double[] getAllBoundRelErrorOfMean(double confidence) {
        double zr = Distributions.invNormal(0.5 * (1.0 + confidence));
        int n = this.size();
        double[] avg = this.getAllAvg();
        double[] stdv = this.getAllStdv();
        double[] vals = new double[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = avg[i] == 0.0 ? (stdv[i] == 0.0 ? 0.0 : Double.NaN) : zr * stdv[i] / avg[i] / Math.sqrt((double)i + 1.0);
        }
        return vals;
    }

    @Override
    public void writeBoundRelErrorOfMeanDSS(DSSIdentifier dssId, double confidence) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = new double[][]{this.getAllBoundRelErrorOfMean(confidence)};
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    @Override
    public double[] getConfidenceInterval(int idx, double confidence) {
        double[] interval = new double[2];
        if (idx < 1 || idx > this.size()) {
            interval[0] = Double.NaN;
            interval[1] = Double.NaN;
            return interval;
        }
        double avg = this.getAvg(idx);
        double absErrBound = this.getBoundAbsErrorOfMean(idx, confidence);
        interval[0] = avg - absErrBound;
        interval[1] = avg + absErrBound;
        return interval;
    }

    @Override
    public double[] getConfidenceInterval(double confidence) {
        double[] interval = new double[2];
        if (this._values.isEmpty()) {
            interval[0] = Double.NaN;
            interval[1] = Double.NaN;
            return interval;
        }
        double avg = this.getAvg();
        double absErrBound = this.getBoundAbsErrorOfMean(confidence);
        interval[0] = avg - absErrBound;
        interval[1] = avg + absErrBound;
        return interval;
    }

    @Override
    public double[][] getAllConfidenceInterval(double confidence) {
        double[][] intervals = new double[2][this.size()];
        double[] avg = this.getAllAvg();
        double[] absErrBound = this.getAllBoundAbsErrorOfMean(confidence);
        for (int i = 0; i < this.size(); ++i) {
            intervals[0][i] = avg[i] - absErrBound[i];
            intervals[1][i] = avg[i] + absErrBound[i];
        }
        return intervals;
    }

    @Override
    public void writeConfidenceInterval(DSSIdentifier dssId, double confidence) {
        int n = this.size();
        double[] indices = this.getAllIdx();
        double[][] vals = this.getAllConfidenceInterval(confidence);
        String xType = "";
        String yType = "";
        String xUnits = "";
        String yUnits = "";
        Vector labels = new Vector();
        if (dssId instanceof DSSPairedDataContainer) {
            xType = ((DSSPairedDataContainer)dssId).xtype;
            yType = ((DSSPairedDataContainer)dssId).ytype;
            xUnits = ((DSSPairedDataContainer)dssId).xunits;
            yUnits = ((DSSPairedDataContainer)dssId).yunits;
            labels = ((DSSPairedDataContainer)dssId).labels;
        } else {
            yType = dssId.getType();
            yUnits = dssId.getUnits();
            labels.add("Low");
            labels.add("Up");
        }
        this.writePD(dssId, indices, vals, n, xType, yType, xUnits, yUnits, labels, true);
    }

    private boolean writePD(DSSIdentifier dssId, double[] indices, double[][] vals, int n, String xType, String yType, String xUnits, String yUnits, Vector labels, boolean writeToDisk) {
        if (dssId != null) {
            HecPairedData dssPD = new HecPairedData();
            dssPD.setDSSFileName(dssId.getFileName());
            dssPD.setPathname(dssId.getDSSPath());
            dssPD.setXType(xType);
            dssPD.setYType(yType);
            dssPD.setXUnits(xUnits);
            dssPD.setYUnits(yUnits);
            dssPD.setLabels(labels);
            dssPD.setStoreDoubles(true);
            dssPD.write(indices, vals, n, vals.length, writeToDisk);
            dssPD.done();
        } else {
            System.out.println("Failed to write DoubleRandomSequence.");
        }
        return true;
    }
}

