/*
 * Decompiled with CFR 0.152.
 */
package rma.stats.model;

import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.io.DSSPairedDataContainer;
import java.util.Vector;
import rma.stats.model.DoubleRandomTable;
import rma.stats.model.MCVarRealizations;

@Deprecated
public class MCConvVarRealizations
extends MCVarRealizations {
    private double _confidence;
    private double _relErrBound;
    public static final String CONV_AVERAGE = " - AVG";
    public static final String CONV_STDV = " - SD";
    public static final String CONV_ABSERR = " - ABS";
    public static final String CONV_RELERR = " - REL";
    public static final String CONV_INTERR = " - INT";

    public MCConvVarRealizations(String name, DSSIdentifier dssId, int tableType, boolean readPreviousData, double confidence, double relErrBound) {
        super(name, dssId, tableType, readPreviousData);
        if (readPreviousData && this.getRandomTable() != null) {
            this.setRealization(this.getRandomTable().size());
        }
        this._confidence = confidence;
        this._relErrBound = relErrBound;
    }

    public MCConvVarRealizations(String name, DSSIdentifier dssId, double confidence, double relErrBound) {
        this(name, dssId, 2, false, confidence, relErrBound);
    }

    @Override
    public void saveVariate() {
        super.saveVariate();
        if (this.mSavePolicy.canSave()) {
            this.saveStats();
        }
    }

    @Override
    public void saveVariate(int realiz, double variate) {
        super.saveVariate(realiz, variate);
        if (this.mSavePolicy.canSave()) {
            this.saveStats();
        }
    }

    @Override
    public void flushVariate() {
        super.flushVariate();
        this.saveStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStats() {
        DSSIdentifier dssId = this.getDSSId();
        DoubleRandomTable rTable = this.getRandomTable();
        if (rTable == null) {
            return;
        }
        DSSPathname path = new DSSPathname(dssId.getDSSPath());
        String oldPartE = path.getEPart();
        String conf = " " + (int)(100.0 * this._confidence) + "%";
        try {
            path.setEPart(oldPartE + CONV_AVERAGE);
            dssId.setDSSPath(path.getPathname());
            rTable.writeAvgDSS(dssId);
            path.setEPart(oldPartE + CONV_STDV);
            dssId.setDSSPath(path.getPathname());
            rTable.writeStdvDSS(dssId);
            path.setEPart(oldPartE + CONV_ABSERR + conf);
            dssId.setDSSPath(path.getPathname());
            rTable.writeBoundAbsErrorOfMeanDSS(dssId, this._confidence);
            path.setEPart(oldPartE + CONV_INTERR + conf);
            dssId.setDSSPath(path.getPathname());
            if (dssId instanceof DSSPairedDataContainer) {
                Vector oldlabels = ((DSSPairedDataContainer)dssId).labels;
                Vector<Object> newlabels = new Vector<Object>();
                if (((DSSPairedDataContainer)dssId).labels == null || ((DSSPairedDataContainer)dssId).labels.isEmpty()) {
                    newlabels.add("Low");
                    newlabels.add("Up");
                } else {
                    String oldlabel = (String)oldlabels.get(0);
                    newlabels.add(oldlabel + "-Low");
                    newlabels.add(oldlabel + "-Up");
                }
                ((DSSPairedDataContainer)dssId).labels = newlabels;
                rTable.writeConfidenceInterval(dssId, this._confidence);
                ((DSSPairedDataContainer)dssId).labels = oldlabels;
            } else {
                rTable.writeConfidenceInterval(dssId, this._confidence);
            }
            path.setEPart(oldPartE + CONV_RELERR + conf);
            dssId.setDSSPath(path.getPathname());
            rTable.writeBoundRelErrorOfMeanDSS(dssId, this._confidence);
        }
        finally {
            path.setEPart(oldPartE);
            dssId.setDSSPath(path.getPathname());
        }
    }

    public boolean hasConverged() {
        DoubleRandomTable table = this.getRandomTable();
        if (table == null) {
            return false;
        }
        return table.getBoundRelErrorOfMean(this._confidence) < this._relErrBound;
    }

    public boolean hasConverged(int realiz) {
        DoubleRandomTable table = this.getRandomTable();
        if (table == null || realiz <= 1) {
            return false;
        }
        return table.getBoundRelErrorOfMean(realiz, this._confidence) < this._relErrBound;
    }
}

