/*
 * Decompiled with CFR 0.152.
 */
package rma.stats.model;

import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.io.DSSPairedDataContainer;
import java.util.Vector;
import rma.stats.model.DoubleRandomTable;
import rma.stats.model.MCVarRealizations;

@Deprecated
public class MCOutputVarRealizations
extends MCVarRealizations {
    public static final String TEST_LT = "<";
    public static final String TEST_GT = ">";
    public static final String TEST_EQ = "=";
    private boolean _test;
    private String _testOp = "<";
    private double _testVal;
    private boolean _testPass;
    private boolean _conv;
    private double _confidence;
    private double _relErrBound;
    private MCVarRealizations _passTable;
    public static final String OUTPUT_FLAG = " - FLAG";
    public static final String CONV_AVERAGE = " - AVG";
    public static final String CONV_STDV = " - SD";
    public static final String CONV_ABSERR = " - ABS.ERROR";
    public static final String CONV_RELERR = " - REL.ERROR";
    public static final String CONV_INTERR = " - INT";

    public MCOutputVarRealizations(String name, DSSIdentifier dssId, int tableType, boolean readPreviousData, boolean test, String testOp, double testVal, boolean conv, double confidence, double relErrBound) {
        super(name, dssId, tableType, readPreviousData);
        if (readPreviousData && this.getRandomTable() != null) {
            this.setRealization(this.getRandomTable().size());
        }
        this._test = test;
        this._testOp = testOp;
        this._testVal = testVal;
        this._conv = conv;
        this._confidence = confidence;
        this._relErrBound = relErrBound;
        DSSIdentifier flagDssId = new DSSIdentifier(dssId);
        DSSPathname path = new DSSPathname(dssId.getDSSPath());
        path.setEPart(path.getEPart() + OUTPUT_FLAG);
        flagDssId.setDSSPath(path.getPathname());
        flagDssId.setType("");
        flagDssId.setUnits("");
        this._passTable = new MCVarRealizations(name + OUTPUT_FLAG, flagDssId, tableType, readPreviousData);
    }

    public MCOutputVarRealizations(String name, DSSIdentifier dssId, boolean test, String testOp, double testVal, boolean conv, double confidence, double relErrBound) {
        this(name, dssId, 2, false, test, testOp, testVal, conv, confidence, relErrBound);
    }

    @Override
    public void setVariate(double variate) {
        super.setVariate(variate);
        if (this._test) {
            this.computeTestPass();
            this._passTable.setVariate(this._testPass ? 1.0 : 0.0);
        }
    }

    @Override
    public void setRealization(int realiz) {
        super.setRealization(realiz);
        if (this._test) {
            this._passTable.setRealization(realiz);
        }
    }

    @Override
    public void saveVariate() {
        super.saveVariate();
        if (this._test) {
            this._passTable.saveVariate();
        }
        if (this._conv && this.mSavePolicy.canSave()) {
            this.saveStats();
        }
    }

    @Override
    public void flushVariate() {
        super.flushVariate();
        if (this._conv) {
            this.saveStats();
        }
    }

    @Override
    public void saveVariate(int realiz, double variate) {
        super.saveVariate(realiz, variate);
        if (this._test) {
            this._passTable.saveVariate();
        }
        if (this._conv) {
            this.saveStats();
        }
    }

    public void computeTestPass() {
        if (TEST_LT.equals(this._testOp)) {
            this._testPass = this.getVariate() < this._testVal;
            return;
        }
        if (TEST_GT.equals(this._testOp)) {
            this._testPass = this.getVariate() > this._testVal;
            return;
        }
        if (TEST_EQ.equals(this._testOp)) {
            this._testPass = this.getVariate() == this._testVal;
            return;
        }
        this._testPass = false;
    }

    public boolean getTestPass() {
        return this._testPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStats() {
        DSSIdentifier dssId = this.getDSSId();
        DoubleRandomTable rTable = this.getRandomTable();
        if (rTable == null) {
            return;
        }
        DSSPathname path = new DSSPathname(dssId.getDSSPath());
        String oldPartE = path.getEPart();
        String conf = " " + (int)(100.0 * this._confidence) + "%";
        try {
            path.setEPart(oldPartE + CONV_AVERAGE);
            dssId.setDSSPath(path.getPathname());
            rTable.writeAvgDSS(dssId);
            path.setEPart(oldPartE + CONV_STDV);
            dssId.setDSSPath(path.getPathname());
            rTable.writeStdvDSS(dssId);
            path.setEPart(oldPartE + CONV_ABSERR + conf);
            dssId.setDSSPath(path.getPathname());
            rTable.writeBoundAbsErrorOfMeanDSS(dssId, this._confidence);
            path.setEPart(oldPartE + CONV_INTERR + conf);
            dssId.setDSSPath(path.getPathname());
            if (dssId instanceof DSSPairedDataContainer) {
                Vector oldlabels = ((DSSPairedDataContainer)dssId).labels;
                Vector<Object> newlabels = new Vector<Object>();
                if (((DSSPairedDataContainer)dssId).labels == null || ((DSSPairedDataContainer)dssId).labels.isEmpty()) {
                    newlabels.add("Low");
                    newlabels.add("Up");
                } else {
                    String oldlabel = (String)oldlabels.get(0);
                    newlabels.add(oldlabel + "-Low");
                    newlabels.add(oldlabel + "-Up");
                }
                ((DSSPairedDataContainer)dssId).labels = newlabels;
                rTable.writeConfidenceInterval(dssId, this._confidence);
                ((DSSPairedDataContainer)dssId).labels = oldlabels;
            } else {
                rTable.writeConfidenceInterval(dssId, this._confidence);
            }
            path.setEPart(oldPartE + CONV_RELERR + conf);
            dssId.setDSSPath(path.getPathname());
            rTable.writeBoundRelErrorOfMeanDSS(dssId, this._confidence);
        }
        finally {
            path.setEPart(oldPartE);
            dssId.setDSSPath(path.getPathname());
        }
    }

    public boolean hasConverged() {
        DoubleRandomTable table = this.getRandomTable();
        if (table == null) {
            return false;
        }
        return table.getBoundRelErrorOfMean(this._confidence) < this._relErrBound;
    }

    public boolean hasConverged(int realiz) {
        DoubleRandomTable table = this.getRandomTable();
        if (table == null || realiz <= 1) {
            return false;
        }
        return table.getBoundRelErrorOfMean(realiz, this._confidence) < this._relErrBound;
    }
}

