/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import rma.lang.Modifiable;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public abstract class AbstractTextEditorPanel
extends EnabledJPanel
implements Modifiable {
    private static final String GO_TO_LINE = "GoToLine";
    private static final String REPLACE = "Replace";
    protected RSyntaxTextArea _txtArea;
    protected RTextScrollPane _scrollPane;
    private JMenuItem _undoMenuItem;
    private JMenuItem _redoMenuItem;
    private JMenuItem _findAgainMenuItem;
    private FindDialog _findDlg;
    private ReplaceDialog _replaceDlg;
    private SearchListener _searchListener;
    private boolean _allowsEditing = false;
    private List<UndoableEdit> _edits = new ArrayList<UndoableEdit>();
    private String _printDateStr;
    private StringTokenizer _printTokenizer;
    private HashMap _printCache = new HashMap();
    protected ReflectMultiListener _listener;
    private boolean _modified;
    private boolean _menusCreated;

    public AbstractTextEditorPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._listener = new ReflectMultiListener();
        this._txtArea = new RSyntaxTextArea(10, 50);
        this._txtArea.setDragEnabled(true);
        this._scrollPane = new RTextScrollPane((RTextArea)this._txtArea);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.add((Component)this._scrollPane, gbc);
        this.registerListeners();
    }

    protected JMenuBar createMenus() {
        if (!this.canCreateMenus()) {
            return null;
        }
        Window w = SwingUtilities.windowForComponent(this);
        if (w == null) {
            return null;
        }
        JMenuBar mbar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        mbar.add(menu);
        JMenuItem menuItem = new JMenuItem("Save", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "saveAction"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Save As", 65);
        menuItem.addActionListener(this._listener.add(this, menuItem, "saveAsAction"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Print", 80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "printAction"));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Close", 67);
        menuItem.addActionListener(this._listener.add(this, menuItem, "closeAction"));
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setMnemonic('E');
        mbar.add(menu);
        this._undoMenuItem = new JMenuItem("Undo", 117);
        this._undoMenuItem.setEnabled(false);
        this._undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2, false));
        this._undoMenuItem.addActionListener(this._listener.add(this, this._undoMenuItem, "undoAction"));
        menu.add(this._undoMenuItem);
        this._redoMenuItem = new JMenuItem("Redo", 114);
        this._redoMenuItem.setEnabled(false);
        this._redoMenuItem.addActionListener(this._listener.add(this, this._redoMenuItem, "redoAction"));
        menu.addSeparator();
        menuItem = new JMenuItem("Copy", 67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "copyAction"));
        menu.add(menuItem);
        if (this.isEditable()) {
            menuItem = new JMenuItem("Cut", 116);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
            menuItem.addActionListener(this._listener.add(this, menuItem, "cutAction"));
            menu.add(menuItem);
            menuItem = new JMenuItem("Paste", 80);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
            menuItem.addActionListener(this._listener.add(this, menuItem, "pasteAction"));
            menu.add(menuItem);
        }
        menu.addSeparator();
        menuItem = new JMenuItem("Select All", 65);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectAllAction"));
        menu.add(menuItem);
        menu = new JMenu("Search");
        menu.setMnemonic('S');
        mbar.add(menu);
        menuItem = new JMenuItem("Find", 70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "findAction"));
        menu.add(menuItem);
        this._findAgainMenuItem = new JMenuItem("Find Again", 65);
        this._findAgainMenuItem.setEnabled(false);
        this._findAgainMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0, false));
        this._findAgainMenuItem.addActionListener(this._listener.add(this, this._findAgainMenuItem, "findAgain"));
        if (w instanceof JDialog) {
            ((JDialog)w).setJMenuBar(mbar);
        } else if (w instanceof JFrame) {
            ((JFrame)w).setJMenuBar(mbar);
        } else {
            System.out.println("createMenus:enclosing window type not supported " + (w == null ? "null" : w.getClass().toString()));
        }
        menuItem = new JMenuItem("Go To...");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "gotoLineNumber"));
        menu.add(menuItem);
        this._menusCreated = true;
        return mbar;
    }

    protected void registerListeners() {
        this._txtArea.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                AbstractTextEditorPanel.this.undoableEditHappened(e);
            }
        });
        this._txtArea.requestDefaultFocus();
        this._searchListener = new SearchListener(){

            public void searchEvent(SearchEvent e) {
                if (e.getType() == SearchEvent.Type.REPLACE_ALL) {
                    SearchResult result = SearchEngine.replaceAll((RTextArea)AbstractTextEditorPanel.this._txtArea, (SearchContext)e.getSearchContext());
                    if (result.getCount() > 0) {
                        AbstractTextEditorPanel.this.setModified(true);
                    }
                } else if (e.getType() == SearchEvent.Type.REPLACE) {
                    SearchResult result = SearchEngine.replace((RTextArea)AbstractTextEditorPanel.this._txtArea, (SearchContext)e.getSearchContext());
                    if (result.getCount() > 0) {
                        AbstractTextEditorPanel.this.setModified(true);
                    }
                } else if (e.getType() == SearchEvent.Type.FIND) {
                    SearchEngine.find((JTextArea)AbstractTextEditorPanel.this._txtArea, (SearchContext)e.getSearchContext());
                }
            }

            public String getSelectedText() {
                return AbstractTextEditorPanel.this._txtArea.getSelectedText();
            }
        };
        AbstractAction replaceAction = new AbstractAction(REPLACE){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTextEditorPanel.this.replaceAction();
            }
        };
        this._txtArea.getActionMap().put(REPLACE, replaceAction);
        this._txtArea.getInputMap().put(KeyStroke.getKeyStroke("control R"), REPLACE);
        AbstractAction goToLineAction = new AbstractAction(GO_TO_LINE){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTextEditorPanel.this.gotoLineNumber();
            }
        };
        this._txtArea.getActionMap().put(GO_TO_LINE, goToLineAction);
        this._txtArea.getInputMap().put(KeyStroke.getKeyStroke("control L"), GO_TO_LINE);
    }

    protected abstract boolean canCreateMenus();

    public abstract boolean saveAction();

    protected boolean canSaveAs() {
        return false;
    }

    public void setEditable(boolean tf) {
        this._txtArea.setEditable(tf);
    }

    public boolean isEditable() {
        return this._txtArea.isEditable();
    }

    public void setText(String txt) {
        this._txtArea.setText(txt);
        this._txtArea.setCaretPosition(0);
        this._edits.clear();
        this.updateMenu();
    }

    public String getText() {
        return this._txtArea.getText();
    }

    protected void setAllowEditing(boolean canEdit) {
        this._allowsEditing = canEdit;
        this._txtArea.setEditable(this._allowsEditing);
    }

    public void cutAction() {
        this._txtArea.cut();
    }

    public void copyAction() {
        this._txtArea.copy();
    }

    public void pasteAction() {
        this._txtArea.paste();
    }

    public void selectAllAction() {
        this._txtArea.selectAll();
    }

    public String getSelectedText() {
        return this._txtArea.getSelectedText();
    }

    public void closeAction() {
        Window w = SwingUtilities.windowForComponent(this);
        if (this.isModified() && this._allowsEditing) {
            int opt = JOptionPane.showConfirmDialog(this, "Do you want to save the changes made?", "Save Changes", 1);
            if (opt == 0) {
                this.saveAction();
                return;
            }
            if (opt == 2) {
                return;
            }
        }
        w.setVisible(false);
        w.dispose();
    }

    private void undoableEditHappened(UndoableEditEvent ev) {
        UndoableEdit lastEdit = ev.getEdit();
        if (lastEdit.canUndo()) {
            this._edits.add(lastEdit);
        }
        this.updateMenu();
    }

    protected void updateMenu() {
        if (!this.canCreateMenus() || !this._menusCreated) {
            return;
        }
        UndoableEdit lastEdit = this.getLastEdit();
        if (lastEdit != null) {
            this._undoMenuItem.setEnabled(lastEdit.canUndo());
            this._redoMenuItem.setEnabled(lastEdit.canRedo());
            this._undoMenuItem.setToolTipText(lastEdit.getUndoPresentationName());
            this._redoMenuItem.setToolTipText(lastEdit.getRedoPresentationName());
        } else {
            this._undoMenuItem.setEnabled(false);
            this._redoMenuItem.setEnabled(false);
            this._undoMenuItem.setToolTipText(null);
            this._redoMenuItem.setToolTipText(null);
        }
    }

    protected UndoableEdit popLastEdit() {
        if (this._edits.size() == 0) {
            return null;
        }
        return this._edits.remove(this._edits.size() - 1);
    }

    protected UndoableEdit getLastEdit() {
        if (this._edits.size() == 0) {
            return null;
        }
        return this._edits.get(this._edits.size() - 1);
    }

    public void printAction() {
        try {
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            prnJob.setPrintable(new Printable(){

                @Override
                public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                    return AbstractTextEditorPanel.this.print(graphics, pageFormat, pageIndex);
                }
            });
            if (!prnJob.printDialog()) {
                return;
            }
            this._printDateStr = null;
            this._printCache.clear();
            this._printTokenizer = new StringTokenizer(this._txtArea.getText(), "\n");
            prnJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }
    }

    private int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Window w = SwingUtilities.windowForComponent(this);
        String title = "";
        if (w instanceof JDialog) {
            title = ((JDialog)w).getTitle();
        } else if (w instanceof JFrame) {
            title = ((JFrame)w).getTitle();
        }
        if (this._printDateStr == null) {
            this._printDateStr = new Date().toString().substring(4);
        }
        if (!this._printTokenizer.hasMoreTokens()) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        g2.setFont(new Font("Helvetica", 0, 10));
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        int linesOnPage = (int)(pageHeight / (double)(fontHeight + fontDesent));
        linesOnPage -= 2;
        int x = (int)pageFormat.getImageableX() + 10;
        int y = (int)pageFormat.getImageableY() + 12;
        g.drawString("File: " + title + ", Page: " + (pageIndex + 1), x, y);
        y += 36;
        pageHeight = pageFormat.getImageableY() + pageFormat.getImageableHeight();
        ArrayList<String> printCacheData = (ArrayList<String>)this._printCache.get(new Integer(pageIndex));
        if (printCacheData == null) {
            printCacheData = new ArrayList<String>();
            this._printCache.put(new Integer(pageIndex), printCacheData);
            while ((double)(y + 12) < pageHeight && this._printTokenizer.hasMoreTokens()) {
                String str = this._printTokenizer.nextToken();
                printCacheData.add(str);
                g.drawString(str, x, y);
                y += 12;
            }
        } else {
            for (int i = 0; i < printCacheData.size(); ++i) {
                g.drawString((String)printCacheData.get(i), x, y);
                y += 12;
            }
        }
        return 0;
    }

    public void gotoLineNumber() {
        String line = JOptionPane.showInputDialog(this, "Enter line-number to (1.." + this._txtArea.getLineCount() + ")", "Go To Line", -1);
        if (line != null) {
            int lineNum = RMAIO.parseInt(line);
            this.gotoLineNumber(--lineNum);
        }
    }

    public void gotoLineNumber(int lineNumber) {
        try {
            if (lineNumber >= 0 && lineNumber < this._txtArea.getLineCount()) {
                this._txtArea.scrollRectToVisible(this._txtArea.modelToView(this._txtArea.getLineStartOffset(lineNumber)));
                this._txtArea.setCaretPosition(this._txtArea.getLineStartOffset(lineNumber));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void undoAction() {
        UndoableEdit lastEdit = this.popLastEdit();
        if (lastEdit == null) {
            return;
        }
        lastEdit.undo();
        if (lastEdit.canUndo()) {
            this._edits.add(lastEdit);
        }
        this.updateMenu();
    }

    private void initFindReplaceDialogs() {
        if (this._findDlg == null) {
            Window w = SwingUtilities.windowForComponent(this);
            if (w instanceof JDialog) {
                this._findDlg = new FindDialog((Dialog)((JDialog)w), this._searchListener);
                this._replaceDlg = new ReplaceDialog((Dialog)((JDialog)w), this._searchListener);
                SearchContext context = this._findDlg.getSearchContext();
                this._replaceDlg.setSearchContext(context);
            } else if (w instanceof JFrame) {
                this._findDlg = new FindDialog((Frame)((JFrame)w), this._searchListener);
                this._replaceDlg = new ReplaceDialog((Frame)((JFrame)w), this._searchListener);
                SearchContext context = this._findDlg.getSearchContext();
                this._replaceDlg.setSearchContext(context);
            }
        }
    }

    public void findAction() {
        if (this._findDlg == null) {
            this.initFindReplaceDialogs();
        }
        if (this._findDlg != null) {
            String selText = this._txtArea.getSelectedText();
            if (selText != null && !selText.isEmpty()) {
                this._findDlg.setSearchString(selText);
            }
            this._findDlg.setLocationRelativeTo((Component)this);
            this._findDlg.setVisible(true);
        }
    }

    public void replaceAction() {
        if (this._txtArea.isEditable() && this._txtArea.isEnabled()) {
            if (this._replaceDlg == null) {
                this.initFindReplaceDialogs();
            }
            if (this._replaceDlg != null) {
                String selText = this._txtArea.getSelectedText();
                if (selText != null && !selText.isEmpty()) {
                    this._replaceDlg.setSearchString(selText);
                }
                this._replaceDlg.setLocationRelativeTo((Component)this);
                this._replaceDlg.setVisible(true);
            }
        }
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        this._modified = modified;
        if (modified) {
            RMAUtil.setParentModified(this);
        } else {
            RMAUtil.setChildrenUnmodified(this);
        }
    }

    protected JTextArea getTextArea() {
        return this._txtArea;
    }

    public void setTextFont(Font f) {
        this._txtArea.setFont(f);
    }

    public Font getTextFont() {
        return this._txtArea.getFont();
    }
}

