/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.EditableComponent;
import rma.swing.RmaGridBagConstraints;

public class ButtonCmdPanel
extends JPanel
implements ActionListener,
Serializable,
EditableComponent {
    public static final int TABULATE_BUTTON = 16384;
    public static final int PLOT_BUTTON = 8192;
    public static final int COMPUTE_BUTTON = 4096;
    public static final int REMOVE_BUTTON = 2048;
    public static final int RENAME_BUTTON = 1024;
    public static final int NEW_BUTTON = 512;
    public static final int CLOSE_BUTTON = 256;
    public static final int PRINT_BUTTON = 128;
    public static final int DELETE_BUTTON = 64;
    public static final int OPEN_BUTTON = 32;
    public static final int SAVE_BUTTON = 16;
    public static final int OK_BUTTON = 8;
    public static final int CANCEL_BUTTON = 4;
    public static final int APPLY_BUTTON = 2;
    public static final int HELP_BUTTON = 1;
    public static final int OK_CANCEL_BUTTONS = 12;
    public static final int OK_APPLY_CANCEL_BUTTONS = 14;
    private boolean _applyAlwaysOn = false;
    private Hashtable m_buttonTable;
    JButton JBUTTON_NEW = null;
    JButton JBUTTON_RENAME = null;
    JButton JBUTTON_CLOSE = null;
    JButton JBUTTON_PRINT = null;
    JButton JBUTTON_OPEN = null;
    JButton JBUTTON_DELETE = null;
    JButton JBUTTON_SAVE = null;
    JButton JBUTTON_OK = null;
    JButton JBUTTON_CANCEL = null;
    JButton JBUTTON_APPLY = null;
    JButton JBUTTON_HELP = null;
    JButton JBUTTON_REMOVE = null;
    JButton JBUTTON_COMPUTE = null;
    JButton JBUTTON_TABULATE = null;
    JButton JBUTTON_PLOT = null;
    EventListenerList listenerList = new EventListenerList();

    public ButtonCmdPanel() {
        this(12);
    }

    public ButtonCmdPanel(int display_buttons) {
        this(display_buttons, new Insets(0, 5, 0, 0));
    }

    public ButtonCmdPanel(int display_buttons, Insets insets) {
        this.setLayout(new GridBagLayout());
        this.m_buttonTable = new Hashtable();
        int pos = 0;
        boolean xweight = true;
        if ((display_buttons & 0x2000) > 0) {
            this.JBUTTON_PLOT = new JButton("Plot");
            this.JBUTTON_PLOT.addActionListener(this);
            this.add((Component)this.JBUTTON_PLOT, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 23, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(8192), this.JBUTTON_PLOT);
        }
        if ((display_buttons & 0x4000) > 0) {
            this.JBUTTON_TABULATE = new JButton("Tabulate");
            this.JBUTTON_TABULATE.addActionListener(this);
            this.add((Component)this.JBUTTON_TABULATE, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 23, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(16384), this.JBUTTON_TABULATE);
        }
        if ((display_buttons & 0x1000) > 0) {
            this.JBUTTON_COMPUTE = new JButton("Compute");
            this.JBUTTON_COMPUTE.addActionListener(this);
            this.add((Component)this.JBUTTON_COMPUTE, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 23, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(4096), this.JBUTTON_COMPUTE);
        }
        if ((display_buttons & 0x800) > 0) {
            this.JBUTTON_REMOVE = new JButton("Remove");
            this.JBUTTON_REMOVE.addActionListener(this);
            this.add((Component)this.JBUTTON_REMOVE, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 23, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(2048), this.JBUTTON_REMOVE);
        }
        if ((display_buttons & 0x80) > 0) {
            this.JBUTTON_PRINT = new JButton("Print");
            this.JBUTTON_PRINT.addActionListener(this);
            this.add((Component)this.JBUTTON_PRINT, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 28, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(128), this.JBUTTON_PRINT);
        }
        if ((display_buttons & 0x400) > 0) {
            this.JBUTTON_RENAME = new JButton("Rename");
            this.JBUTTON_RENAME.addActionListener(this);
            this.add((Component)this.JBUTTON_RENAME, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 23, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(1024), this.JBUTTON_RENAME);
        }
        if ((display_buttons & 0x200) > 0) {
            this.JBUTTON_NEW = new JButton("New");
            this.JBUTTON_NEW.addActionListener(this);
            this.add((Component)this.JBUTTON_NEW, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 23, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(512), this.JBUTTON_NEW);
        }
        if ((display_buttons & 0x20) > 0) {
            this.JBUTTON_OPEN = new JButton("Open");
            this.JBUTTON_OPEN.setName("JBUTTON_OPEN");
            this.JBUTTON_OPEN.addActionListener(this);
            this.add((Component)this.JBUTTON_OPEN, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 23, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(32), this.JBUTTON_OPEN);
        }
        if ((display_buttons & 0x40) > 0) {
            this.JBUTTON_DELETE = new JButton("Delete");
            this.JBUTTON_DELETE.addActionListener(this);
            this.add((Component)this.JBUTTON_DELETE, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 17, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(64), this.JBUTTON_DELETE);
        }
        if ((display_buttons & 0x10) > 0) {
            this.JBUTTON_SAVE = new JButton("Save");
            this.JBUTTON_SAVE.addActionListener(this);
            this.add((Component)this.JBUTTON_SAVE, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 26, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(16), this.JBUTTON_SAVE);
        }
        if ((display_buttons & 8) > 0) {
            this.JBUTTON_OK = new JButton("OK");
            this.JBUTTON_OK.setName("JBUTTON_OK");
            this.JBUTTON_OK.addActionListener(this);
            this.add((Component)this.JBUTTON_OK, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 37, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(8), this.JBUTTON_OK);
        }
        if ((display_buttons & 4) > 0) {
            this.JBUTTON_CANCEL = new JButton("Cancel");
            this.JBUTTON_CANCEL.addActionListener(this);
            this.JBUTTON_CANCEL.setVerifyInputWhenFocusTarget(false);
            this.add((Component)this.JBUTTON_CANCEL, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 15, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(4), this.JBUTTON_CANCEL);
        }
        if ((display_buttons & 2) > 0) {
            this.JBUTTON_APPLY = new JButton("Apply");
            this.JBUTTON_APPLY.addActionListener(this);
            this.add((Component)this.JBUTTON_APPLY, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 25, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(2), this.JBUTTON_APPLY);
        }
        if ((display_buttons & 0x100) > 0) {
            this.JBUTTON_CLOSE = new JButton("Close");
            this.JBUTTON_CLOSE.addActionListener(this);
            this.add((Component)this.JBUTTON_CLOSE, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 20, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(256), this.JBUTTON_CLOSE);
        }
        if ((display_buttons & 1) > 0) {
            this.JBUTTON_HELP = new JButton("Help");
            this.JBUTTON_HELP.addActionListener(this);
            this.add((Component)this.JBUTTON_HELP, new RmaGridBagConstraints(pos, 0, 1, 1, (double)xweight, 0.0, 13, 0, insets, 26, 0));
            xweight = false;
            ++pos;
            this.m_buttonTable.put(new Integer(1), this.JBUTTON_HELP);
        }
    }

    public synchronized void addCmdPanelListener(ButtonCmdPanelListener l) {
        this.listenerList.add(ButtonCmdPanelListener.class, l);
    }

    public synchronized void removeCmdPanelListener(ButtonCmdPanelListener l) {
        this.listenerList.remove(ButtonCmdPanelListener.class, l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.JBUTTON_OK) {
            this.fireActionPerformed(e, this.JBUTTON_OK, 8);
        } else if (obj == this.JBUTTON_NEW) {
            this.fireActionPerformed(e, this.JBUTTON_NEW, 512);
        } else if (obj == this.JBUTTON_RENAME) {
            this.fireActionPerformed(e, this.JBUTTON_RENAME, 1024);
        } else if (obj == this.JBUTTON_CANCEL) {
            this.fireActionPerformed(e, this.JBUTTON_CANCEL, 4);
        } else if (obj == this.JBUTTON_APPLY) {
            this.fireActionPerformed(e, this.JBUTTON_APPLY, 2);
        } else if (obj == this.JBUTTON_HELP) {
            this.fireActionPerformed(e, this.JBUTTON_HELP, 1);
        } else if (obj == this.JBUTTON_OPEN) {
            this.fireActionPerformed(e, this.JBUTTON_OPEN, 32);
        } else if (obj == this.JBUTTON_DELETE) {
            this.fireActionPerformed(e, this.JBUTTON_DELETE, 64);
        } else if (obj == this.JBUTTON_SAVE) {
            this.fireActionPerformed(e, this.JBUTTON_SAVE, 16);
        } else if (obj == this.JBUTTON_PRINT) {
            this.fireActionPerformed(e, this.JBUTTON_PRINT, 128);
        } else if (obj == this.JBUTTON_CLOSE) {
            this.fireActionPerformed(e, this.JBUTTON_CLOSE, 256);
        } else if (obj == this.JBUTTON_REMOVE) {
            this.fireActionPerformed(e, this.JBUTTON_REMOVE, 2048);
        } else if (obj == this.JBUTTON_COMPUTE) {
            this.fireActionPerformed(e, this.JBUTTON_COMPUTE, 4096);
        } else if (obj == this.JBUTTON_TABULATE) {
            this.fireActionPerformed(e, this.JBUTTON_TABULATE, 16384);
        } else if (obj == this.JBUTTON_PLOT) {
            this.fireActionPerformed(e, this.JBUTTON_PLOT, 8192);
        }
    }

    protected void fireActionPerformed(ActionEvent event, JButton button, int buttonType) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ButtonCmdPanelListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = "";
                }
                e = new ActionEvent(this, buttonType, event.getActionCommand(), event.getModifiers());
            }
            ((ButtonCmdPanelListener)listeners[i + 1]).buttonCmdActionPerformed(e);
        }
    }

    public JButton getButton(int buttonId) {
        return (JButton)this.m_buttonTable.get(new Integer(buttonId));
    }

    public JButton getButton(String buttonText) {
        if (buttonText == null) {
            return null;
        }
        Component[] buttons = this.getComponents();
        JButton button = null;
        for (int i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton) || !buttonText.equalsIgnoreCase((button = (JButton)buttons[i]).getText())) continue;
            return button;
        }
        return button;
    }

    public void setApplyAlwaysOn(boolean on) {
        this._applyAlwaysOn = on;
    }

    public void setApplyEnabled(boolean enabled) {
        if (!this._applyAlwaysOn && this.JBUTTON_APPLY != null) {
            this.JBUTTON_APPLY.setEnabled(enabled);
        }
    }

    public void setButtonEnable(int buttonID, boolean enabled) {
        JButton button = (JButton)this.m_buttonTable.get(new Integer(buttonID));
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public void setButtonVisible(int buttonID, boolean visible) {
        JButton button = (JButton)this.m_buttonTable.get(new Integer(buttonID));
        if (button != null) {
            button.setVisible(visible);
        }
    }

    public void doButtonClick(int buttonID) {
        JButton button = (JButton)this.m_buttonTable.get(new Integer(buttonID));
        if (button != null) {
            button.doClick();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ButtonCmdPanel a = new ButtonCmdPanel(1);
        ButtonCmdPanel b = new ButtonCmdPanel(2);
        ButtonCmdPanel c2 = new ButtonCmdPanel(3);
        ButtonCmdPanel d = new ButtonCmdPanel(4);
        ButtonCmdPanel e = new ButtonCmdPanel(5);
        ButtonCmdPanel f = new ButtonCmdPanel(6);
        ButtonCmdPanel g = new ButtonCmdPanel(7);
        ButtonCmdPanel h = new ButtonCmdPanel(8);
        ButtonCmdPanel i = new ButtonCmdPanel(9);
        ButtonCmdPanel j = new ButtonCmdPanel(10);
        ButtonCmdPanel k = new ButtonCmdPanel(11);
        ButtonCmdPanel l = new ButtonCmdPanel(12);
        ButtonCmdPanel m = new ButtonCmdPanel(13);
        ButtonCmdPanel n = new ButtonCmdPanel(14);
        ButtonCmdPanel o = new ButtonCmdPanel(15);
        ButtonCmdPanel p = new ButtonCmdPanel(128);
        ButtonCmdPanel q = new ButtonCmdPanel(2);
        ButtonCmdPanel r = new ButtonCmdPanel(1);
        ButtonCmdPanel s = new ButtonCmdPanel(4);
        ButtonCmdPanel t = new ButtonCmdPanel(8);
        ButtonCmdPanel u = new ButtonCmdPanel(64);
        ButtonCmdPanel v = new ButtonCmdPanel(16);
        ButtonCmdPanel w = new ButtonCmdPanel(256);
        JFrame testFrame = new JFrame();
        testFrame.getContentPane().setLayout(new GridBagLayout());
        testFrame.getContentPane().add((Component)p, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        testFrame.getContentPane().add((Component)q, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        testFrame.getContentPane().add((Component)r, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        testFrame.getContentPane().add((Component)s, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        testFrame.getContentPane().add((Component)t, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        testFrame.getContentPane().add((Component)u, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        testFrame.getContentPane().add((Component)v, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        testFrame.getContentPane().add((Component)w, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        testFrame.pack();
        testFrame.setLocation(50, 50);
        testFrame.setVisible(true);
    }

    @Override
    public void setIsEditable(boolean b) {
        if (this.JBUTTON_OPEN != null) {
            this.JBUTTON_OPEN.setEnabled(b);
        }
        if (this.JBUTTON_DELETE != null) {
            this.JBUTTON_DELETE.setEnabled(b);
        }
        if (this.JBUTTON_SAVE != null) {
            this.JBUTTON_SAVE.setEnabled(b);
        }
        if (this.JBUTTON_OK != null) {
            this.JBUTTON_OK.setEnabled(b);
        }
        if (this.JBUTTON_APPLY != null && (!b || b && this._applyAlwaysOn)) {
            this.JBUTTON_APPLY.setEnabled(b);
        }
        if (this.JBUTTON_PRINT != null) {
            this.JBUTTON_PRINT.setEnabled(b);
        }
        if (this.JBUTTON_CLOSE != null) {
            this.JBUTTON_CLOSE.setEnabled(b);
        }
        if (this.JBUTTON_REMOVE != null) {
            this.JBUTTON_REMOVE.setEnabled(b);
        }
    }
}

