/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.UIManager;
import rma.swing.RmaInsets;

public class CheckBoxPanel
extends JPanel {
    private JCheckBox _checkBox;
    private JLabel _label;
    private Object _obj;

    public CheckBoxPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    public CheckBoxPanel(String label) {
        this();
        this.setText(label);
    }

    public CheckBoxPanel(Object obj, boolean selected) {
        this();
        this.setObject(obj);
        this.setSelected(selected);
    }

    public CheckBoxPanel(String label, boolean selected) {
        this(label);
        this.setSelected(selected);
    }

    public CheckBoxPanel(String label, Icon icon) {
        this(label);
        this.setIcon(icon);
    }

    public CheckBoxPanel(String label, Icon icon, boolean selected) {
        this(label, selected);
        this.setIcon(icon);
    }

    private void buildControls() {
        this._checkBox = new JCheckBox();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0000;
        this.add((Component)this._checkBox, gbc);
        this._label = new JLabel();
        this._label.setFont(UIManager.getFont("MenuItem.font"));
        this._label.setOpaque(true);
        this._label.setRequestFocusEnabled(true);
        this._label.setFocusable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.01;
        gbc.weighty = 0.01;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add((Component)this._label, gbc);
    }

    private void addListeners() {
        this._label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckBoxPanel.this._checkBox.doClick(0);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Container parent = CheckBoxPanel.this.getParent();
                if (parent instanceof JMenu) {
                    JMenu menu = (JMenu)parent;
                    Color bg = menu.getBackground();
                    CheckBoxPanel.this.setBackground(bg);
                    CheckBoxPanel.this._label.setBackground(bg);
                    CheckBoxPanel.this._checkBox.setBackground(bg);
                } else {
                    CheckBoxPanel.this.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                    CheckBoxPanel.this._label.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                    CheckBoxPanel.this._checkBox.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CheckBoxPanel.this.setBackground(UIManager.getColor("MenuItem.background"));
                CheckBoxPanel.this._label.setBackground(UIManager.getColor("MenuItem.background"));
                CheckBoxPanel.this._checkBox.setBackground(UIManager.getColor("MenuItem.background"));
            }
        });
        this._checkBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CheckBoxPanel.this.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                CheckBoxPanel.this._label.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                CheckBoxPanel.this._checkBox.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CheckBoxPanel.this.setBackground(UIManager.getColor("MenuItem.background"));
                CheckBoxPanel.this._label.setBackground(UIManager.getColor("MenuItem.background"));
                CheckBoxPanel.this._checkBox.setBackground(UIManager.getColor("MenuItem.background"));
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckBoxPanel.this._checkBox.doClick(0);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CheckBoxPanel.this.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                CheckBoxPanel.this._label.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
                CheckBoxPanel.this._checkBox.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CheckBoxPanel.this.setBackground(UIManager.getColor("MenuItem.background"));
                CheckBoxPanel.this._label.setBackground(UIManager.getColor("MenuItem.background"));
                CheckBoxPanel.this._checkBox.setBackground(UIManager.getColor("MenuItem.background"));
            }
        });
    }

    public void addActionListener(ActionListener al) {
        this._checkBox.addActionListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this._checkBox.removeActionListener(al);
    }

    public void setObject(Object obj) {
        this._obj = obj;
        if (this._obj != null) {
            this.setText(this._obj.toString());
        }
    }

    public Object getObject() {
        return this._obj;
    }

    public void setSelected(boolean selected) {
        this._checkBox.setSelected(selected);
    }

    public boolean isSelected() {
        return this._checkBox.isSelected();
    }

    public void doClick() {
        this._checkBox.doClick();
    }

    public void doClick(int pressTime) {
        this._checkBox.doClick(pressTime);
    }

    public void setText(String label) {
        this._label.setText(label);
    }

    public String getText() {
        return this._label.getText();
    }

    public void setIcon(Icon icon) {
        this._label.setIcon(icon);
    }

    public Icon getIcon() {
        return this._label.getIcon();
    }
}

