/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;

public class CollapsableJPanel
extends JPanel {
    private boolean _collapsed = true;
    private JPanel _contentPanel;
    private HeaderPanel _headerPanel;

    public CollapsableJPanel(String text, JPanel panel) {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 3, 0, 3);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        this._collapsed = false;
        this._headerPanel = new HeaderPanel(text);
        this._contentPanel = panel;
        this.add((Component)this._headerPanel, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this._contentPanel, gbc);
    }

    public CollapsableJPanel(JPanel panel) {
        super(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 3, 0, 3);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        this._collapsed = false;
        this._headerPanel = new HeaderPanel();
        this._contentPanel = panel;
        this.add((Component)this._headerPanel, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this._contentPanel, gbc);
    }

    public boolean isCollapsed() {
        return this._collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        if (this._collapsed != collapsed) {
            this.toggleCollapsed();
        }
    }

    public void toggleCollapsed() {
        boolean oldCollapsed = this._collapsed;
        boolean bl = this._collapsed = !this._collapsed;
        if (this._contentPanel.isVisible()) {
            this._contentPanel.setVisible(false);
            this._headerPanel._button.setSelected(true);
        } else {
            this._contentPanel.setVisible(true);
            this._headerPanel._button.setSelected(false);
        }
        this.firePropertyChange("Collapsed", oldCollapsed, this._collapsed);
        this.validate();
        this._headerPanel.repaint();
    }

    public void setHeaderText(String text) {
        this._headerPanel.setText(text);
        this._headerPanel.revalidate();
        this.revalidate();
    }

    private class HeaderPanel
    extends JPanel {
        JLabel _label;
        private JToggleButton _button;

        public HeaderPanel(String text) {
            super(new GridBagLayout());
            this._label = new JLabel(text);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = -1;
            gbc.gridy = -1;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 5, 5, 0);
            this.add((Component)this._label, gbc);
            ImageIcon upImg = RmaImage.getImageIcon("Images/moveToTop.gif");
            ImageIcon downImg = RmaImage.getImageIcon("Images/moveToBottom.gif");
            this._button = new JToggleButton(upImg);
            this._button.setSelectedIcon(downImg);
            this._button.setBorder(null);
            gbc.gridx = -1;
            gbc.gridy = -1;
            gbc.gridwidth = 0;
            gbc.weightx = 0.001;
            gbc.weighty = 0.0;
            gbc.anchor = 12;
            gbc.fill = 0;
            gbc.insets = RmaInsets.INSETS5555;
            this.add((Component)this._button, gbc);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollapsableJPanel.this.toggleCollapsed();
                }
            });
        }

        public HeaderPanel() {
            super(new GridBagLayout());
            ImageIcon upImg = RmaImage.getImageIcon("Images/moveToTop.gif");
            ImageIcon downImg = RmaImage.getImageIcon("Images/moveToBottom.gif");
            this._button = new JToggleButton(upImg);
            this._button.setSelectedIcon(downImg);
            this._button.setBorder(null);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = -1;
            gbc.gridy = -1;
            gbc.gridwidth = 0;
            gbc.weightx = 0.001;
            gbc.weighty = 0.0;
            gbc.anchor = 12;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 5, 5, 0);
            this.add((Component)this._button, gbc);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollapsableJPanel.this.toggleCollapsed();
                }
            });
        }

        public void setText(String text) {
            this._label.setText(text);
        }
    }
}

