/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Color _color;
    private int _w;
    private int _h;

    public ColorIcon() {
        this(Color.gray, 50, 15);
    }

    public ColorIcon(Color color) {
        this(color, 15, 15);
    }

    public ColorIcon(Color color, int w, int h) {
        this._color = color;
        this._w = w;
        this._h = h;
    }

    @Override
    public void paintIcon(Component c2, Graphics g, int x, int y) {
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        g.drawRect(x, y, this._w - 1, this._h - 1);
        if (this._color != null) {
            g.setColor(this._color);
        } else {
            g.setColor(Color.white);
        }
        g.fillRect(x + 1, y + 1, this._w - 2, this._h - 2);
        g.setColor(oldColor);
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    @Override
    public int getIconWidth() {
        return this._w;
    }

    public void setIconWidth(int width) {
        this._w = width;
    }

    @Override
    public int getIconHeight() {
        return this._h;
    }
}

