/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColorProducer {
    private final List<Color> _colors = new ArrayList<Color>();
    private int _index = 0;

    public ColorProducer() {
        this._colors.add(Color.BLUE);
        this._colors.add(Color.RED);
        this._colors.add(Color.GREEN.darker());
        this._colors.add(Color.DARK_GRAY);
        this._colors.add(Color.MAGENTA);
        this._colors.add(Color.ORANGE);
        this._colors.add(Color.BLACK);
    }

    public ColorProducer(Collection<Color> colors) {
        this._colors.addAll(colors);
    }

    public Color peek() {
        return this._colors.get(this._index);
    }

    public Color next() {
        Color retColor = this._colors.get(this._index++);
        if (this._index >= this._colors.size()) {
            this._index = 0;
        }
        return retColor;
    }

    public void restart() {
        this._index = 0;
    }

    public void restart(int index) {
        this._index = index % this._colors.size();
    }

    public void restart(Collection<Color> colors) {
        this._colors.clear();
        this._colors.addAll(colors);
        this._index = 0;
    }

    public void introduce(Color color) {
        this._colors.add(color);
    }

    public void introduce(Color color, int index) {
        this._colors.add(index, color);
    }
}

