/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class CustomBevelBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected int bevelWidth;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;

    public CustomBevelBorder(int bevelType, int bevelWidth) {
        this.bevelWidth = bevelWidth;
        this.bevelType = bevelType;
    }

    public CustomBevelBorder(int bevelType) {
        this(bevelType, 2);
    }

    public CustomBevelBorder(int bevelType, int bevelWidth, Color highlight, Color shadow) {
        this(bevelType, bevelWidth, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public CustomBevelBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType, 2, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public CustomBevelBorder(int bevelType, int bevelWidth, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        this(bevelType, bevelWidth);
        this.highlightOuter = highlightOuterColor;
        this.highlightInner = highlightInnerColor;
        this.shadowOuter = shadowOuterColor;
        this.shadowInner = shadowInnerColor;
    }

    public CustomBevelBorder(int bevelType, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        this(bevelType, 2, highlightOuterColor, highlightInnerColor, shadowOuterColor, shadowInnerColor);
    }

    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        this.paintBevel(this.bevelType, c2, g, x, y, width, height);
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return new Insets(this.bevelWidth, this.bevelWidth, this.bevelWidth, this.bevelWidth);
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        insets.right = insets.bottom = this.bevelWidth;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getHighlightOuterColor(Component c2) {
        Color highlight = this.getHighlightOuterColor();
        return highlight != null ? highlight : c2.getBackground().brighter().brighter();
    }

    public Color getHighlightInnerColor(Component c2) {
        Color highlight = this.getHighlightInnerColor();
        return highlight != null ? highlight : c2.getBackground().brighter();
    }

    public Color getShadowInnerColor(Component c2) {
        Color shadow = this.getShadowInnerColor();
        return shadow != null ? shadow : c2.getBackground().darker();
    }

    public Color getShadowOuterColor(Component c2) {
        Color shadow = this.getShadowOuterColor();
        return shadow != null ? shadow : c2.getBackground().darker().darker();
    }

    public Color getHighlightOuterColor() {
        return this.highlightOuter;
    }

    public Color getHighlightInnerColor() {
        return this.highlightInner;
    }

    public Color getShadowInnerColor() {
        return this.shadowInner;
    }

    public Color getShadowOuterColor() {
        return this.shadowOuter;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public int getBevelWidth() {
        return this.bevelWidth;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintBevel(int bevelType, Component c2, Graphics g, int x, int y, int width, int height) {
        int i;
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(bevelType == 0 ? this.getHighlightOuterColor(c2) : this.getShadowInnerColor(c2));
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        if (this.bevelWidth > 1) {
            for (i = 1; i < this.bevelWidth - 1; ++i) {
                g.drawLine(i, i, i, h - i);
                g.drawLine(i + 1, i, w - i, i);
            }
            g.setColor(bevelType == 0 ? this.getHighlightInnerColor(c2) : this.getShadowOuterColor(c2));
            g.drawLine(this.bevelWidth - 1, this.bevelWidth - 1, this.bevelWidth - 1, h - this.bevelWidth);
            g.drawLine(this.bevelWidth - 1, this.bevelWidth - 1, w - this.bevelWidth, this.bevelWidth - 1);
        }
        g.setColor(bevelType == 0 ? this.getShadowOuterColor(c2) : this.getHighlightOuterColor(c2));
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        if (this.bevelWidth > 1) {
            for (i = 1; i < this.bevelWidth - 1; ++i) {
                g.drawLine(w - 1 - i, i + 1, w - 1 - i, h - 1 - i);
                g.drawLine(i + 1, h - 1 - i, w - 2 - i, h - 1 - i);
            }
            g.setColor(bevelType == 0 ? this.getShadowInnerColor(c2) : this.getHighlightInnerColor(c2));
            g.drawLine(this.bevelWidth, h - this.bevelWidth, w - this.bevelWidth, h - this.bevelWidth);
            g.drawLine(w - this.bevelWidth, this.bevelWidth, w - this.bevelWidth, h - this.bevelWidth);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

