/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextField;

public class DateChooser
extends JPanel
implements ActionListener {
    private static final int cellSize = 25;
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] daysInMonthLeap = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final Color weekendColor = Color.red.darker();
    private static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private RmaJTextField _selectedDateLbl;
    private RmaJIntegerField _yearFld;
    private RmaJComboBox<String> _monthCombo;
    private JButton _lyearBtn;
    private JButton _ryearBtn;
    private JButton _lmonthBtn;
    private JButton _rmonthBtn;
    private CalendarPane _calPanel;
    private SimpleDateFormat _datefmt = new SimpleDateFormat("E  d MMM yyyy");
    private Calendar _selectedDate = null;
    private Calendar _minDate = null;
    private Calendar _maxDate = null;
    private int _selectedDay;
    private int _firstDay;
    private int _minDay = -1;
    private int _maxDay = -1;
    private String[] _labels = new String[7];
    private Color _highlightColor;
    private Color _disabledColor;
    private boolean _clipMin = false;
    private boolean _clipMax = false;
    private int[] _weekendCols = new int[]{0, 0};
    private ActionSupport _asupport;

    public DateChooser() {
        this(Calendar.getInstance());
    }

    public DateChooser(Calendar date) {
        if (date == null) {
            date = Calendar.getInstance();
        }
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        this._asupport = new ActionSupport(this);
        String[] wkd = new String[]{"", "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
        for (int i = 0; i < 7; ++i) {
            int l = Math.min(wkd[i + 1].length(), 2);
            this._labels[i] = wkd[i + 1].substring(0, l);
        }
        this._highlightColor = UIManager.getColor("List.selectionBackground");
        this.setLayout(new BorderLayout(5, 5));
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout(0, 0));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        top.add("West", p1);
        this._lmonthBtn = new JButton(RmaImage.getImageIcon("Images/backbutton.gif"));
        this._lmonthBtn.setMargin(emptyInsets);
        this._lmonthBtn.setFocusPainted(false);
        this._lmonthBtn.setOpaque(false);
        this._lmonthBtn.addActionListener(this);
        int height = this._lmonthBtn.getHeight();
        p1.add(this._lmonthBtn);
        this._monthCombo = new RmaJComboBox<String>(months);
        this._monthCombo.addActionListener(this);
        Dimension dim = this._monthCombo.getSize();
        dim.height = height;
        this._monthCombo.setSize(dim);
        p1.add(this._monthCombo);
        this._rmonthBtn = new JButton(RmaImage.getImageIcon("Images/forwardbutton.gif"));
        this._rmonthBtn.setMargin(emptyInsets);
        this._rmonthBtn.setFocusPainted(false);
        this._rmonthBtn.setOpaque(false);
        this._rmonthBtn.addActionListener(this);
        p1.add(this._rmonthBtn);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        top.add("East", p2);
        this._lyearBtn = new JButton(RmaImage.getImageIcon("Images/backbutton.gif"));
        this._lyearBtn.setMargin(emptyInsets);
        this._lyearBtn.setFocusPainted(false);
        this._lyearBtn.setOpaque(false);
        this._lyearBtn.addActionListener(this);
        p2.add(this._lyearBtn);
        this._yearFld = new RmaJIntegerField();
        this._yearFld.setEmptyOk(false);
        dim = this._yearFld.getSize();
        dim.height = height;
        this._yearFld.setSize(dim);
        p2.add(this._yearFld);
        this._ryearBtn = new JButton(RmaImage.getImageIcon("Images/forwardbutton.gif"));
        this._ryearBtn.setMargin(emptyInsets);
        this._ryearBtn.setFocusPainted(false);
        this._ryearBtn.setOpaque(false);
        this._ryearBtn.addActionListener(this);
        p2.add(this._ryearBtn);
        this.add("North", top);
        this._calPanel = new CalendarPane();
        this._calPanel.setOpaque(false);
        this.add("Center", this._calPanel);
        JPanel datePanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("Selected:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(0, 10, 0, 5);
        datePanel.add((Component)label, gbc);
        this._selectedDateLbl = new RmaJTextField("Date", 0);
        this._selectedDateLbl.setToolTipText("Selected Date");
        this._selectedDateLbl.setEditable(false);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.001;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(0, 0, 0, 10);
        datePanel.add((Component)this._selectedDateLbl, gbc);
        this.add("South", datePanel);
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), 1, f.getSize()));
        int fd = date.getFirstDayOfWeek();
        this._weekendCols[0] = (1 - fd + 7) % 7;
        this._weekendCols[1] = (7 - fd + 7) % 7;
        this.setSelectedDate(date);
        this._yearFld.addActionListener(e -> this.yearChanged());
        this._yearFld.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                DateChooser.this.yearChanged();
            }
        });
        JPopupMenu popup = new JPopupMenu();
        JMenuItem setTodayMenu = new JMenuItem("Set to Today");
        setTodayMenu.addActionListener(e -> this.setToCurrentDate());
        popup.add(setTodayMenu);
        this.setComponentPopupMenu(popup);
        this._calPanel.setComponentPopupMenu(popup);
    }

    private void setToCurrentDate() {
        Calendar date = Calendar.getInstance();
        this.setSelectedDate(date);
    }

    private void yearChanged() {
        this._selectedDate.set(1, this._yearFld.getValue());
        this._selectedDay = 1;
        this._selectedDate.set(5, this._selectedDay);
        this.refresh();
    }

    public Calendar getSelectedDate() {
        return (Calendar)this._selectedDate.clone();
    }

    public void setSelectedDate(Calendar date) {
        this._selectedDate = this.copyDate(date, this._selectedDate);
        this._selectedDay = this._selectedDate.get(5);
        this.refresh();
    }

    public void setMinimumDate(Calendar date) {
        this._minDate = date == null ? null : this.copyDate(date, this._minDate);
        this._minDay = date == null ? -1 : this._minDate.get(5);
        this._yearFld.setMinValue(this._minDate.get(1));
        this.refresh();
    }

    public Calendar getMinimumDate() {
        return this._minDate;
    }

    public void setMaximumDate(Calendar date) {
        this._maxDate = date == null ? null : this.copyDate(date, this._maxDate);
        this._maxDay = date == null ? -1 : this._maxDate.get(5);
        this._yearFld.setMaxValue(this._maxDate.get(1));
        this.refresh();
    }

    public Calendar getMaximumDate() {
        return this._maxDate;
    }

    public void setDateFormat(SimpleDateFormat format) {
        this._datefmt = format;
        this.refresh();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int lastDay;
        int m;
        Object o = evt.getSource();
        if (o == this._lmonthBtn) {
            this._selectedDate.add(2, -1);
        } else if (o == this._rmonthBtn) {
            this._selectedDate.add(2, 1);
        } else if (o == this._lyearBtn) {
            this._selectedDate.add(1, -1);
            if (this._minDate != null) {
                m = this._minDate.get(2);
                if (this._selectedDate.get(2) < m) {
                    this._selectedDate.set(2, m);
                }
            }
        } else if (o == this._ryearBtn) {
            this._selectedDate.add(1, 1);
            if (this._minDate != null) {
                m = this._maxDate.get(2);
                if (this._selectedDate.get(2) > m) {
                    this._selectedDate.set(2, m);
                }
            }
        } else if (o == this._monthCombo) {
            this._selectedDate.set(5, 1);
            this._selectedDate.set(2, this._monthCombo.getSelectedIndex());
        }
        if (this._selectedDay < 0) {
            this._selectedDay = 1;
        }
        if (this._selectedDay > (lastDay = daysInMonth[this._monthCombo.getSelectedIndex()])) {
            this._selectedDay = lastDay;
        }
        this._selectedDate.set(5, this._selectedDay);
        this.refresh();
        this._asupport.fireActionEvent();
    }

    private void computeFirstDay() {
        int d = this._selectedDate.get(5);
        this._selectedDate.set(5, 1);
        this._firstDay = this._selectedDate.get(7);
        this._selectedDate.set(5, d);
    }

    private void refresh() {
        int m;
        int y;
        this._selectedDateLbl.setText(this._datefmt.format(this._selectedDate.getTime()));
        this._yearFld.setText(String.valueOf(this._selectedDate.get(1)));
        this._monthCombo.setSelectedItem(months[this._selectedDate.get(2)]);
        this.computeFirstDay();
        this._clipMax = false;
        this._clipMin = false;
        this._lyearBtn.setEnabled(true);
        this._ryearBtn.setEnabled(true);
        this._lmonthBtn.setEnabled(true);
        this._rmonthBtn.setEnabled(true);
        if (this._minDate != null) {
            y = this._selectedDate.get(1);
            int y0 = this._minDate.get(1);
            m = this._selectedDate.get(2);
            int m0 = this._minDate.get(2);
            this._lyearBtn.setEnabled(y > y0);
            if (y == y0) {
                this._lmonthBtn.setEnabled(m > m0);
                if (m == m0) {
                    this._clipMin = true;
                    int d0 = this._minDate.get(5);
                    this._selectedDate.set(5, this._selectedDay);
                }
            }
        }
        if (this._maxDate != null) {
            y = this._selectedDate.get(1);
            int y1 = this._maxDate.get(1);
            m = this._selectedDate.get(2);
            int m1 = this._maxDate.get(2);
            this._ryearBtn.setEnabled(y < y1);
            if (y == y1) {
                this._rmonthBtn.setEnabled(m < m1);
                if (m == m1) {
                    this._clipMax = true;
                    int d1 = this._maxDate.get(5);
                    this._selectedDate.set(5, this._selectedDay);
                }
            }
        }
        this._calPanel.repaint();
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private Calendar copyDate(Calendar source, Calendar dest) {
        if (dest == null) {
            dest = Calendar.getInstance(source.getTimeZone());
        }
        dest.set(1, source.get(1));
        dest.set(2, source.get(2));
        dest.set(5, source.get(5));
        return dest;
    }

    public void addActionListener(ActionListener listener) {
        this._asupport.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this._asupport.removeActionListener(listener);
    }

    public void setHighlightColor(Color color) {
        this._highlightColor = color;
    }

    public Color getHighlightColor() {
        return this._highlightColor;
    }

    public class ActionSupport {
        private EventListenerList listeners;
        private Object source;

        public ActionSupport(Object source) {
            this.source = source;
            this.listeners = new EventListenerList();
        }

        public void addActionListener(ActionListener listener) {
            this.listeners.add(ActionListener.class, listener);
        }

        public void removeActionListener(ActionListener listener) {
            this.listeners.remove(ActionListener.class, listener);
        }

        public void fireActionEvent() {
            this.fireActionEvent(1001, null, 0);
        }

        public void fireActionEvent(String command) {
            this.fireActionEvent(1001, command, 0);
        }

        public void fireActionEvent(int id, String command) {
            this.fireActionEvent(id, command, 0);
        }

        public void fireActionEvent(int id, String command, int modifiers) {
            ActionEvent evt = null;
            Object[] list = this.listeners.getListenerList();
            for (int i = list.length - 2; i >= 0; i -= 2) {
                if (list[i] != ActionListener.class) continue;
                if (evt == null) {
                    evt = new ActionEvent(this.source, id, command, modifiers);
                }
                ((ActionListener)list[i + 1]).actionPerformed(evt);
            }
        }
    }

    private class CalendarPane
    extends JComponent {
        private int ww = 0;
        private int hh = 0;
        private int dp = 0;

        CalendarPane() {
            this.addMouseListener(new MouseListener2());
        }

        @Override
        public void paint(Graphics gc) {
            int x0;
            int y0;
            FontMetrics fm = gc.getFontMetrics();
            Insets ins = this.getInsets();
            int h = fm.getMaxAscent();
            int x = this.dp = (DateChooser.this._firstDay - DateChooser.this._selectedDate.getFirstDayOfWeek() + 7) % 7;
            int y = 0;
            int yp = y0 = (this.getSize().height - this.getPreferredSize().height) / 2;
            int xp = x0 = (this.getSize().width - this.getPreferredSize().width) / 2;
            this.paintBorder(gc);
            gc.clipRect(ins.left, ins.top, this.getSize().width - ins.left - ins.right, this.getSize().height - ins.top - ins.bottom);
            gc.translate(ins.left, ins.top);
            int ii = DateChooser.this._selectedDate.getFirstDayOfWeek() - 1;
            for (int i = 0; i < 7; ++i) {
                gc.drawString(DateChooser.this._labels[ii], xp + 5 + i * 27, yp + h);
                if (++ii != 7) continue;
                ii = 0;
            }
            yp += 20;
            xp += this.dp * 27;
            int month = DateChooser.this._selectedDate.get(2);
            int dmax = DateChooser.isLeapYear(DateChooser.this._selectedDate.get(1)) ? daysInMonthLeap[month] : daysInMonth[month];
            for (int d = 1; d <= dmax; ++d) {
                gc.draw3DRect(xp, yp, 25, 25, true);
                if (d == DateChooser.this._selectedDay) {
                    gc.setColor(DateChooser.this._highlightColor);
                    gc.fillRect(xp + 1, yp + 1, 23, 23);
                }
                if (DateChooser.this._clipMin && d < DateChooser.this._minDay || DateChooser.this._clipMax && d > DateChooser.this._maxDay) {
                    gc.setColor(DateChooser.this._disabledColor);
                } else {
                    gc.setColor(DateChooser.this._weekendCols[0] == x || DateChooser.this._weekendCols[1] == x ? weekendColor : Color.black);
                }
                String ss = String.valueOf(d);
                int sw = fm.stringWidth(ss);
                gc.drawString(ss, xp - 3 + (25 - sw), yp + 3 + h);
                gc.setColor(Color.black);
                if (++x == 7) {
                    x = 0;
                    xp = x0;
                    ++y;
                    yp += 27;
                    continue;
                }
                xp += 27;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(189 + ins.left + ins.right, 182 + ins.top + ins.bottom);
        }

        private int getDay(MouseEvent evt) {
            Insets ins = this.getInsets();
            int x = evt.getX() - ins.left;
            int y = evt.getY() - ins.top - 20;
            int maxw = 189;
            int maxh = 162;
            if (x < 0 || x > maxw || y < 0 || y > maxh) {
                return -1;
            }
            int d = 7 * (y /= 27) + (x /= 27) - (this.dp - 1);
            if (d < 1 || d > DateChooser.this._selectedDate.getMaximum(5)) {
                return -1;
            }
            if (DateChooser.this._clipMin && d < DateChooser.this._minDay || DateChooser.this._clipMax && d > DateChooser.this._maxDay) {
                return -1;
            }
            return d;
        }

        private class MouseListener2
        extends MouseAdapter {
            private MouseListener2() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (SwingUtilities.isLeftMouseButton(evt)) {
                    int d = CalendarPane.this.getDay(evt);
                    if (d < 0) {
                        return;
                    }
                    DateChooser.this._selectedDay = d;
                    DateChooser.this._selectedDate.set(5, DateChooser.this._selectedDay);
                    DateChooser.this.refresh();
                    DateChooser.this._asupport.fireActionEvent();
                }
            }
        }
    }
}

