/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;

public class DateTimeGroup {
    private RmaJCalendarField m_dateField;
    private RmaJ24HourTimeField m_timeField;
    private HecTime m_hTime = null;
    private SimpleDateFormat m_dateFormat = null;
    private SimpleDateFormat m_timeFormat = null;
    private static final int MILLISEC2MIN = 60000;
    private static final TimeZone NULL_TIMEZONE = new SimpleTimeZone(0, "Null Timezone");
    private TimeZone m_displayTimeZone = NULL_TIMEZONE;
    private TimeZone m_dataTimeZone = null;

    public DateTimeGroup(RmaJCalendarField dateField, RmaJ24HourTimeField timeField) {
        this.m_dateField = dateField;
        this.m_timeField = timeField;
        String dateFmt = dateField.getFormat();
        dateFmt = dateFmt.replace('D', 'd').replace('Y', 'y');
        this.m_dateFormat = new SimpleDateFormat(dateFmt);
        this.m_timeFormat = new SimpleDateFormat("HHmm");
        this.m_dateFormat.setTimeZone(this.m_displayTimeZone);
        this.m_timeFormat.setTimeZone(this.m_displayTimeZone);
    }

    public void setDateTime(HecTimeArray hTimeArray) {
        if (hTimeArray == null || hTimeArray.numberElements() < 1) {
            return;
        }
        this.m_hTime = new HecTime(hTimeArray.element(0));
        this.m_dataTimeZone = hTimeArray.getTimeZone();
        if (this.m_dataTimeZone == null) {
            this.m_displayTimeZone = NULL_TIMEZONE;
        }
        this.m_dateFormat.setTimeZone(this.m_displayTimeZone);
        this.m_timeFormat.setTimeZone(this.m_displayTimeZone);
        this.fillDateTimeFields();
    }

    public void setDateTime(HecTime hTime, TimeZone tz) {
        if (hTime == null || tz == null) {
            return;
        }
        this.m_hTime = new HecTime(hTime);
        this.m_dataTimeZone = tz;
        if (this.m_dataTimeZone == null) {
            this.m_displayTimeZone = NULL_TIMEZONE;
        }
        this.fillDateTimeFields();
    }

    public void setDateTime(HecTime hTime, int offsetFromGmt) {
        this.m_hTime = new HecTime(hTime);
        this.m_dataTimeZone = new SimpleTimeZone(offsetFromGmt * 60 * 60 * 1000, "DataTimeZone");
        this.fillDateTimeFields();
    }

    public void fillDateTimeFields() {
        if (this.m_hTime == null) {
            return;
        }
        this.fillDateTimeFields(this.m_hTime);
    }

    void fillDateTimeFields(HecTime dateTime) {
        int off = 0;
        if (this.m_dataTimeZone != null) {
            off = this.m_dataTimeZone.getRawOffset() / 60000;
        }
        Date date = dateTime.getJavaDate(off);
        this.m_dateField.setText(this.m_dateFormat.format(date));
        this.m_timeField.setText(this.m_timeFormat.format(date));
    }

    public HecTimeArray getDateTime() {
        HecTime hTime = new HecTime(this.m_dateField.getText(), this.m_timeField.getText());
        String date = hTime.date(104);
        String time = hTime.hourMinutes();
        SimpleDateFormat sdf = new SimpleDateFormat(this.m_dateFormat.toPattern() + " " + this.m_timeFormat.toPattern());
        Date jDate = null;
        try {
            sdf.setTimeZone(this.m_displayTimeZone);
            jDate = sdf.parse(date + " " + time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int off = 0;
        if (this.m_dataTimeZone != null) {
            off = this.m_dataTimeZone.getRawOffset() / 60000;
        }
        hTime = new HecTime(jDate, off);
        HecTimeArray htimeArray = new HecTimeArray(1);
        htimeArray.setElementAt(hTime, 0);
        htimeArray.setTimeZone(this.m_dataTimeZone);
        return htimeArray;
    }

    public void setDisplayTimeZone(TimeZone tz) {
        if (tz.equals(this.m_displayTimeZone)) {
            return;
        }
        if (this.m_dataTimeZone == null) {
            this.m_displayTimeZone = NULL_TIMEZONE;
            return;
        }
        if (!this.m_dateField.isModified() && !this.m_timeField.isModified()) {
            this.m_displayTimeZone = tz == null ? NULL_TIMEZONE : tz;
            this.m_dateFormat.setTimeZone(this.m_displayTimeZone);
            this.m_timeFormat.setTimeZone(this.m_displayTimeZone);
            this.fillDateTimeFields(this.m_hTime);
            return;
        }
        String date = this.m_dateField.getText();
        String time = this.m_timeField.getText();
        SimpleDateFormat sdf = new SimpleDateFormat(this.m_dateFormat.toPattern() + " " + this.m_timeFormat.toPattern());
        Date jDate = null;
        try {
            sdf.setTimeZone(this.m_displayTimeZone);
            jDate = sdf.parse(date + " " + time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jDate == null) {
            System.out.println("ERROR with Date/Time Parse");
            return;
        }
        int off = 0;
        if (this.m_dataTimeZone != null) {
            off = this.m_dataTimeZone.getRawOffset() / 60000;
        }
        HecTime hTime = new HecTime(jDate, off);
        this.m_displayTimeZone = tz == null ? NULL_TIMEZONE : (TimeZone)tz.clone();
        this.m_dateFormat.setTimeZone(this.m_displayTimeZone);
        this.m_timeFormat.setTimeZone(this.m_displayTimeZone);
        this.fillDateTimeFields(hTime);
    }
}

