/*
 * Decompiled with CFR 0.152.
 */
package rma.swing;

import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.lang.Modifiable;
import rma.services.tz.TimeZoneComponent;
import rma.swing.RmaInsets;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJDialog;
import rma.swing.RmaValidComponent;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class DateTimePanel
extends JPanel
implements RmaValidComponent,
TimeZoneComponent,
FocusListener,
Modifiable,
Cloneable {
    public static final int VERTICAL_LAYOUT = 0;
    public static final int HORIZONTAL_LAYOUT = 1;
    protected TimeZone _displayTimeZone = TimeZone.getDefault();
    protected TimeZone _dataTimeZone = null;
    protected HecTime _hTime = null;
    protected SimpleDateFormat _dateFormat = null;
    protected SimpleDateFormat _timeFormat = null;
    JLabel jDateLabel = null;
    JLabel jTimeLabel = null;
    RmaJCalendarField jDateField = null;
    RmaJ24HourTimeField jTimeField = null;
    private boolean _showTimeAsBeginningOfDay;
    private static final int MILLISEC2MIN = 60000;
    private boolean _modified;
    private boolean _ignoreModifiedEvents;
    private int _layout;

    public DateTimePanel() {
        this(0, null, null, null);
    }

    public DateTimePanel(int layout, String dateLabel, String timeLabel, String dateFmt) {
        int yinset;
        int xinset;
        int ypos;
        int xoffset;
        this.setLayout(new GridBagLayout());
        this.jDateLabel = new JLabel(dateLabel);
        this.jTimeLabel = new JLabel(timeLabel);
        if (dateFmt == null) {
            this.jDateField = new RmaJCalendarField();
            this._dateFormat = new SimpleDateFormat();
        } else {
            this.jDateField = new RmaJCalendarField(dateFmt, "");
            dateFmt = dateFmt.replace('D', 'd').replace('Y', 'y');
            this._dateFormat = new SimpleDateFormat(dateFmt);
        }
        this.jTimeField = new RmaJ24HourTimeField();
        this.jTimeField.setColumns(6);
        this.add((Component)this.jDateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jDateField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(0, 5, 0, 0), 0, 0));
        this.jDateLabel.setLabelFor(this.jDateField);
        this._layout = layout;
        if (layout == 1) {
            xoffset = 2;
            ypos = 0;
            xinset = 5;
            yinset = 0;
        } else {
            xoffset = 0;
            ypos = 1;
            xinset = 0;
            yinset = 5;
        }
        this.add((Component)this.jTimeLabel, new GridBagConstraints(xoffset + 0, ypos, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets(yinset, xinset, 0, 0), 0, 0));
        this.add((Component)this.jTimeField, new GridBagConstraints(xoffset + 1, ypos, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets(yinset, 5, 0, 0), 0, 0));
        this.jTimeLabel.setLabelFor(this.jTimeField);
        this._timeFormat = new SimpleDateFormat("HHmm");
    }

    public void setDateTime(HecTimeArray hTimeArray) {
        if (hTimeArray == null || hTimeArray.numberElements() < 1) {
            return;
        }
        this._hTime = new HecTime(hTimeArray.element(0));
        this._dataTimeZone = hTimeArray.getTimeZone();
        this._displayTimeZone = RmaJDialog.getTimeZone() != null ? RmaJDialog.getTimeZone() : this._dataTimeZone;
        this._dateFormat.setTimeZone(this._displayTimeZone);
        this._timeFormat.setTimeZone(this._displayTimeZone);
        this.fillPanel();
    }

    public void setDateTime(HecTime hTime, TimeZone dataTz) {
        if (hTime == null) {
            throw new IllegalArgumentException("NULL HecTime being set in DateTimePanel.setDateTime(HecTime, TimeZone)");
        }
        if (dataTz == null) {
            throw new IllegalArgumentException("NULL TimeZone being set in DateTimePanel.setDateTime(HecTime, TimeZone)");
        }
        this._hTime = new HecTime(hTime);
        this._dataTimeZone = dataTz;
        this._displayTimeZone = RmaJDialog.getTimeZone() != null ? RmaJDialog.getTimeZone() : dataTz;
        this._dateFormat.setTimeZone(this._displayTimeZone);
        this._timeFormat.setTimeZone(this._displayTimeZone);
        this.fillPanel();
    }

    public void setDataTimeZone(TimeZone tz) {
        this._dataTimeZone = tz;
    }

    public void setDisplayTimeZone(TimeZone tz) {
        this._displayTimeZone = tz;
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        if (tz == null) {
            return;
        }
        if (tz.equals(this._displayTimeZone)) {
            return;
        }
        if (!this.jDateField.isModified() && !this.jTimeField.isModified()) {
            this._displayTimeZone = tz;
            this._dateFormat.setTimeZone(this._displayTimeZone);
            this._timeFormat.setTimeZone(this._displayTimeZone);
            if (this._hTime != null) {
                this.fillPanel(this._hTime);
            }
            return;
        }
        String date = this.jDateField.getText();
        String time = this.jTimeField.getText();
        SimpleDateFormat sdf = new SimpleDateFormat(this._dateFormat.toPattern() + " " + this._timeFormat.toPattern());
        Date jDate = null;
        try {
            sdf.setTimeZone(this._displayTimeZone);
            jDate = sdf.parse(date + " " + time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jDate == null) {
            System.out.println("ERROR with Date/Time Parse");
            return;
        }
        HecTime hTime = new HecTime(jDate, this._dataTimeZone.getRawOffset() / 60000);
        this._displayTimeZone = (TimeZone)tz.clone();
        this._dateFormat.setTimeZone(this._displayTimeZone);
        this._timeFormat.setTimeZone(this._displayTimeZone);
        this.fillPanel();
    }

    public void setEditable(boolean b) {
        this.jDateField.setEditable(b);
        this.jTimeField.setEditable(b);
    }

    @Override
    public void setEnabled(boolean b) {
        this.jDateField.setEnabled(b);
        this.jTimeField.setEnabled(b);
        this.jDateLabel.setEnabled(b);
        this.jTimeLabel.setEnabled(b);
    }

    public void setChangeColor(Color c2) {
        this.jDateField.setChangeColor(c2);
        this.jTimeField.setChangeColor(c2);
    }

    public void setAllowsMinutes(boolean b) {
        this.jTimeField.setAllowMinutes(b);
    }

    public String getTimeUnconverted() {
        return this.jTimeField.getText();
    }

    public String getDateUnconverted() {
        return this.jDateField.getText();
    }

    public void setTimeFieldVisible(boolean visible) {
        this.jTimeField.setVisible(visible);
        this.jTimeLabel.setVisible(visible);
    }

    public String getTime() {
        if (this._hTime == null) {
            return "";
        }
        this.savePanel();
        return RMAIO.removeChar(this._hTime.time(), ':');
    }

    public String getDate(int style) {
        if (this._hTime == null) {
            return "";
        }
        this.savePanel();
        return this._hTime.date(style);
    }

    public HecTimeArray getDateTime() {
        this.savePanel();
        HecTimeArray htimeArray = new HecTimeArray(1);
        htimeArray.setElementAt(this._hTime, 0);
        htimeArray.setTimeZone(this._dataTimeZone);
        return htimeArray;
    }

    @Override
    public boolean isValid(boolean showError) {
        if (!this.jTimeField.isValid(showError)) {
            return false;
        }
        return this.jDateField.isValid(showError);
    }

    @Override
    public TimeZone getTimeZone() {
        return this._displayTimeZone;
    }

    public boolean isEditable() {
        return this.jDateField.isEditable();
    }

    @Override
    public boolean isEnabled() {
        return this.jDateField.isEnabled();
    }

    public boolean getAllowsMinutes() {
        return this.jTimeField.getAllowsMinutes();
    }

    public void fillPanel() {
        if (this._hTime == null) {
            return;
        }
        this.fillPanel(this._hTime);
    }

    public void savePanel() {
        String date = this.jDateField.getText();
        String time = this.jTimeField.getText();
        if (time.length() == 0) {
            time = "0000";
        }
        if (this._dataTimeZone.equals(this._displayTimeZone)) {
            this._hTime = new HecTime(date, time);
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this._dateFormat.toPattern() + " " + this._timeFormat.toPattern());
        Date jDate = null;
        try {
            sdf.setTimeZone(this._displayTimeZone);
            jDate = sdf.parse(date + " " + time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jDate == null) {
            System.out.println("ERROR with Date/Time Parse");
            return;
        }
        this._hTime = new HecTime(jDate, this._dataTimeZone.getRawOffset() / 60000);
        this._hTime.showTimeAsBeginningOfDay(this._showTimeAsBeginningOfDay);
    }

    public void showTimeAsBeginningOfDay(boolean b) {
        this._showTimeAsBeginningOfDay = b;
    }

    public void clear() {
        this.jDateField.setText("");
        this.jTimeField.setText("");
    }

    public void removeDateTimeFocusListener(FocusListener fl) {
        this.listenerList.remove(FocusListener.class, fl);
        EventListener[] listeners = this.getListeners(FocusListener.class);
        if (listeners.length == 0) {
            this.jDateField.removeFocusListener(this);
            this.jTimeField.removeFocusListener(this);
        }
    }

    public void addDateTimeFocusListener(FocusListener fl) {
        this.listenerList.add(FocusListener.class, fl);
        EventListener[] listeners = this.getListeners(FocusListener.class);
        if (listeners.length == 1) {
            this.jDateField.addFocusListener(this);
            this.jTimeField.addFocusListener(this);
        }
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        this.jDateField.addKeyListener(kl);
        this.jTimeField.addKeyListener(kl);
    }

    public void addActionListener(ActionListener al) {
        this.jDateField.addActionListener(al);
        this.jTimeField.addActionListener(al);
    }

    @Override
    public void focusGained(FocusEvent fe) {
        EventListener[] listeners = this.getListeners(FocusListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((FocusListener)listeners[i]).focusGained(fe);
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
        EventListener[] listeners = this.getListeners(FocusListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((FocusListener)listeners[i]).focusLost(fe);
        }
    }

    public void timeFieldRequestFocus() {
        this.jTimeField.requestFocus();
    }

    public void dateFieldRequestFocus() {
        this.jDateField.requestFocus();
    }

    private void fillPanel(HecTime htime) {
        String date;
        String s;
        if (!htime.isDefined()) {
            s = "";
            date = "";
        } else if (this._dataTimeZone.equals(this._displayTimeZone)) {
            s = htime.time();
            s = RMAIO.removeChar(s, ':');
            date = htime.date(4);
        } else {
            Date jdate = htime.getJavaDate(this._dataTimeZone.getRawOffset() / 60000);
            s = this._timeFormat.format(jdate);
            date = this._dateFormat.format(jdate);
        }
        if (!htime.getShowsTimeAsBeginningOfDay() && s.equals("0000")) {
            s = "2400";
            HecTime tmpTime = new HecTime(htime);
            tmpTime.subtract(1440);
            if (this._dataTimeZone.equals(this._displayTimeZone)) {
                date = tmpTime.date(4);
            } else {
                Date jdate = tmpTime.getJavaDate(this._dataTimeZone.getRawOffset() / 60000);
                date = this._dateFormat.format(jdate);
            }
        }
        this.jDateField.setText(date);
        this.jTimeField.setText(s);
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean modified) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        this._modified = modified;
        if (modified) {
            RMAUtil.setParentModified(this);
        } else {
            RMAUtil.setChildrenUnmodified(this);
        }
    }

    public void setIgnoreModifiedEvents(boolean b) {
        this._ignoreModifiedEvents = b;
    }

    public boolean getIgnoreModifiedEvents() {
        return this._ignoreModifiedEvents;
    }

    public DateTimePanel clone() {
        DateTimePanel newPanel = new DateTimePanel(this._layout, this.jDateLabel.getText(), this.jTimeLabel.getText(), this.jDateField.getFormat());
        newPanel.jDateField.setDocument(this.jDateField.getDocument());
        newPanel.jTimeField.setDocument(this.jDateField.getDocument());
        newPanel._showTimeAsBeginningOfDay = this._showTimeAsBeginningOfDay;
        newPanel._modified = this._modified;
        newPanel._ignoreModifiedEvents = this._ignoreModifiedEvents;
        newPanel._hTime = new HecTime(this._hTime);
        return newPanel;
    }
}

